/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICompositeGene;
import org.jgap.IGeneticOperatorConstraint;
import org.jgap.IUniversalRateCalculator;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.data.config.Configurable;
import org.jgap.impl.DefaultMutationRateCalculator;

public class MutationOperator
extends BaseGeneticOperator
implements Configurable {
    private static final String CVS_REVISION = "$Revision: 1.49 $";
    private IUniversalRateCalculator m_mutationRateCalc;
    private MutationOperatorConfigurable m_config = new MutationOperatorConfigurable();

    public MutationOperator() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public MutationOperator(Configuration a_conf) throws InvalidConfigurationException {
        super(a_conf);
        this.setMutationRateCalc(new DefaultMutationRateCalculator(a_conf));
    }

    public MutationOperator(Configuration a_config, IUniversalRateCalculator a_mutationRateCalculator) throws InvalidConfigurationException {
        super(a_config);
        this.setMutationRateCalc(a_mutationRateCalculator);
    }

    public MutationOperator(Configuration a_config, int a_desiredMutationRate) throws InvalidConfigurationException {
        super(a_config);
        this.m_config.m_mutationRate = a_desiredMutationRate;
        this.setMutationRateCalc(null);
    }

    @Override
    public void operate(Population a_population, List a_candidateChromosomes) {
        if (a_population == null || a_candidateChromosomes == null) {
            return;
        }
        if (this.m_config.m_mutationRate == 0 && this.m_mutationRateCalc == null) {
            return;
        }
        boolean mutate = false;
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        IGeneticOperatorConstraint constraint = this.getConfiguration().getJGAPFactory().getGeneticOperatorConstraint();
        for (int i = 0; i < size; ++i) {
            IChromosome chrom = a_population.getChromosome(i);
            Gene[] genes1 = chrom.getGenes();
            IChromosome copyOfChromosome = null;
            Gene[] genes = null;
            for (int j = 0; j < genes1.length; ++j) {
                if (this.m_mutationRateCalc != null) {
                    mutate = this.m_mutationRateCalc.toBePermutated(chrom, j);
                } else {
                    boolean bl = mutate = generator.nextInt(this.m_config.m_mutationRate) == 0;
                }
                if (!mutate) continue;
                if (constraint != null) {
                    Vector<IChromosome> v = new Vector<IChromosome>();
                    v.add(chrom);
                    if (!constraint.isValid(a_population, v, this)) continue;
                }
                if (copyOfChromosome == null) {
                    copyOfChromosome = (IChromosome)chrom.clone();
                    a_candidateChromosomes.add(copyOfChromosome);
                    genes = copyOfChromosome.getGenes();
                    if (this.m_monitorActive) {
                        copyOfChromosome.setUniqueIDTemplate(chrom.getUniqueID(), 1);
                    }
                }
                if (genes[j] instanceof ICompositeGene) {
                    ICompositeGene compositeGene = (ICompositeGene)genes[j];
                    if (this.m_monitorActive) {
                        compositeGene.setUniqueIDTemplate(chrom.getGene(j).getUniqueID(), 1);
                    }
                    for (int k = 0; k < compositeGene.size(); ++k) {
                        this.mutateGene(compositeGene.geneAt(k), generator);
                        if (!this.m_monitorActive) continue;
                        compositeGene.geneAt(k).setUniqueIDTemplate(((ICompositeGene)chrom.getGene(j)).geneAt(k).getUniqueID(), 1);
                    }
                    continue;
                }
                this.mutateGene((Gene)genes[j], generator);
                if (!this.m_monitorActive) continue;
                genes[j].setUniqueIDTemplate(chrom.getGene(j).getUniqueID(), 1);
            }
        }
    }

    private void mutateGene(Gene a_gene, RandomGenerator a_generator) {
        for (int k = 0; k < a_gene.size(); ++k) {
            double percentage = -1.0 + a_generator.nextDouble() * 2.0;
            a_gene.applyMutation(k, percentage);
        }
    }

    public IUniversalRateCalculator getMutationRateCalc() {
        return this.m_mutationRateCalc;
    }

    public void setMutationRateCalc(IUniversalRateCalculator a_mutationRateCalc) {
        this.m_mutationRateCalc = a_mutationRateCalc;
        if (this.m_mutationRateCalc != null) {
            this.m_config.m_mutationRate = 0;
        }
    }

    public void setMutationRate(int a_mutationRate) {
        this.m_config.m_mutationRate = a_mutationRate;
        this.setMutationRateCalc(null);
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        MutationOperator op = (MutationOperator)a_other;
        if (this.m_mutationRateCalc == null) {
            if (op.m_mutationRateCalc != null) {
                return -1;
            }
        } else if (op.m_mutationRateCalc == null) {
            return 1;
        }
        if (this.m_config.m_mutationRate != op.m_config.m_mutationRate) {
            if (this.m_config.m_mutationRate > op.m_config.m_mutationRate) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public int getMutationRate() {
        return this.m_config.m_mutationRate;
    }

    class MutationOperatorConfigurable
    implements Serializable {
        public int m_mutationRate;

        MutationOperatorConfigurable() {
        }
    }
}

