/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.dispatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class DispatchConf {
    public static String ClsPath = DispatchConf.getClassPath();
    public static String RootPath = DispatchConf.getRootPath();
    public static String SuitsXmlPath = RootPath + "qtaf/dispatch/suites/";
    public static String TestNgOutPath = RootPath + "qtaf/dispatch/testng-out/";
    public static String HtmlReportOutPath = RootPath + "qtaf/dispatch/report/" + System.currentTimeMillis() + "/";
    public static String HtmlReportTitle = "\u6d4b\u8bd5\u62a5\u544a";
    public static String TestNGXsltFile = RootPath + "qtaf/dispatch/testng-results.xsl";

    public static boolean writeConf() {
        if (!new File(TestNGXsltFile).exists()) {
            return DispatchConf.copyFile(DispatchConf.class.getResourceAsStream("/testng-results.xsl"), new File(TestNGXsltFile));
        }
        return false;
    }

    public static void delTmpPath() {
        try {
            FileUtils.deleteDirectory((File)new File(SuitsXmlPath));
            FileUtils.deleteDirectory((File)new File(TestNgOutPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getClassPath() {
        return DispatchConf.class.getClassLoader().getResource("").toString();
    }

    private static String getRootPath() {
        String path = "";
        if (DispatchConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF") != -1) {
            path = DispatchConf.class.getClassLoader().getResource("").toString().substring(6, DispatchConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF"));
            path = path + "/";
        } else {
            String temp = System.getProperty("user.dir");
            temp = temp.replace("\\", "/");
            path = temp + "/";
        }
        return path;
    }

    private static String getPropValue(String key, String defaultValue) {
        return DispatchConf.getProperties().getProperty(key, defaultValue);
    }

    private static Properties getProperties() {
        Properties prop = new Properties();
        try {
            FileInputStream file = new FileInputStream("conf.properties");
            prop.load(new InputStreamReader((InputStream)file, "UTF-8"));
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }

    private static boolean copyFile(InputStream from, File to) {
        try {
            if (!to.getParentFile().exists()) {
                to.getParentFile().mkdirs();
            }
            FileOutputStream os = new FileOutputStream(to);
            byte[] buffer = new byte[65536];
            int count = from.read(buffer);
            while (count > 0) {
                ((OutputStream)os).write(buffer, 0, count);
                count = from.read(buffer);
            }
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

