/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.dispatch;

import cn.baiweigang.qtaf.dispatch.report.TestReport;
import cn.baiweigang.qtaf.dispatch.run.TestRunInfo;
import cn.baiweigang.qtaf.dispatch.run.TestngRunSingle;
import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;

public class ExecTask {
    private LogUtil log = LogUtil.getLogger(ExecTask.class);
    private TestngRunSingle task = TestngRunSingle.getInstance();
    private TestRunInfo runInfo;
    private TestReport report = new TestReport();

    public TestReport Exec() {
        if (this.runInfo.getCaseList() == null || this.runInfo.getCaseList().size() < 1) {
            this.setResNoAndMsg(-100, "\u5f85\u6267\u884c\u7684\u7528\u4f8b\u4e0d\u5b58\u5728");
            this.log.error(this.runInfo.getTaskName() + " \u5f85\u6267\u884c\u7684\u7528\u4f8b\u4e0d\u5b58\u5728");
            return this.report;
        }
        Long startTimeMS = System.currentTimeMillis();
        Long startTime = startTimeMS / 1000L;
        int sumTime = 0;
        while (true) {
            sumTime = (int)(System.currentTimeMillis() / 1000L - startTime);
            if (!this.task.getFlag()) {
                this.task.setRunInfo(this.runInfo);
                this.report = this.task.execTask();
                long execTimes = System.currentTimeMillis() - startTimeMS;
                this.log.info(this.runInfo.getTaskName() + " \u6267\u884c\u65f6\u95f4\uff1a" + execTimes + "\u6beb\u79d2");
                this.report.setSumTime(execTimes);
                return this.report;
            }
            if (sumTime > 600) {
                this.log.info(this.runInfo.getTaskName() + " \u5df2\u7b49\u5f85" + sumTime + "\u79d2\uff0c\u8d85\u65f6\u9000\u51fa");
                this.setResNoAndMsg(-203, "\u4efb\u52a1\u7b49\u5f85\u8d85\u65f6\uff0c\u5df2\u7b49\u5f85" + sumTime + "\u79d2");
                return this.report;
            }
            this.log.info(this.runInfo.getTaskName() + " \u5728\u7b49\u5f85\u6267\u884c\uff0c\u5f53\u524d\u6709\u4efb\u52a1\u5728\u6267\u884c\u4e2d\u3002\u3002\u3002\u7b49\u5f8510\u79d2\u540e\u518d\u5c1d\u8bd5\u6267\u884c");
            CommUtils.sleep(10000);
        }
    }

    public void setRunInfo(TestRunInfo runInfo) {
        this.runInfo = runInfo;
    }

    private void setResNoAndMsg(int resNo, String resMsg) {
        this.report.setResNo(resNo);
        this.report.setResMsg(resMsg);
    }
}

