/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.dispatch.report;

import cn.baiweigang.qtaf.dispatch.DispatchConf;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportReportHtml {
    private static LogUtil log = LogUtil.getLogger(ExportReportHtml.class);

    public static boolean createHtmlReport(String tngOutFilePath, String htmlReportPath, String htmlReportTitle) {
        if (!FileUtil.isExist(tngOutFilePath)) {
            log.error("\u751f\u6210Html\u62a5\u544a\u51fa\u9519-testng\u8f93\u51fa\u7684xml\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + tngOutFilePath);
            return false;
        }
        if (!FileUtil.createDictory(htmlReportPath)) {
            log.error("\u751f\u6210Html\u62a5\u544a\u51fa\u9519-\u8f93\u51fa\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a" + htmlReportPath);
            return false;
        }
        try {
            StreamSource xml = new StreamSource(tngOutFilePath);
            StreamSource xsl = new StreamSource(DispatchConf.TestNGXsltFile);
            StreamResult out = new StreamResult(new BufferedOutputStream(new FileOutputStream(htmlReportPath + "/index.html")));
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer(xsl);
            transformer.setParameter("testNgXslt.outputDir", htmlReportPath);
            transformer.setParameter("testNgXslt.reportTitle", htmlReportTitle);
            transformer.transform(xml, out);
            log.info("\u751f\u6210Html\u6d4b\u8bd5\u62a5\u544a\u6210\u529f\uff1a" + htmlReportPath + "/index.html");
            return true;
        }
        catch (Exception e) {
            log.error("\u751f\u6210Html\u62a5\u544a\u51fa\u9519-xml\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
    }
}

