/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.dispatch.run;

import cn.baiweigang.qtaf.dispatch.DispatchConf;
import cn.baiweigang.qtaf.dispatch.report.ExportReportHtml;
import cn.baiweigang.qtaf.dispatch.report.TestReport;
import cn.baiweigang.qtaf.dispatch.report.TngCount;
import cn.baiweigang.qtaf.dispatch.run.TestRunInfo;
import cn.baiweigang.qtaf.dispatch.testcase.ICase;
import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

public class TestngRun {
    private LogUtil log = LogUtil.getLogger(TestngRun.class);
    private TestNG tng = new TestNG();
    private TestListenerAdapter listener = new TestListenerAdapter();
    private TestRunInfo runInfo;
    private List<String> xmlFileList;
    private TestReport testReport;

    public TestngRun() {
        this.tng.addListener((ITestListener)this.listener);
        this.xmlFileList = new ArrayList<String>();
        this.testReport = new TestReport();
        this.runInfo = new TestRunInfo();
    }

    public void setRunInfo(TestRunInfo runInfo) {
        this.runInfo = runInfo;
        this.log.info(this.runInfo.getTaskName() + "\u914d\u7f6e\u4efb\u52a1\u4fe1\u606f\u6210\u529f");
        for (ICase icase : this.runInfo.getCaseList()) {
            this.addXmlFileList(icase.getCaseList());
        }
    }

    public boolean run() {
        if (this.getXmlFileList().size() < 1) {
            this.testReport.setResNo(-6000);
            this.testReport.setResMsg("Xml\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
            this.log.error(this.getTaskName() + " :Xml\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
            return false;
        }
        DispatchConf.writeConf();
        this.tng.setOutputDirectory(this.getTestNgOut());
        try {
            this.tng.setTestSuites(this.getXmlFileList());
            this.tng.run();
        }
        catch (Exception e) {
            this.testReport.setResNo(-7000);
            this.testReport.setResMsg("\u6267\u884c\u7528\u4f8b\u5f02\u5e38\uff1a " + e.getMessage());
            this.log.error(this.getTaskName() + " :\u6267\u884c\u7528\u4f8b\u5f02\u5e38--" + e.getMessage());
            return false;
        }
        this.createTestReport();
        if (!this.createHtmlReport()) {
            this.testReport.setResNo(1);
            this.testReport.setResMsg("\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u8f6c\u6362Html\u683c\u5f0f\u62a5\u544a\u51fa\u9519");
            this.log.info(this.getTaskName() + " :\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u8f6c\u6362Html\u683c\u5f0f\u62a5\u544a\u51fa\u9519");
        } else {
            this.testReport.setResNo(0);
            this.testReport.setResMsg("\u4efb\u52a1\u6267\u884c\u6210\u529f");
            this.log.info(this.getTaskName() + " :\u4efb\u52a1\u6267\u884c\u6210\u529f");
        }
        return true;
    }

    public TestReport getTestReport() {
        return this.testReport;
    }

    private String getTestNgOut() {
        String out = this.runInfo.getTestng_OutPut();
        if (out == null || out.length() < 1) {
            this.log.info("\u8bbe\u7f6eTestNG\u8f93\u51fa\u76ee\u5f55\u5931\u8d25\uff1a" + this.runInfo.getTestng_OutPut());
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4\u8def\u5f84\uff1a" + DispatchConf.TestNgOutPath);
            return DispatchConf.TestNgOutPath;
        }
        if (!out.endsWith("/")) {
            out = out + "/";
        }
        return out;
    }

    private String getTaskName() {
        if (this.runInfo.getTaskName() == null || this.runInfo.getTaskName().length() < 1) {
            String taskName = "\u672a\u547d\u540d\u6d4b\u8bd5\u4efb\u52a1" + CommUtils.getRandomStr(5);
            this.log.info("\u8bbe\u7f6e\u4efb\u52a1\u540d\u5931\u8d25\uff1a" + this.runInfo.getTaskName());
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4\u4efb\u52a1\u540d\uff1a" + taskName);
            return taskName;
        }
        return this.runInfo.getTaskName();
    }

    private String getHtmlReportOut() {
        if (this.runInfo.getHtmlReportOutPath() == null || this.runInfo.getHtmlReportOutPath().length() < 1) {
            this.log.info("\u8bbe\u7f6eHtml\u8f93\u51fa\u76ee\u5f55\u5931\u8d25\uff1a" + this.runInfo.getHtmlReportOutPath());
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4Html\u8f93\u51fa\u76ee\u5f55\uff1a" + DispatchConf.HtmlReportOutPath);
            return DispatchConf.HtmlReportOutPath;
        }
        return this.runInfo.getHtmlReportOutPath();
    }

    private String getHtmlReportTitle() {
        if (null == this.runInfo.getHtmlReportTitle() || this.runInfo.getHtmlReportTitle().length() < 1) {
            this.log.info("\u8bbe\u7f6eHtml\u62a5\u544a\u6807\u9898\u5931\u8d25\uff1a" + this.runInfo.getHtmlReportTitle());
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4Html\u62a5\u544a\u6807\u9898\uff1a" + DispatchConf.HtmlReportTitle);
            return DispatchConf.HtmlReportTitle;
        }
        return this.runInfo.getHtmlReportTitle();
    }

    private List<String> getXmlFileList() {
        return this.xmlFileList;
    }

    private void addXmlFileList(List<String> xmlFileList) {
        if (null == xmlFileList) {
            this.log.error("\u6dfb\u52a0\u7684Xml\u6587\u4ef6\u5217\u8868\u4e3anull\uff0c\u6dfb\u52a0\u5931\u8d25");
            return;
        }
        for (String xmlFile : xmlFileList) {
            this.addXmlFile(xmlFile);
        }
    }

    private boolean addXmlFile(String xmlPathName) {
        if (null == xmlPathName) {
            this.log.error("\u6dfb\u52a0\u7684xml\u6587\u4ef6\u4e3anull\uff0c\u6dfb\u52a0\u5931\u8d25");
            return false;
        }
        if (!FileUtil.getExtensionName(xmlPathName).equals("xml")) {
            xmlPathName = xmlPathName + ".xml";
        }
        if (FileUtil.isExist(xmlPathName)) {
            this.log.info("\u6267\u884c\u961f\u5217\u6dfb\u52a0xml\u6587\u4ef6\u6210\u529f\uff1a" + xmlPathName);
            this.xmlFileList.add(xmlPathName);
            return true;
        }
        this.log.error("\u6dfb\u52a0\u7684xml\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + xmlPathName);
        return false;
    }

    private boolean createHtmlReport() {
        if (ExportReportHtml.createHtmlReport(this.getTestNgOut() + "testng-results.xml", this.getHtmlReportOut(), this.getHtmlReportTitle())) {
            this.testReport.setHtmlReport(this.getHtmlReportOut());
            return true;
        }
        return false;
    }

    private void createTestReport() {
        this.log.info("\u4eceTestNG\u76d1\u542c\u5668\u4e2d\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u7684\u7528\u4f8b\u4fe1\u606f");
        ArrayList<TngCount> testCountList = new ArrayList<TngCount>();
        TngCount tngCount = new TngCount();
        tngCount.setName(this.getTaskName());
        tngCount.setFailed(this.listener.getFailedTests().size());
        tngCount.setPassed(this.listener.getPassedTests().size());
        tngCount.setSkipped(this.listener.getSkippedTests().size());
        this.testReport.setTngSuiteCount(tngCount);
        List testContextList = this.listener.getTestContexts();
        for (int i = 0; i < testContextList.size(); ++i) {
            tngCount = new TngCount();
            tngCount.setName(((ITestContext)testContextList.get(i)).getName());
            tngCount.setSuiteName(((ITestContext)testContextList.get(i)).getSuite().getName());
            tngCount.setFailed(((ITestContext)testContextList.get(i)).getFailedTests().size());
            tngCount.setPassed(((ITestContext)testContextList.get(i)).getPassedTests().size());
            tngCount.setSkipped(((ITestContext)testContextList.get(i)).getSkippedTests().size());
            testCountList.add(tngCount);
        }
        this.testReport.setTaskName(this.getTaskName());
        this.testReport.setTngTestCountList(testCountList);
    }
}

