/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.dispatch.testcase;

import cn.baiweigang.qtaf.dispatch.DispatchConf;
import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class CreateXmlFile {
    private LogUtil log = LogUtil.getLogger(CreateXmlFile.class);
    private XmlSuite suite = new XmlSuite();
    private String xmlFileFolder;
    private String suiteName;

    public CreateXmlFile() {
        this.setSuiteName("\u6d4b\u8bd5\u5957\u4ef6" + CommUtils.getRandomStr(5));
        this.setXmlFileFolder(DispatchConf.SuitsXmlPath);
    }

    public String getXmlFilePath() {
        if (this.suite.getTests().size() < 1) {
            this.log.error("\u672a\u6dfb\u52a0\u4efb\u4f55\u6d4b\u8bd5\u96c6\uff0c\u672a\u751f\u6210xml\u6587\u4ef6");
            return null;
        }
        return this.createXmlFile();
    }

    public void addJavaCase(Class<?> cls) {
        if (null == cls) {
            return;
        }
        String caseName = cls.getSimpleName();
        this.addJavaCase(caseName, cls);
    }

    public void addJavaCase(String caseName, Class<?> cls) {
        if (null == cls) {
            this.log.error("\u6dfb\u52a0\u7684java\u7c7b\u4e3anull\uff0c\u6dfb\u52a0\u5931\u8d25");
            return;
        }
        if (null == caseName || caseName.length() < 1) {
            this.log.info("\u6307\u5b9a\u7684\u6d4b\u8bd5\u96c6\u4e3a\u7a7a\uff1a" + caseName);
            String nameTmp = "\u672a\u547d\u540d\u6d4b\u8bd5\u96c6" + CommUtils.getRandomStr(5);
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4\u6d4b\u8bd5\u96c6\u540d\u79f0\uff1a" + nameTmp);
            this.addClassToXmlTest(cls.getName(), nameTmp);
            return;
        }
        this.addClassToXmlTest(cls.getName(), caseName);
    }

    public void setSuiteName(String suiteName) {
        if (null != suiteName && suiteName.length() > 0) {
            this.suiteName = suiteName;
        } else {
            this.log.info("\u8bbe\u7f6e\u7684\u6d4b\u8bd5\u5957\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            this.log.info("\u4f7f\u7528\u9ed8\u8ba4\u6d4b\u8bd5\u5957\u540d\u79f0\uff1a" + this.suiteName);
        }
        this.suite.setName(this.suiteName);
    }

    public void setXmlFileFolder(String xmlFileFolder) {
        this.xmlFileFolder = xmlFileFolder;
    }

    private void addClassToXmlTest(String pkgAndClsName, String testName) {
        XmlTest xmltest = new XmlTest();
        XmlClass classe = new XmlClass(pkgAndClsName);
        xmltest.setName(testName);
        xmltest.setClasses(Arrays.asList(classe));
        this.addTest(xmltest);
    }

    private void addTest(XmlTest test) {
        if (null == test) {
            this.log.error("\u6d4b\u8bd5\u96c6\u4e3anull,\u6dfb\u52a0\u5931\u8d25");
            return;
        }
        this.suite.addTest(test);
    }

    private String createXmlFile() {
        ArrayList<String> arr = new ArrayList<String>();
        String xml = this.suite.toXml();
        String[] xx = xml.split("\n");
        for (int i = 0; i < xx.length; ++i) {
            if (xx[i].indexOf("verbose") != -1) {
                String temp = xx[i].trim();
                xx[i] = temp.substring(0, temp.indexOf("verbose") + 12) + " preserve-order=\"true\" " + temp.substring(temp.indexOf("verbose") + 12, temp.length());
            }
            arr.add(xx[i]);
        }
        String xmlName = this.getXmlFileFolder() + this.getSuiteName() + ".xml";
        if (FileUtil.writeString(arr, xmlName, "UTF-8")) {
            this.log.info("\u751f\u6210Xml\u6587\u4ef6\u6210\u529f\uff1a" + xmlName);
            return xmlName;
        }
        this.log.error("\u751f\u6210Xml\u6587\u4ef6\u5931\u8d25\uff1a" + xmlName);
        return null;
    }

    private String getSuiteName() {
        return this.suiteName;
    }

    private String getXmlFileFolder() {
        return this.xmlFileFolder;
    }
}

