/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.ift;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class IftConf {
    public static final String RootPath = IftConf.getRootPath();
    public static String IftPath = RootPath + "qtaf/ift/";
    public static String DistPath = IftConf.getDistPath();
    public static String LibPath = IftConf.getLibPath();
    public static String JarFile = "";
    public static String JavaPath = IftPath + "javaCase/";
    public static String PackageName = "cn.baiweigang.qtaf.ift.testcase";
    public static String TemplatePath = IftPath + "template/Template.ftl";
    public static String ReportPath = IftPath + "report/";
    public static String ConfFile = IftPath + "config/IftConf.properties";
    public static String ProxyEnable = IftConf.getPropValue("ProxyEnable", "Y");
    public static String ProxyIp = IftConf.getPropValue("ProxyIp", "127.0.0.1");
    public static int PROXY_PORT = Integer.parseInt(IftConf.getPropValue("ProxyPort", "8888"));
    public static final int parseJson = 1;
    public static final int urlRow = 0;
    public static final int urlCol = 1;
    public static final int methodRow = 1;
    public static final int methodCol = 1;
    public static final int cookieRow = 2;
    public static final int cookieCol = 1;
    public static final int argCountRow = 3;
    public static final int argCountCol = 1;
    public static final int typeRow = 4;
    public static final int paramStartRow = 5;
    public static final int paramStartCol = 3;
    public static final int caseIdCol = 1;
    public static final int isRunCol = 1;
    public static final int secondUrlCol = 2;

    public static void delTmpPath() {
        try {
            FileUtils.deleteDirectory((File)new File(JavaPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean writeConf() {
        boolean flag = false;
        if (!new File(ConfFile).exists()) {
            flag = IftConf.copyFile(IftConf.class.getResourceAsStream("/IftConf.properties"), new File(ConfFile));
        }
        if (!new File(TemplatePath).exists()) {
            flag = IftConf.copyFile(IftConf.class.getResourceAsStream("/Template.ftl"), new File(TemplatePath));
        }
        return flag;
    }

    public static boolean updateJarFile(String[] args) {
        block5: {
            if (JarFile.length() > 0) {
                return true;
            }
            try {
                if (null != args && args.length > 0) {
                    JarFile = args[0];
                    FileUtils.writeStringToFile((File)new File(IftPath + "JarFile"), (String)JarFile, (String)"UTF-8");
                    break block5;
                }
                if (new File(IftPath + "JarFile").exists()) {
                    FileUtils.readFileToString((File)new File(IftPath + "JarFile"), (String)"UTF-8");
                    JarFile = FileUtils.readFileToString((File)new File(IftPath + "JarFile"), (String)"UTF-8");
                    break block5;
                }
                System.out.print("\u5728eclipse\u4e2d\uff0c\u7b2c\u4e00\u6b21\u9700\u8981\u4ee5maven\u65b9\u5f0f\u6267\u884c");
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private static String getRootPath() {
        String path = "";
        if (IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF") != -1) {
            path = IftConf.class.getClassLoader().getResource("").toString().substring(6, IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF"));
            path = path + "/";
        } else {
            String temp = System.getProperty("user.dir");
            temp = temp.replace("\\", "/");
            path = temp + "/";
        }
        return path;
    }

    private static String getDistPath() {
        String path = "";
        if (IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF") != -1) {
            path = IftConf.class.getClassLoader().getResource("").toString().substring(6, IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF"));
            path = path + "/WEB-INF/classes/";
        } else {
            String temp = System.getProperty("user.dir");
            temp = temp.replace("\\", "/");
            path = temp + "/target/classes/";
        }
        return path;
    }

    private static String getLibPath() {
        String path = "";
        if (IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF") != -1) {
            path = IftConf.class.getClassLoader().getResource("").toString().substring(6, IftConf.class.getClassLoader().getResource("").toString().indexOf("WEB-INF"));
            path = path + "/WEB-INF/lib/";
        } else {
            String temp = System.getProperty("user.dir");
            temp = temp.replace("\\", "/");
            path = temp + "/lib/";
        }
        return path;
    }

    private static String getPropValue(String key, String defaultValue) {
        return IftConf.getProperties().getProperty(key, defaultValue);
    }

    private static Properties getProperties() {
        Properties prop = new Properties();
        try {
            IftConf.writeConf();
            FileInputStream file = new FileInputStream(ConfFile);
            prop.load(new InputStreamReader((InputStream)file, "UTF-8"));
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }

    private static boolean copyFile(InputStream from, File to) {
        try {
            if (!to.getParentFile().exists()) {
                to.getParentFile().mkdirs();
            }
            FileOutputStream os = new FileOutputStream(to);
            byte[] buffer = new byte[65536];
            int count = from.read(buffer);
            while (count > 0) {
                ((OutputStream)os).write(buffer, 0, count);
                count = from.read(buffer);
            }
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

