/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.ift.core;

import cn.baiweigang.qtaf.ift.IftConf;
import cn.baiweigang.qtaf.ift.core.CompareResult;
import cn.baiweigang.qtaf.ift.core.IFtResultInfo;
import cn.baiweigang.qtaf.ift.testcase.IftTestCase;
import cn.baiweigang.qtaf.ift.util.ExportReportExcel;
import cn.baiweigang.qtaf.toolkit.httpclient.HttpUtil;
import cn.baiweigang.qtaf.toolkit.httpclient.ResponseInfo;
import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CasesUtils {
    protected static LogUtil log = LogUtil.getLogger(CasesUtils.class);
    protected String getUrl = "";
    protected String postUrl = "";
    protected String httpUrl = "";
    protected TreeMap<String, String> headersMap = new TreeMap();
    protected LinkedHashMap<String, String> urlParaMap = new LinkedHashMap();
    protected LinkedHashMap<String, String> formParaMap = new LinkedHashMap();
    protected HttpUtil httpUtil;

    public CasesUtils() {
        if (IftConf.ProxyEnable.equals("Y")) {
            log.info("\u5df2\u8bbe\u7f6e\u4f7f\u7528\u4ee3\u7406\uff1a" + IftConf.ProxyIp + ":" + IftConf.PROXY_PORT);
            this.httpUtil = new HttpUtil(IftConf.ProxyIp, IftConf.PROXY_PORT);
        } else {
            log.info("\u672a\u8bbe\u7f6e\u4ee3\u7406");
            this.httpUtil = new HttpUtil();
        }
    }

    public ResponseInfo execResquest(IftTestCase testCase) {
        ResponseInfo resInfo = new ResponseInfo();
        log.info("\u53d1\u8d77\u8bf7\u6c42\u4f7f\u7528\u7684\u7f16\u7801\u4e3a\uff1a" + testCase.getEnCoding());
        this.httpUtil.setCharset(testCase.getEnCoding());
        if (!this.updateHttpUrl(testCase)) {
            log.error("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6http\u5730\u5740\u5931\u8d25");
            resInfo.setErrMsgInfo("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6http\u5730\u5740\u5931\u8d25");
            return resInfo;
        }
        if (!this.updateUrlPara(testCase)) {
            log.error("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6url\u53c2\u6570\u4fe1\u606f\u5931\u8d25");
            resInfo.setErrMsgInfo("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6url\u53c2\u6570\u4fe1\u606f\u5931\u8d25");
            return resInfo;
        }
        if (!this.updateFormParaMap(testCase)) {
            log.error("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6post\u53c2\u6570\u4fe1\u606f\u5931\u8d25");
            resInfo.setErrMsgInfo("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6post\u53c2\u6570\u4fe1\u606f\u5931\u8d25");
            return resInfo;
        }
        if (!this.updateHeadersMap(testCase)) {
            log.error("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6headers\u4fe1\u606f\u5931\u8d25");
            resInfo.setErrMsgInfo("\u53d1\u8d77http\u8bf7\u6c42\u65f6\uff0c\u83b7\u53d6headers\u4fe1\u606f\u5931\u8d25");
            return resInfo;
        }
        try {
            if (testCase.getHttpMethod().equalsIgnoreCase("get")) {
                resInfo = this.httpUtil.get(this.headersMap, this.httpUrl + this.getUrl);
                resInfo.setHttpUrl(this.httpUrl + this.getUrl);
            } else if (testCase.getHttpMethod().equalsIgnoreCase("post")) {
                resInfo = this.httpUtil.post(this.headersMap, this.httpUrl + this.getUrl, this.postUrl);
                resInfo.setHttpUrl("post\u8bf7\u6c42\u7684url\u4fe1\u606f\uff1a" + this.httpUrl + this.postUrl);
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001http\u8bf7\u6c42\u5f02\u5e38");
            log.error("httpurl:" + this.httpUrl);
            log.error("getUrl:" + this.getUrl);
            log.error("postUrl:" + this.postUrl);
            log.error(e.getMessage());
            resInfo.setErrMsgInfo("\u53d1\u9001http\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u67e5\u770b\u6267\u884c\u65e5\u5fd7\u8bb0\u5f55");
            return resInfo;
        }
        return resInfo;
    }

    public IFtResultInfo getIFtResultInfo(ResponseInfo resInfo, String expRes, String actRes) {
        return this.getIFtResultInfo(resInfo, expRes, actRes, 1);
    }

    public IFtResultInfo getIFtResultInfo(ResponseInfo resInfo, String expRes, String actRes, int parseJson) {
        IFtResultInfo iFtResultInfo = new IFtResultInfo();
        CompareResult comresult = new CompareResult();
        boolean compareRes = false;
        if (resInfo.getErrMsgInfo() == null) {
            compareRes = comresult.getCompareResult(expRes, actRes, parseJson);
            actRes = comresult.getClearActres();
            expRes = comresult.getClearExpres();
        } else {
            resInfo.setResBodyInfo(resInfo.getErrMsgInfo());
            actRes = "";
        }
        iFtResultInfo.setResponseInfo(resInfo);
        iFtResultInfo.setCompareRes(compareRes);
        iFtResultInfo.setActRes(actRes);
        iFtResultInfo.setExpRes(expRes);
        return iFtResultInfo;
    }

    public void closeConn() {
        this.httpUtil.close();
    }

    protected boolean updateHttpUrl(IftTestCase testCase) {
        String httpUrlTmp = testCase.getUrl();
        if (null == httpUrlTmp || httpUrlTmp.length() < 1) {
            log.error("\u7528\u4f8b\u8bf7\u6c42\u7684http\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        String secondurl = testCase.getCaseMap().get("secondurl");
        if (null != secondurl && !secondurl.equals("")) {
            if (secondurl.equals("rand")) {
                secondurl = CommUtils.getRandomStr(5);
            }
            httpUrlTmp = httpUrlTmp + secondurl;
        }
        this.httpUrl = httpUrlTmp;
        return true;
    }

    protected boolean updateUrlPara(IftTestCase testCase) {
        this.urlParaMap = new LinkedHashMap();
        String urlTmp = "";
        if (null == testCase.getParalist()) {
            log.error("\u4f20\u5165\u7684httpurl\u7684\u53c2\u6570\u540d\u5217\u8868\u4e3anull\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        if (testCase.getParalist().size() < 1) {
            urlTmp = "";
        } else {
            for (int i = 0; i < testCase.getParalist().size(); ++i) {
                String value = testCase.getCaseMap().get(testCase.getParalist().get(i));
                if (value.toLowerCase().equals("null")) continue;
                if (value.matches("[0-9a-zA-Z.]*")) {
                    this.urlParaMap.put(testCase.getParalist().get(i), value);
                    urlTmp = urlTmp + testCase.getParalist().get(i) + "=" + value + "&";
                    continue;
                }
                value = CommUtils.urlEncode(value, testCase.getEnCoding());
                this.urlParaMap.put(testCase.getParalist().get(i), value);
                urlTmp = urlTmp + testCase.getParalist().get(i) + "=" + value + "&";
            }
            if (!StringUtil.IsNullOrEmpty(urlTmp)) {
                urlTmp = urlTmp.substring(0, urlTmp.length() - 1);
            }
            this.getUrl = urlTmp;
        }
        return true;
    }

    protected boolean updateFormParaMap(IftTestCase testcase) {
        this.formParaMap = new LinkedHashMap();
        String postTmp = "";
        if (null == testcase.getFormlist()) {
            log.error("\u4f20\u5165\u7684form\u53c2\u6570\u540d\u5217\u8868\u4e3anull\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        if (testcase.getFormlist().size() < 1) {
            postTmp = "";
        } else {
            for (int i = 0; i < testcase.getFormlist().size(); ++i) {
                String value = testcase.getCaseMap().get(testcase.getFormlist().get(i));
                if (value.toLowerCase().equals("null")) continue;
                if (value.matches("[0-9a-zA-Z.]*")) {
                    this.formParaMap.put(testcase.getFormlist().get(i), value);
                    postTmp = postTmp + testcase.getFormlist().get(i) + "=" + value + "&";
                    continue;
                }
                value = CommUtils.urlEncode(value, testcase.getEnCoding());
                this.formParaMap.put(testcase.getFormlist().get(i), value);
                postTmp = postTmp + testcase.getFormlist().get(i) + "=" + value + "&";
            }
            if (!StringUtil.IsNullOrEmpty(postTmp)) {
                postTmp = postTmp.substring(0, postTmp.length() - 1);
            }
            this.postUrl = postTmp;
        }
        return true;
    }

    protected boolean updateHeadersMap(IftTestCase testcase) {
        this.headersMap = null != testcase.getHeaderMap() ? testcase.getHeaderMap() : new TreeMap();
        if (null == testcase.getHeaderlist()) {
            log.error("\u4f20\u5165\u7684headers\u53c2\u6570\u540d\u5217\u8868\u4e3anull\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        for (int i = 0; i < testcase.getHeaderlist().size(); ++i) {
            String value = testcase.getCaseMap().get(testcase.getHeaderlist().get(i));
            if (value.toLowerCase().equals("null")) continue;
            if (value.matches("[0-9a-zA-Z.]*")) {
                this.headersMap.put(testcase.getHeaderlist().get(i), value);
                continue;
            }
            value = CommUtils.urlEncode(value, testcase.getEnCoding());
            this.headersMap.put(testcase.getHeaderlist().get(i), value);
        }
        if (null != testcase.getCookie() && testcase.getCookie().length() > 0) {
            this.headersMap.put("Cookie", testcase.getCookie());
        }
        return true;
    }

    protected static TreeMap<String, String> getSignMap(IftTestCase testcase) {
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        if (null == testcase.getSignlist()) {
            log.error("\u4f20\u5165\u7684\u7b7e\u540d\u53c2\u6570\u540d\u5217\u8868\u4e3anull\uff0c\u8bf7\u68c0\u67e5");
            return signMap;
        }
        for (int i = 0; i < testcase.getSignlist().size(); ++i) {
            String value = testcase.getCaseMap().get(testcase.getSignlist().get(i));
            if (value.toLowerCase().equals("null")) continue;
            signMap.put(testcase.getSignlist().get(i), value);
        }
        return signMap;
    }

    protected static IftTestCase updateAllToListForCase(IftTestCase testcase, String[] urlParaCheck, String[] formParaCheck, String[] headerParaCheck) {
        ArrayList<String> signList = new ArrayList<String>();
        ArrayList<String> urlParaList = new ArrayList<String>();
        ArrayList<String> formParaList = new ArrayList<String>();
        ArrayList<String> headersParaList = new ArrayList<String>();
        Iterator<Map.Entry<String, String>> it = testcase.getCaseMap().entrySet().iterator();
        int i = 0;
        String[] argKey = new String[testcase.getCaseMap().size()];
        String[] argValue = new String[testcase.getCaseMap().size()];
        while (it.hasNext()) {
            Map.Entry<String, String> entity = it.next();
            argKey[i] = entity.getKey().toString();
            argValue[i] = entity.getValue().toString();
            ++i;
        }
        testcase.setSignFlag(true);
        try {
            for (int j = 3; j < argValue.length; ++j) {
                int n;
                if (testcase.getArgCount() == 0) {
                    testcase.setSignFlag(false);
                } else {
                    if (j < 3 + testcase.getArgCount()) {
                        signList.add(argKey[j]);
                    }
                    if (j == 3 + testcase.getArgCount()) {
                        testcase.setSignKey(argKey[j]);
                    }
                }
                for (n = 0; n < urlParaCheck.length; ++n) {
                    if (!argKey[j].toLowerCase().equals(urlParaCheck[n].toLowerCase())) continue;
                    urlParaList.add(argKey[j]);
                }
                for (n = 0; n < formParaCheck.length; ++n) {
                    if (!argKey[j].toLowerCase().equals(formParaCheck[n].toLowerCase())) continue;
                    formParaList.add(argKey[j]);
                }
                for (n = 0; n < headerParaCheck.length; ++n) {
                    if (!argKey[j].toLowerCase().equals(headerParaCheck[n].toLowerCase())) continue;
                    headersParaList.add(argKey[j]);
                }
            }
            testcase.setParalist(urlParaList);
            testcase.setFormlist(formParaList);
            testcase.setHeaderlist(headersParaList);
            testcase.setSignlist(signList);
        }
        catch (Exception e) {
            log.error("\u4f20\u5165\u7684\u7528\u4f8b\u5b9e\u4f53\u7c7b\u4fe1\u606f\u6709\u8bef\uff0c\u65e0\u6cd5\u5b8c\u6210\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5");
            log.error(e.getMessage());
        }
        return testcase;
    }

    protected static IftTestCase updateSignValueForCase(IftTestCase testCase, String signValue) {
        LinkedHashMap<String, String> caseMap = testCase.getCaseMap();
        if (!testCase.isSignFlag()) {
            log.info("\u65e0\u9700\u8ba1\u7b97\u7b7e\u540d");
            return testCase;
        }
        String value = caseMap.get(testCase.getSignKey());
        if (value.length() < 1) {
            value = "";
        } else if (!value.equalsIgnoreCase("null")) {
            value = signValue;
        }
        caseMap.put(testCase.getSignKey(), value);
        testCase.setCaseMap(caseMap);
        return testCase;
    }

    protected static IftTestCase updateAllParaForCase(IftTestCase testCase, int randNum) {
        LinkedHashMap<String, String> caseMap = testCase.getCaseMap();
        if (null == caseMap || caseMap.size() < 1) {
            log.error("\u7528\u4f8b\u7684\u53c2\u6570\u503c\u5bf9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return testCase;
        }
        for (Map.Entry<String, String> entity : caseMap.entrySet()) {
            String key = entity.getKey().toString();
            String value = entity.getValue().toString();
            if (value.toLowerCase().equalsIgnoreCase("rand")) {
                value = CommUtils.getRandomStr(randNum);
                caseMap.put(key, value);
            }
            if (value.toLowerCase().equalsIgnoreCase("timestamp")) {
                value = CommUtils.getTimestamp();
                caseMap.put(key, value);
            }
            if (!value.toLowerCase().equalsIgnoreCase("date")) continue;
            value = CommUtils.getStrRandNum(3);
            caseMap.put(key, value);
        }
        testCase.setCaseMap(caseMap);
        return testCase;
    }

    protected static IftTestCase updateCookieForCase(IftTestCase testCase) {
        String cookies = "";
        cookies = null == testCase.getCookie() || testCase.getCookie().length() < 1 ? "" : testCase.getCookie();
        if (cookies.contains(";")) {
            String cookiesTmp = "";
            TreeMap<Object, Object> cookieMap = new TreeMap();
            cookieMap = CommUtils.parseQuery(cookies, ';', '=');
            for (Map.Entry<Object, Object> entry : cookieMap.entrySet()) {
                cookiesTmp = cookiesTmp + (String)entry.getKey() + "=" + CommUtils.urlEncode(((String)entry.getValue()).toString(), testCase.getEnCoding()) + ";";
            }
            cookies = cookiesTmp;
        }
        testCase.setCookie(cookies);
        return testCase;
    }

    public boolean CreatReportExcel(String folder, String excelName, String sheetName, List<LinkedHashMap<String, String>> arrres) {
        ExportReportExcel exportexcel = new ExportReportExcel();
        return exportexcel.CreatReportExcel(folder, excelName, sheetName, arrres);
    }

    public ResponseInfo ExecPostResquest(TreeMap<String, String> header, String http, String posturl) {
        ResponseInfo resInfo = new ResponseInfo();
        this.httpUtil.setCharset("UTF-8");
        try {
            resInfo = this.httpUtil.post(header, http, posturl);
            resInfo.setHttpUrl("post\u8bf7\u6c42\u7684url\u4fe1\u606f\uff1a" + http + "  post\u8bf7\u6c42\u7684body\u4fe1\u606f\u4e3a-" + posturl);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001http\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            log.error(e.getMessage());
            resInfo.setErrMsgInfo("\u53d1\u9001http\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            return resInfo;
        }
        return resInfo;
    }

    public ResponseInfo ExecGetResquest(TreeMap<String, String> header, String gethttpurl) {
        ResponseInfo resInfo = new ResponseInfo();
        this.httpUtil.setCharset("UTF-8");
        try {
            resInfo = this.httpUtil.get(header, gethttpurl);
            resInfo.setHttpUrl(gethttpurl);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001http\u8bf7\u6c42" + gethttpurl + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            log.error(e.getMessage());
            resInfo.setErrMsgInfo("\u53d1\u9001http\u8bf7\u6c42" + gethttpurl + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            return resInfo;
        }
        return resInfo;
    }
}

