/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.ift.testcase.autocreate;

import cn.baiweigang.qtaf.dispatch.testcase.CreateXmlFile;
import cn.baiweigang.qtaf.dispatch.testcase.SuperCase;
import cn.baiweigang.qtaf.ift.IftConf;
import cn.baiweigang.qtaf.ift.testcase.autocreate.CreateJavaFile;
import cn.baiweigang.qtaf.ift.testcase.autocreate.JavaCaseInfo;
import cn.baiweigang.qtaf.ift.testcase.format.FormatCase;
import cn.baiweigang.qtaf.toolkit.util.CompilerUtil;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.util.List;

public class IftDataFileCase
extends SuperCase {
    private LogUtil log = LogUtil.getLogger(IftDataFileCase.class);
    private String taskName;
    private String allReportPath;
    private String excelReportName;
    private CreateJavaFile createJavaFile = new CreateJavaFile();
    private CreateXmlFile createXmlFile = new CreateXmlFile();

    public IftDataFileCase() {
        this.setIftTaskName("\u672a\u547d\u540d\u6d4b\u8bd5\u4efb\u52a1");
        this.excelReportName = "\u672a\u547d\u540d\u63a5\u53e3\u6d4b\u8bd5";
    }

    @Override
    public List<String> getCaseList() {
        this.createXmlFile();
        return this.xmlPathNameList;
    }

    public void addCase(String casePath, String sheetName, String caseName, Class<?> cls, String method) {
        if (StringUtil.IsNullOrEmpty(casePath) || StringUtil.IsNullOrEmpty(caseName)) {
            return;
        }
        JavaCaseInfo javaCaseInfo = new JavaCaseInfo();
        FormatCase formatcase = new FormatCase();
        formatcase.FormatCaseFromObj(casePath, sheetName);
        javaCaseInfo.setAllCase(formatcase.getTestCase());
        this.excelReportName = "\u6d4b\u8bd5\u62a5\u544a_" + formatcase.getCasesetName();
        javaCaseInfo.setPackageName(IftConf.PackageName);
        javaCaseInfo.setJavaFileName(caseName.replace(".", "_"));
        javaCaseInfo.setJavaSavePath(IftConf.JavaPath);
        javaCaseInfo.setCaseDataPathName(casePath);
        javaCaseInfo.setCaseDataSheetName(sheetName);
        javaCaseInfo.setExcelReportSheetName(sheetName);
        javaCaseInfo.setExcelReportName(this.excelReportName);
        javaCaseInfo.setExcelReportPath(this.getReportPath());
        javaCaseInfo.setCls(cls);
        javaCaseInfo.setMethod(method);
        if (!this.createJavaFile.creatJavaSrcFile(javaCaseInfo)) {
            return;
        }
        if (!CompilerUtil.dynamicCompiler(javaCaseInfo.getJavaSavePath() + javaCaseInfo.getJavaFileName() + ".java", IftConf.DistPath, IftConf.LibPath, IftConf.JarFile)) {
            return;
        }
        try {
            this.createXmlFile.addJavaCase(caseName.replace(".", "_"), Class.forName(javaCaseInfo.getPackageName() + "." + javaCaseInfo.getJavaFileName()));
            this.log.info("\u6dfb\u52a0\u6d4b\u8bd5\u96c6\uff1a" + javaCaseInfo.getJavaFileName() + "\u6210\u529f");
        }
        catch (ClassNotFoundException e) {
            this.log.error("\u6dfb\u52a0\u6d4b\u8bd5\u96c6\uff1a" + javaCaseInfo.getJavaFileName() + "\u5931\u8d25");
            this.log.error(e.getMessage());
        }
    }

    public void addCase(String casePath, String caseName, Class<?> cls, String method) {
        this.addCase(casePath, "TestCase", caseName, cls, method);
    }

    public void setIftTaskName(String setTaskName) {
        this.taskName = setTaskName;
        this.createXmlFile.setSuiteName(this.taskName);
        this.setReportPath(IftConf.ReportPath + this.taskName + "/");
        this.excelReportName = this.taskName;
    }

    public void setReportPath(String reportPath) {
        if (FileUtil.createDictory(reportPath)) {
            this.allReportPath = reportPath;
            FileUtil.delFolder(this.getReportPath());
        }
    }

    public String getReportPath() {
        return this.allReportPath;
    }

    public String getExcelReportPath() {
        return this.getReportPath() + this.excelReportName + ".xlsx";
    }

    public String getHtmlReportPath() {
        return this.allReportPath + "html";
    }

    public String getTaskName() {
        return this.taskName;
    }

    private boolean createXmlFile() {
        String xmlFilePath = this.createXmlFile.getXmlFilePath();
        if (FileUtil.isExist(xmlFilePath)) {
            this.xmlPathNameList.add(xmlFilePath);
            this.log.info("\u6dfb\u52a0xml\u6587\u4ef6\u6210\u529f\uff1a" + xmlFilePath);
            return true;
        }
        this.log.error("\u6dfb\u52a0xml\u6587\u4ef6\u5931\u8d25\uff1a" + xmlFilePath);
        return false;
    }
}

