/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.ift.testcase.format;

import cn.baiweigang.qtaf.ift.testcase.IftTestCase;
import cn.baiweigang.qtaf.ift.testcase.format.ReadCaseFromExcel;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class FormatCase {
    private static LogUtil log = LogUtil.getLogger(FormatCase.class);
    private List<LinkedHashMap<String, String>> arrCase = new ArrayList<LinkedHashMap<String, String>>();
    private List<IftTestCase> testCase = new ArrayList<IftTestCase>();
    private String url = "";
    private String httpMethod = "";
    private int argcount = 0;
    private String cookie = "";
    private String casesetName = "";
    private String sheetName = "";

    public void FormatCaseFromObj(String casePath, String sheetName) {
        this.FormatCaseFromExcel(casePath, sheetName);
        this.casesetName = casePath.substring(casePath.lastIndexOf("/") + 1, casePath.length() - (FileUtil.getExtensionName(casePath).length() + 1));
        this.sheetName = sheetName;
    }

    private void getTestCaseFromExcel(String pathName, String sheetName) {
        ReadCaseFromExcel readCase = new ReadCaseFromExcel(pathName, sheetName);
        this.url = readCase.readUrl();
        this.httpMethod = readCase.readHttpMethod();
        this.argcount = readCase.readArgCount();
        this.cookie = readCase.readCookie();
        String[] argKey = readCase.readArgKey();
        for (int j = 5; j < readCase.getRowNum(); ++j) {
            IftTestCase tempcase = new IftTestCase();
            tempcase.setArgCount(this.getArgcount());
            tempcase.setHttpMethod(this.getHttpMethod());
            tempcase.setUrl(this.getUrl());
            tempcase.setCookie(this.cookie);
            String[] argValue = readCase.readArgValue(j);
            if (!argValue[1].equals("Y")) continue;
            LinkedHashMap<String, String> mycase = new LinkedHashMap<String, String>();
            for (int i = 0; i < argKey.length; ++i) {
                if (null != argValue[i] && argKey[i].equals("cookie") && argValue[i].length() > 0) {
                    tempcase.setCookie(argValue[i]);
                }
                mycase.put(argKey[i], argValue[i]);
            }
            this.arrCase.add(mycase);
            tempcase.setCaseMap(mycase);
            tempcase.setCaseId(mycase.get("CaseID"));
            tempcase.setTestPoint(mycase.get("TestPoint"));
            this.testCase.add(tempcase);
        }
    }

    public void FormatCaseFromExcel(String casefilepath) {
        this.getTestCaseFromExcel(casefilepath, "Sheet1");
    }

    public void FormatCaseFromExcel(String casefilepath, String casesheetname) {
        if (null == casesheetname | casesheetname.length() < 1) {
            casesheetname = "Sheet1";
        }
        this.getTestCaseFromExcel(casefilepath, casesheetname);
    }

    public void FormatCaseFromXml(String casefilepath) {
    }

    public List<LinkedHashMap<String, String>> getArrCase() {
        return this.arrCase;
    }

    public List<IftTestCase> getTestCase() {
        return this.testCase;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public int getArgcount() {
        return this.argcount;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getCasesetName() {
        return this.casesetName;
    }

    public String getSheetName() {
        return this.sheetName;
    }
}

