/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.ift.util;

import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.ExcelUtil;
import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportReportExcel {
    public boolean CreatReportExcel(String excelreportpath, String filename, ArrayList<LinkedHashMap<String, String>> arrres) {
        boolean flag = false;
        flag = this.CreatReportExcel(excelreportpath, filename, null, arrres);
        return flag;
    }

    public boolean CreatReportExcel(String excelreportpath, String filename, String sheetname, List<LinkedHashMap<String, String>> arrres) {
        boolean flag = false;
        List<String> title = null;
        List<String[]> content = null;
        if (filename.indexOf("/") != -1 || filename.indexOf("xls") != -1 || filename.length() < 1) {
            filename = "\u672a\u547d\u540d";
        }
        title = this.getTitle();
        content = this.getContentFromMap(arrres);
        this.writeExcel(title, content, sheetname, filename, excelreportpath);
        return flag;
    }

    private List<String> getTitle() {
        LinkedList<String> title = new LinkedList<String>();
        title.add("CaseID");
        title.add("TestPoint");
        title.add("ExpRes");
        title.add("ActRes");
        title.add("ExcResult");
        title.add("ResponseRes");
        title.add("Httpurl");
        return title;
    }

    private List<String[]> getContentFromMap(List<LinkedHashMap<String, String>> arrres) {
        LinkedList<String[]> content = new LinkedList<String[]>();
        List<String> title = this.getTitle();
        for (int i = 0; i < arrres.size(); ++i) {
            String[] str = new String[title.size()];
            for (int j = 0; j < title.size(); ++j) {
                str[j] = arrres.get(i).get(title.get(j));
            }
            content.add(str);
        }
        return content;
    }

    private void writeExcel(List<String> title, List<String[]> datas, String sheetName, String excelName, String excelreportpath) {
        ExcelUtil excel = new ExcelUtil();
        String pathName = excelreportpath + "/" + excelName + ".xlsx";
        if (!FileUtil.isExist(pathName)) {
            excel.createBlankExcel2007(pathName);
        }
        excel.setPathName(pathName);
        XSSFWorkbook wb = (XSSFWorkbook)excel.getWb();
        this.updateWbFromContent(wb, title, datas, sheetName);
        excel.writeExcel2007(wb, pathName);
    }

    private void updateWbFromContent(XSSFWorkbook wb, List<String> title, List<String[]> datas, String sheetName) {
        int i;
        XSSFSheet sheet;
        if (null == sheetName | sheetName.length() < 1) {
            sheet = wb.createSheet();
        } else {
            if (null != wb.getSheet(sheetName)) {
                sheetName = sheetName + CommUtils.getRandomStr(5);
            }
            sheet = wb.createSheet(sheetName);
        }
        sheet.setColumnWidth(0, 3825);
        sheet.setColumnWidth(1, 6375);
        sheet.setColumnWidth(2, 10200);
        sheet.setColumnWidth(3, 10200);
        sheet.setColumnWidth(4, 2550);
        sheet.setColumnWidth(5, 12750);
        sheet.setColumnWidth(6, 3825);
        sheet.setColumnWidth(7, 5100);
        sheet.setColumnWidth(8, 2550);
        XSSFRow row = sheet.createRow(0);
        XSSFFont fonttitle = wb.createFont();
        fonttitle.setItalic(true);
        fonttitle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fonttitle.setBoldweight((short)700);
        XSSFCellStyle styletitle = wb.createCellStyle();
        styletitle.setFillForegroundColor(IndexedColors.BRIGHT_GREEN.getIndex());
        styletitle.setFillPattern((short)1);
        styletitle.setFont((Font)fonttitle);
        styletitle.setBorderLeft((short)1);
        styletitle.setBorderRight((short)1);
        styletitle.setBorderTop((short)1);
        styletitle.setBorderBottom((short)1);
        XSSFFont fontRed = wb.createFont();
        fontRed.setColor((short)17);
        fontRed.setColor(IndexedColors.RED.getIndex());
        fontRed.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fontRed.setBoldweight((short)700);
        fontRed.setFontHeightInPoints((short)11);
        XSSFCellStyle styleRed = wb.createCellStyle();
        styleRed.setFont((Font)fontRed);
        styleRed.setBorderLeft((short)1);
        styleRed.setBorderRight((short)1);
        styleRed.setBorderTop((short)1);
        styleRed.setBorderBottom((short)1);
        XSSFFont fontGreen = wb.createFont();
        fontGreen.setColor(IndexedColors.GREEN.getIndex());
        fontGreen.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fontGreen.setBoldweight((short)700);
        fontGreen.setFontHeightInPoints((short)11);
        XSSFCellStyle styleGreen = wb.createCellStyle();
        styleGreen.setFont((Font)fontGreen);
        styleGreen.setBorderLeft((short)1);
        styleGreen.setBorderRight((short)1);
        styleGreen.setBorderTop((short)1);
        styleGreen.setBorderBottom((short)1);
        XSSFFont fontBlack = wb.createFont();
        fontBlack.setColor(IndexedColors.BLACK.getIndex());
        fontBlack.setFontName("Arial");
        fontBlack.setFontHeightInPoints((short)9);
        XSSFCellStyle styleBlack = wb.createCellStyle();
        styleBlack.setFont((Font)fontBlack);
        styleBlack.setBorderLeft((short)1);
        styleBlack.setBorderRight((short)1);
        styleBlack.setBorderTop((short)1);
        styleBlack.setBorderBottom((short)1);
        for (i = 0; i < title.size(); ++i) {
            XSSFCell cell = row.createCell(i, 1);
            cell.setCellValue(title.get(i));
            cell.setCellStyle((CellStyle)styletitle);
        }
        for (i = 0; i < datas.size(); ++i) {
            String[] rowvalue = datas.get(i);
            XSSFRow nextrow = sheet.createRow(sheet.getLastRowNum() + 1);
            for (int j = 0; j < rowvalue.length; ++j) {
                XSSFCell cell = nextrow.createCell(j, 1);
                cell.setCellValue((RichTextString)new XSSFRichTextString(rowvalue[j]));
                if (rowvalue[j].equals("Fail")) {
                    cell.setCellStyle((CellStyle)styleRed);
                    continue;
                }
                if (rowvalue[j].equals("Pass")) {
                    cell.setCellStyle((CellStyle)styleGreen);
                    continue;
                }
                cell.setCellStyle((CellStyle)styleBlack);
            }
        }
    }
}

