/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.dbunit;

import cn.baiweigang.qtaf.toolkit.dbunit.data.excel.XlsDataSet;
import cn.baiweigang.qtaf.toolkit.mysql.ConnMysql;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlMetadataHandler;

public class DbUnitUtil {
    private static final LogUtil log = LogUtil.getLogger(DbUnitUtil.class);

    public static void writeToFileFromMysql(String destFilePath, ConnMysql mysql, String querySqlsSplitBySemicolon) {
        DbUnitUtil.writeToFileFromDataBase(destFilePath, mysql.getConnection(), querySqlsSplitBySemicolon);
    }

    public static ITable getTableFromMysql(ConnMysql mysql, String resultName, String querySql) {
        return DbUnitUtil.getTableFromDataBase(mysql.getConnection(), resultName, querySql);
    }

    public static IDataSet getDataSetFromMysql(ConnMysql mysql, String querySqlsSplitBySemicolon) {
        return DbUnitUtil.getDataSetFromDataBase(mysql.getConnection(), querySqlsSplitBySemicolon);
    }

    public static DatabaseConnection getDatabaseConnectionFromMysql(ConnMysql mysql) {
        return DbUnitUtil.getDatabaseConnection(mysql.getConnection());
    }

    public static void writeToFileFromDataBase(IDatabaseConnection databaseConnection, String destFilePath) {
        IDataSet dataSet = null;
        try {
            dataSet = databaseConnection.createDataSet();
        }
        catch (Exception e) {
            log.error("\u672a\u83b7\u53d6\u5230\u6d4b\u8bd5\u96c6");
            log.error(e.getMessage());
            return;
        }
        DbUnitUtil.writeToFileFromDataSet(dataSet, destFilePath);
    }

    public static void writeToFileFromDataBase(String destFilePath, IDatabaseConnection databaseConnection, String querySqlsSplitBySemicolon) {
        DbUnitUtil.writeToFileFromDataSet(DbUnitUtil.getDataSetFromDataBase(databaseConnection, querySqlsSplitBySemicolon), destFilePath);
    }

    public static void writeToFileFromDataBase(String destFilePath, Connection connection, String querySqlsSplitBySemicolon) {
        DbUnitUtil.writeToFileFromDataSet(DbUnitUtil.getDataSetFromDataBase(connection, querySqlsSplitBySemicolon), destFilePath);
    }

    public static void writeToFileFromDataSet(IDataSet dataSet, String destFilePath) {
        File destFile = new File(destFilePath);
        try {
            String destFileName = destFile.getName();
            if (destFileName.endsWith(".xls")) {
                XlsDataSet.write(dataSet, new FileOutputStream(destFile));
            } else if (destFileName.endsWith(".xml")) {
                FlatXmlDataSet.write((IDataSet)dataSet, (OutputStream)new FileOutputStream(destFile));
            } else {
                log.error("\u6587\u4ef6\u683c\u5f0f\u4e0d\u662fxls\u6216\u8005xml\uff0c\u4e0d\u652f\u6301");
                return;
            }
            log.info("\u5199\u5165\u6570\u636e\u5230\u6587\u4ef6 : " + destFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u636e\u5230\u6587\u4ef6\u5931\u8d25");
            log.error(e.getMessage());
        }
    }

    public static IDataSet getDataSetFromDataBase(Connection connection, String querySqlsSplitBySemicolon) {
        return DbUnitUtil.getDataSetFromDataBase((IDatabaseConnection)DbUnitUtil.getDatabaseConnection(connection), querySqlsSplitBySemicolon);
    }

    public static IDataSet getDataSetFromDataBase(IDatabaseConnection databaseConnection, String querySqlsSplitBySemicolon) {
        String[] querySqls = querySqlsSplitBySemicolon.split(";");
        QueryDataSet queryDataSet = null;
        try {
            queryDataSet = new QueryDataSet(databaseConnection);
            for (int i = 0; i < querySqls.length; ++i) {
                queryDataSet.addTable(DbUnitUtil.getTableNameFromQuerySql(querySqls[i]), querySqls[i]);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25!");
            log.error(e.getMessage());
        }
        return queryDataSet;
    }

    public static ITable getTableFromDataBase(Connection connection, String resultName, String querySql) {
        ITable table = null;
        try {
            table = DbUnitUtil.getDatabaseConnection(connection).createQueryTable(resultName, querySql);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25!");
            log.error(e.getMessage());
        }
        return table;
    }

    public static DatabaseConnection getDatabaseConnection(Connection connection) {
        DatabaseConnection databaseConnection = null;
        try {
            databaseConnection = new DatabaseConnection(connection);
            DatabaseConfig config = databaseConnection.getConfig();
            if ("MySQL".equalsIgnoreCase(connection.getMetaData().getDatabaseProductName())) {
                config.setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)new MySqlMetadataHandler());
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
            }
        }
        catch (SQLException | DatabaseUnitException e) {
            log.error("\u521b\u5efadbunit\u7684\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
            log.error(e.getMessage());
            return null;
        }
        return databaseConnection;
    }

    private static String getTableNameFromQuerySql(String querySql) {
        String tableName = null;
        String[] array = querySql.split(" ");
        for (int i = 0; i < array.length; ++i) {
            if (!"From".equalsIgnoreCase(array[i].trim())) continue;
            tableName = array[i + 1].trim();
            break;
        }
        return tableName;
    }
}

