/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.dbunit.data.excel;

import cn.baiweigang.qtaf.toolkit.QtafException;
import org.apache.commons.lang.StringUtils;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class XlsTableWrapper
extends AbstractTable {
    private ITable delegate;
    private String tableName;

    public XlsTableWrapper(String tableName, ITable table) {
        this.delegate = table;
        this.tableName = tableName;
    }

    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    public ITableMetaData getTableMetaData() {
        ITableMetaData meta = this.delegate.getTableMetaData();
        try {
            return new DefaultTableMetaData(this.tableName, meta.getColumns(), meta.getPrimaryKeys());
        }
        catch (DataSetException e) {
            throw new QtafException("Don't get the meta info from  " + meta, e);
        }
    }

    public Object getValue(int row, String column) throws DataSetException {
        Object delta = this.delegate.getValue(row, column);
        if (delta instanceof String && StringUtils.isEmpty((String)((String)delta))) {
            return null;
        }
        return delta;
    }
}

