/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.httpclient;

import cn.baiweigang.qtaf.toolkit.httpclient.ResponseInfo;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    protected LogUtil log = LogUtil.getLogger(this.getClass());
    private String charset = "UTF-8";
    private HttpClient httpClient = new DefaultHttpClient();
    private HttpGet httpGet;
    private HttpPost httpPost;
    private HttpResponse response;

    public HttpUtil() {
        this.httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
    }

    public HttpUtil(String charset) {
        this();
        this.charset = charset;
    }

    public HttpUtil(String ip, int port) {
        this();
        HttpHost proxy = new HttpHost(ip, port);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public ResponseInfo get(Map<String, String> headers, String url) {
        ResponseInfo resInfo = new ResponseInfo();
        if (StringUtil.IsNullOrEmpty(url)) {
            this.log.error("url\u4e3a\u7a7a");
            resInfo.setResBodyInfo("url\u4e3a\u7a7a");
            return resInfo;
        }
        this.httpGet = new HttpGet(url);
        this.httpGet = this.setHttpGetHeader(this.httpGet, headers);
        return this.get(this.httpGet);
    }

    public ResponseInfo get(String url) {
        return this.get(null, url);
    }

    public ResponseInfo post(TreeMap<String, String> headers, String url, TreeMap<String, Object> params) {
        this.httpPost = new HttpPost(url);
        this.httpPost = this.setHttpPostHeaderAndParams(this.httpPost, headers, params);
        return this.post(this.httpPost);
    }

    public ResponseInfo post(TreeMap<String, String> headers, String url, String str) {
        ResponseInfo resInfo = new ResponseInfo();
        if (StringUtil.IsNullOrEmpty(url)) {
            this.log.error("url\u4e3a\u7a7a");
            resInfo.setResBodyInfo("url\u4e3a\u7a7a");
            return resInfo;
        }
        this.httpPost = new HttpPost(url);
        this.httpPost = this.setHttpPostHeaderAndParams(this.httpPost, headers, null);
        return this.post(this.httpPost, str);
    }

    public String getFile(Map<String, String> headers, String url, String enCoding) {
        if (StringUtil.IsNullOrEmpty(enCoding)) {
            enCoding = "UTF-8";
        }
        this.httpGet = new HttpGet(url);
        this.httpGet = this.setHttpGetHeader(this.httpGet, headers);
        try {
            return new String(this.getFile(this.httpGet), enCoding);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("getFile\u6267\u884c\u5f02\u5e38207\uff1a");
            this.log.error(e.getMessage());
            return "";
        }
    }

    public byte[] getFile(Map<String, String> headers, String url, File file) {
        this.httpGet = new HttpGet(url);
        this.httpGet = this.setHttpGetHeader(this.httpGet, headers);
        byte[] bs = this.getFile(this.httpGet);
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(bs);
            output.close();
        }
        catch (FileNotFoundException e) {
            this.log.error("getFile\u6267\u884c\u5f02\u5e38223\uff1a");
            this.log.error(e.getMessage());
        }
        catch (IOException e) {
            this.log.error("getFile\u6267\u884c\u5f02\u5e38226\uff1a");
            this.log.error(e.getMessage());
        }
        return bs;
    }

    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public void setCharset(String charset) {
        if (null != charset && charset.length() > 0) {
            this.charset = charset;
        }
    }

    public Map<String, String> getCommonHeader() {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Accept-Charset", "GBK,utf-8;q=0.7,*;q=0.3");
        headers.put("Accept-Language", "zh-CN,zh;q=0.8");
        headers.put("User-Agent", "Q-Test-Automation-Framework-QTAF/1.0.1 Apache-HttpClient/4.2.5 (java 1.7)");
        headers.put("Accept", "*/*");
        headers.put("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        return headers;
    }

    private HttpGet setHttpGetHeader(HttpGet httpGet, Map<String, String> headers) {
        Map<Object, Object> headersTmp = new TreeMap();
        headersTmp = this.getCommonHeader();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entrytmp : headers.entrySet()) {
                headersTmp.put(entrytmp.getKey().toString(), entrytmp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> entry : headersTmp.entrySet()) {
            httpGet.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return httpGet;
    }

    private ResponseInfo get(HttpGet httpget) {
        ResponseInfo resInfo = new ResponseInfo();
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpget);
        }
        catch (ClientProtocolException e) {
            this.log.error("get\u6267\u884c\u5f02\u5e38291\uff1a");
            this.log.error(e.getMessage());
        }
        catch (IOException e) {
            this.log.error("get\u6267\u884c\u5f02\u5e38294\uff1a");
            this.log.error(e.getMessage());
        }
        resInfo.setResBodyInfo(this.getResBody(this.response));
        resInfo.setResHeaderInfo(this.getResHeader(this.response));
        return resInfo;
    }

    private HttpPost setHttpPostHeaderAndParams(HttpPost httpPost, Map<String, String> headers, Map<String, Object> params) {
        Map<Object, Object> headersTmp = new TreeMap();
        headersTmp = this.getCommonHeader();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entrytmp : headers.entrySet()) {
                headersTmp.put(entrytmp.getKey().toString(), entrytmp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> entry1 : headersTmp.entrySet()) {
            httpPost.addHeader(entry1.getKey().toString(), entry1.getValue().toString());
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry2 : params.entrySet()) {
                nvps.add(new BasicNameValuePair(entry2.getKey().toString(), entry2.getValue().toString()));
            }
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("post\u8bbe\u7f6e\u5f02\u5e38338\uff1a");
            this.log.error(e.getMessage());
        }
        return httpPost;
    }

    private byte[] getFile(HttpGet httpget) {
        byte[] in;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            in = EntityUtils.toByteArray((HttpEntity)entity);
            if (entity != null) {
                entity.consumeContent();
            }
        }
        catch (ClientProtocolException e) {
            this.log.error("getFile\u6267\u884c\u5f02\u5e38357\uff1a");
            this.log.error(e.getMessage());
            in = null;
        }
        catch (IOException e) {
            this.log.error("getFile\u6267\u884c\u5f02\u5e38361\uff1a");
            this.log.error(e.getMessage());
            in = null;
        }
        return in;
    }

    private ResponseInfo post(HttpPost httppost) {
        HttpResponse response;
        try {
            response = this.httpClient.execute((HttpUriRequest)httppost);
        }
        catch (ClientProtocolException e) {
            this.log.error("post\u6267\u884c\u5f02\u5e38378\uff1a");
            this.log.error(e.getMessage());
            response = null;
        }
        catch (IOException e) {
            this.log.error("post\u6267\u884c\u5f02\u5e38382\uff1a");
            this.log.error(e.getMessage());
            response = null;
        }
        ResponseInfo resInfo = new ResponseInfo();
        resInfo.setResBodyInfo(this.getResBody(response));
        resInfo.setResHeaderInfo(this.getResHeader(response));
        httppost.abort();
        return resInfo;
    }

    private ResponseInfo post(HttpPost httppost, String str) {
        try {
            StringEntity reqEntity = new StringEntity(str);
            httppost.setEntity((HttpEntity)reqEntity);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("post\u6267\u884c\u5f02\u5e38405\uff1a");
            this.log.error(e.getMessage());
        }
        return this.post(httppost);
    }

    private Map<String, String> getResHeader(HttpResponse res) {
        TreeMap<String, String> headerRes = new TreeMap<String, String>();
        if (null == res) {
            return headerRes;
        }
        Header[] headers = res.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            headerRes.put(headers[i].getName(), headers[i].getValue());
        }
        return headerRes;
    }

    private String getResBody(HttpResponse res) {
        String strResult = "";
        if (res == null) {
            return strResult;
        }
        if (res.getStatusLine().getStatusCode() == 200) {
            try {
                strResult = strResult + EntityUtils.toString((HttpEntity)res.getEntity(), (String)this.charset);
            }
            catch (ParseException e) {
                this.log.error("\u83b7\u53d6body\u4fe1\u606f\u5f02\u5e38450\uff1a");
                this.log.error(e.getMessage());
                strResult = e.getMessage().toString();
            }
            catch (IOException e) {
                this.log.error("\u83b7\u53d6body\u4fe1\u606f\u5f02\u5e38454\uff1a");
                this.log.error(e.getMessage());
                strResult = e.getMessage().toString();
            }
        } else {
            if (res.getStatusLine().getStatusCode() == 302) {
                String url = res.getLastHeader("Location").getValue();
                res.setStatusCode(200);
                strResult = url;
                return strResult;
            }
            strResult = "Error Response:" + res.getStatusLine().toString();
            if (res.getEntity() != null) {
                try {
                    res.getEntity().consumeContent();
                }
                catch (IOException e) {
                    this.log.error("\u83b7\u53d6body\u4fe1\u606f\u5f02\u5e38469\uff1a");
                    this.log.error(e.getMessage());
                }
            }
        }
        return strResult;
    }
}

