/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.mysql;

import cn.baiweigang.qtaf.toolkit.mysql.ConnMysql;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MysqlUtil {
    private static Connection con = null;
    private static LogUtil log = LogUtil.getLogger(MysqlUtil.class);
    private static ConnMysql mysql;

    public static void connMysql(String ip, String port, String dataName, String userName, String passWord) {
        if (con == null) {
            if (null == mysql) {
                mysql = new ConnMysql();
                MysqlUtil.mysql.ip = ip;
                MysqlUtil.mysql.port = port;
                MysqlUtil.mysql.dataName = dataName;
                MysqlUtil.mysql.userName = userName;
                MysqlUtil.mysql.passWord = passWord;
            }
            con = mysql.getConnection();
        }
    }

    public static void reConnMysql(String ip, String port, String dataName, String userName, String passWord) {
        MysqlUtil.closedConn();
        MysqlUtil.connMysql(ip, port, dataName, userName, passWord);
    }

    public static void closedConn() {
        if (con != null) {
            mysql.closedConn();
            con = null;
        }
    }

    public static boolean excSql(String sql) {
        if (null == con) {
            return false;
        }
        return mysql.excSql(sql);
    }

    public static List<Map<String, String>> queryBySql(String sql) {
        return MysqlUtil.getMapFromResult(MysqlUtil.querySql(sql));
    }

    public static List<Map<String, String>> queryFromTable(String tablename) {
        String sql = "select * from " + tablename;
        return MysqlUtil.getMapFromResult(MysqlUtil.querySql(sql));
    }

    public static List<Map<String, String>> queryFromTable(String tablename, List<String> keyList) {
        return MysqlUtil.getMapByKeyList(MysqlUtil.queryFromTable(tablename), keyList);
    }

    public static List<Map<String, String>> queryFromTableByIf(String tablename, String wherestr) {
        String sql = "select * from " + tablename + " where " + wherestr;
        return MysqlUtil.getMapFromResult(MysqlUtil.querySql(sql));
    }

    public static String queryFromTableByIf(String tablename, String wherestr, String keyname) {
        Map<Object, Object> map = new TreeMap();
        try {
            map = MysqlUtil.queryFromTableByIf(tablename, wherestr).get(0);
            return ((String)map.get(keyname)).toString();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f02\u5e38");
            log.error(e.getMessage());
            return "";
        }
    }

    public static String queryTableBysqlMax(String sql) {
        String max = "";
        try {
            ResultSet res = MysqlUtil.querySql(sql);
            res.next();
            max = res.getString(1);
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u6700\u5927\u503c\u5931\u8d25\uff01");
            log.error(e.getMessage());
        }
        return max;
    }

    public static List<Map<String, String>> getMapFromSql(String tableName, String whereStr, List<String> keyList) {
        return MysqlUtil.getMapByKeyList(MysqlUtil.queryFromTableByIf(tableName, whereStr), keyList);
    }

    public static List<Map<String, String>> getMapFromSql(String tablename, String wherestr, Map<String, String> expMap) {
        List<String> keyList = StringUtil.getKeyListFromMap(expMap);
        return MysqlUtil.getMapFromSql(tablename, wherestr, keyList);
    }

    private static ResultSet querySql(String sql) {
        if (null == con) {
            return null;
        }
        return mysql.querySql(sql);
    }

    private static boolean ResultIsNull(ResultSet res) {
        if (null == res) {
            return true;
        }
        try {
            res.last();
            if (res.getRow() == 0) {
                log.info("\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a0\u6761");
                return true;
            }
            res.beforeFirst();
            return false;
        }
        catch (SQLException e) {
            log.error("\u8ba1\u7b97\u67e5\u8be2\u7ed3\u679c\u96c6\u4e2a\u6570\u5931\u8d25!");
            log.error(e.getMessage());
            return true;
        }
    }

    private static List<Map<String, String>> getMapFromResult(ResultSet rs) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        if (null == rs) {
            return mapList;
        }
        try {
            if (MysqlUtil.ResultIsNull(rs)) {
                log.error(" \u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return mapList;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String key = "";
                    String value = "";
                    key = rsmd.getColumnName(i).toString();
                    try {
                        value = rs.getObject(i).toString();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    map.put(key, value);
                }
                mapList.add(map);
            }
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u5f02\u5e38");
            log.error(e.getMessage());
        }
        return mapList;
    }

    private static List<Map<String, String>> getMapByKeyList(List<Map<String, String>> mapTmpList, List<String> keyList) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        if (null == keyList || keyList.size() < 1) {
            log.error("\u8981\u83b7\u53d6\u7684\u5217\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return mapList;
        }
        if (null == mapTmpList || mapTmpList.size() < 1) {
            return mapList;
        }
        for (int i = 0; i < mapTmpList.size(); ++i) {
            TreeMap<String, String> mapTmp = new TreeMap<String, String>();
            for (int j = 0; j < keyList.size(); ++j) {
                String key = keyList.get(j);
                String value = StringUtil.getValueFromMapByKey(mapTmpList.get(i), key);
                mapTmp.put(key, value);
            }
            mapList.add(mapTmp);
        }
        return mapList;
    }
}

