/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.mysql.dao;

import cn.baiweigang.qtaf.toolkit.mysql.MysqlUtil;
import cn.baiweigang.qtaf.toolkit.mysql.dao.ITable;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DaoUtil {
    private static LogUtil log = LogUtil.getLogger(DaoUtil.class);

    public static List<ITable> getAllInfo(ITable table) {
        String tablename = DaoUtil.getNameOfClass(table);
        List<String> keyList = DaoUtil.getCoList(table);
        List<Map<String, String>> resMapList = MysqlUtil.queryFromTable(tablename, keyList);
        return DaoUtil.getTableFromMap(resMapList, table);
    }

    public static List<ITable> getInfoByKey(String where, ITable table) {
        String tablename = DaoUtil.getNameOfClass(table);
        List<String> keyList = DaoUtil.getCoList(table);
        List<Map<String, String>> resMapList = MysqlUtil.getMapFromSql(tablename, where, keyList);
        return DaoUtil.getTableFromMap(resMapList, table);
    }

    public static List<ITable> getInfoBySql(String sql, ITable table) {
        List<Map<String, String>> resMapList = MysqlUtil.queryBySql(sql);
        return DaoUtil.getTableFromMap(resMapList, table);
    }

    public static String getMaxInfoByKey(String key, ITable table) {
        String tablename = DaoUtil.getNameOfClass(table);
        String max = "";
        String sql = "SELECT MAX(" + key + ") from " + tablename;
        max = MysqlUtil.queryTableBysqlMax(sql);
        if (null == max || max.length() < 1) {
            max = "0";
        }
        return max;
    }

    public static boolean updateInfo(String key, String value, ITable table) {
        boolean flag = false;
        String sql = DaoUtil.getUpdateSql(key, value, table);
        flag = MysqlUtil.excSql(sql);
        return flag;
    }

    public static boolean insterInfo(ITable table) {
        boolean flag = false;
        String sql = DaoUtil.getInsertSql(table);
        flag = MysqlUtil.excSql(sql);
        return flag;
    }

    public static boolean deleteInfoByKey(String key, String value, ITable table) {
        boolean flag = false;
        String sql = "DELETE from " + DaoUtil.getNameOfClass(table) + " where " + key + "='" + value + "'";
        flag = MysqlUtil.excSql(sql);
        return flag;
    }

    public static List<String> getCoList(ITable table) {
        ArrayList<String> colList = new ArrayList<String>();
        Field[] field = table.getClass().getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            Field f = field[i];
            f.setAccessible(true);
            try {
                colList.add(f.getName());
                continue;
            }
            catch (IllegalArgumentException e1) {
                colList = null;
                log.error("\u83b7\u53d6\u5b9e\u4f53\u7c7b" + table.getClass().getSimpleName() + "\u7684\u7b2c" + (i + 1) + "\u4e2a\u5b57\u6bb5\u5931\u8d25");
                log.error(e1.getMessage());
            }
        }
        return colList;
    }

    public static boolean set(String key, String value, ITable table) {
        boolean flag = false;
        List<String> coList = DaoUtil.getCoList(table);
        for (int i = 0; i < coList.size(); ++i) {
            if (!key.equals(coList.get(i))) continue;
            try {
                Class[] parameterTypes = new Class[1];
                Field field = table.getClass().getDeclaredField(key);
                parameterTypes[0] = field.getType();
                Method m = table.getClass().getMethod(DaoUtil.getMethodByName("set", key), parameterTypes);
                m.invoke((Object)table, value);
                flag = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                flag = false;
                log.error("\u5bf9\u5b9e\u4f53\u7c7b" + table.getClass().getSimpleName() + "\u7684\u5b57\u6bb5" + key + "\u8d4b\u503c\u5931\u8d25");
                log.error(e.getMessage());
            }
            break;
        }
        return flag;
    }

    public static String get(String key, ITable table) {
        String res = "";
        List<String> coList = DaoUtil.getCoList(table);
        for (int i = 0; i < coList.size(); ++i) {
            if (!key.equals(coList.get(i))) continue;
            try {
                Method m = table.getClass().getMethod(DaoUtil.getMethodByName("get", key), new Class[0]);
                res = m.invoke((Object)table, new Object[0]).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                res = null;
                log.error("\u4ece\u5b9e\u4f53\u7c7b" + table.getClass().getSimpleName() + "\u7684\u5b57\u6bb5" + key + "\u53d6\u503c\u5931\u8d25");
                log.error(e.getMessage());
            }
            break;
        }
        return res;
    }

    private static String getNameOfClass(Object cls) {
        return cls.getClass().getSimpleName();
    }

    private static String getUpdateSql(String key, String value, ITable table) {
        String sql = "update " + DaoUtil.getNameOfClass(table) + " set ";
        List<String> colList = DaoUtil.getCoList(table);
        for (int i = 0; i < colList.size(); ++i) {
            try {
                Method m = table.getClass().getMethod(DaoUtil.getMethodByName("get", colList.get(i)), new Class[0]);
                String temp = m.invoke((Object)table, new Object[0]).toString();
                sql = sql + colList.get(i) + " = '" + temp + "',";
                m = null;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u62fc\u63a5\u8868" + table.getClass().getSimpleName() + "\u7684\u5217" + colList.get(i) + "\u7684update\u8bed\u53e5\u5f02\u5e38");
                log.error(e.getMessage());
            }
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + " where " + key + " = " + value;
        return sql;
    }

    private static String getInsertSql(ITable table) {
        String sql = "insert into " + DaoUtil.getNameOfClass(table);
        List<String> keyList = DaoUtil.getCoList(table);
        String key = "";
        String value = "";
        for (int i = 0; i < keyList.size(); ++i) {
            try {
                Method m = table.getClass().getMethod(DaoUtil.getMethodByName("get", keyList.get(i)), new Class[0]);
                String temp = m.invoke((Object)table, new Object[0]).toString();
                key = key + keyList.get(i) + ",";
                value = value + "'" + temp + "',";
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u62fc\u63a5\u8868" + table.getClass().getSimpleName() + "\u7684\u5217" + keyList.get(i) + "\u7684Insert\u8bed\u53e5\u5f02\u5e38");
                log.error(e.getMessage());
            }
        }
        key = key.substring(0, key.length() - 1);
        value = value.substring(0, value.length() - 1);
        sql = sql + " (" + key + ") values(" + value + ")";
        return sql;
    }

    private static List<ITable> getTableFromMap(List<Map<String, String>> resMapList, ITable table) {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        if (null == resMapList || resMapList.size() < 1) {
            return tableList;
        }
        for (int i = 0; i < resMapList.size(); ++i) {
            ITable tableTmp = DaoUtil.getNewInstanceByClassdeep(table);
            Map<Object, Object> mapTmp = new TreeMap();
            mapTmp = resMapList.get(i);
            for (Map.Entry<Object, Object> entry : mapTmp.entrySet()) {
                String key = ((String)entry.getKey()).toString();
                String value = ((String)entry.getValue()).toString();
                DaoUtil.set(key, value, tableTmp);
            }
            tableList.add(tableTmp);
        }
        return tableList;
    }

    private static String getMethodByName(String method, String fildeName) {
        return method + DaoUtil.getFirstCapitalized(fildeName);
    }

    private static String getFirstCapitalized(String fildeName) {
        byte[] items = fildeName.getBytes();
        items[0] = (byte)((char)items[0] - 97 + 65);
        return new String(items);
    }

    private static ITable getNewInstanceByClassdeep(ITable table) {
        try {
            Class<?> clazz = Class.forName(table.getClass().getName());
            ITable table2 = (ITable)clazz.newInstance();
            return table2;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

