/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TreeMap;

public class CommUtils {
    private static LogUtil log = LogUtil.getLogger(CommUtils.class);

    public static String getMD5(String source, String enCoding) {
        byte[] sourceByte = null;
        try {
            sourceByte = source.getBytes(enCoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u6309\u7f16\u7801\uff1a" + enCoding + "\u89e3\u6790\u4e3a\u5b57\u8282\u5f02\u5e38");
            log.error(e.getMessage());
            return null;
        }
        return CommUtils.getMD5(sourceByte);
    }

    public static String getMD5Gbk(String source) {
        return CommUtils.getMD5(source, "GBK");
    }

    public static String fileMD5(String filepath) {
        byte[] bytes = null;
        try {
            bytes = CommUtils.getBytesFromFile(filepath);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + filepath);
            log.error(e.getMessage());
            return null;
        }
        return CommUtils.getMD5(bytes);
    }

    public static String urlEncode(String strmes) {
        return CommUtils.urlEncode(strmes, "GBK");
    }

    public static String urlEncode(String strmes, String enCoding) {
        String EncodeRes;
        try {
            EncodeRes = URLEncoder.encode(strmes, enCoding);
        }
        catch (UnsupportedEncodingException e) {
            EncodeRes = null;
            log.error("\u6307\u5b9a\u7684\u7f16\u7801\uff1a" + enCoding + "\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5");
            log.error(e.getMessage());
        }
        return EncodeRes;
    }

    public static String urlDecode(String strmes) {
        return CommUtils.urlDecode(strmes, "GBK");
    }

    public static String urlDecode(String strmes, String encoding) {
        String decodeRes;
        try {
            decodeRes = URLDecoder.decode(strmes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            decodeRes = null;
            log.error(e.getMessage());
        }
        return decodeRes;
    }

    public static String urlRawDecode(String strmes) {
        String decodeRes;
        try {
            String tmpdecodeRes = URLDecoder.decode(strmes, "GBK");
            decodeRes = tmpdecodeRes.replace(" ", "+");
        }
        catch (UnsupportedEncodingException e) {
            decodeRes = null;
            log.error(e.getMessage());
        }
        return decodeRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRandomStr(int length) {
        Random randGen = null;
        char[] numbersAndLetters = null;
        Object initLock = new Object();
        if (length < 1) {
            return null;
        }
        if (randGen == null) {
            Object object = initLock;
            synchronized (object) {
                if (randGen == null) {
                    randGen = new Random();
                    numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
                }
            }
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumRandomStr(int length) {
        Random randGen = null;
        char[] numbersAndLetters = null;
        Object initLock = new Object();
        if (length < 1) {
            return null;
        }
        if (randGen == null) {
            Object object = initLock;
            synchronized (object) {
                if (randGen == null) {
                    randGen = new Random();
                    numbersAndLetters = "0123456789".toCharArray();
                }
            }
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static TreeMap<String, String> parseQuery(String query, char split1, char split2) {
        if (!StringUtil.IsNullOrEmpty(query) && query.indexOf(split2) > 0) {
            TreeMap<String, String> result = new TreeMap<String, String>();
            String name = null;
            String value = null;
            String tempValue = "";
            int len = query.length();
            for (int i = 0; i < len; ++i) {
                char c = query.charAt(i);
                if (c == split2) {
                    value = "";
                    continue;
                }
                if (c == split1) {
                    result.put(name, value);
                    name = null;
                    value = null;
                    continue;
                }
                if (value != null) {
                    value = value + c;
                    continue;
                }
                name = name != null ? name + c : "" + c;
            }
            if (!StringUtil.IsNullOrEmpty(name) && value != null) {
                result.put(name, value);
            }
            return result;
        }
        return null;
    }

    public static String getSha1(byte[] byteText) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("sha-1");
            md.update(byteText);
            byte[] sha1 = md.digest();
            return CommUtils.byte2hex(sha1);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String getHash(String fileName, String hashType) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance(hashType);
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            ((InputStream)fis).close();
            return CommUtils.toHexString(md5.digest());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String toHexString(byte[] b) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String getNowTime() {
        String nowTime = "";
        Date date = new Date();
        SimpleDateFormat from = new SimpleDateFormat("yyyMMddHHmmss");
        nowTime = from.format(date);
        return nowTime;
    }

    public static String getTimestamp() {
        String nowTime = Long.toString(new Date().getTime() / 1000L);
        return nowTime;
    }

    public static void sleep(int miliSeconds) {
        try {
            Thread.sleep(miliSeconds);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage());
        }
    }

    public static String getRandNum(int num) {
        String res = "";
        if (num < 1) {
            return res;
        }
        String[] arr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < num; ++i) {
            Random ran = new Random();
            int index = ran.nextInt(10);
            res = res + arr[index];
        }
        return res;
    }

    public static String getStrRandNum(int num) {
        return CommUtils.getNowTime() + CommUtils.getRandNum(num);
    }

    private static byte[] getBytesFromFile(String filepath) throws IOException {
        File file = new File(filepath);
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static String getMD5(byte[] source) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return s;
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toLowerCase();
    }
}

