/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompilerUtil {
    private static LogUtil log = LogUtil.getLogger(CompilerUtil.class);

    public static boolean dynamicCompiler(String javaFilePath, String distPath, String libPath, String jarFile) {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean compilerResult = CompilerUtil.compiler("UTF-8", CompilerUtil.getClassPath(libPath, distPath, jarFile), javaFilePath, distPath, diagnostics);
        if (compilerResult) {
            log.info("\u52a8\u6001\u7f16\u8bd1\u6210\u529f\uff1a" + javaFilePath + "  \u8f93\u51fa\u76ee\u5f55\u4e3a\uff1a" + distPath);
        } else {
            log.error("\u52a8\u6001\u7f16\u8bd1\u5931\u8d25\uff1a" + javaFilePath);
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
                log.error(diagnostic.getMessage(null));
            }
        }
        return compilerResult;
    }

    private static boolean compiler(String encoding, String jars, String filePath, String distDir, DiagnosticCollector<JavaFileObject> diagnostics) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        if (StringUtil.IsNullOrEmpty(filePath)) {
            log.info("\u5f85\u7f16\u8bd1\u7684\u6587\u4ef6\u6216\u76ee\u5f55\u4e0d\u5b58\u5728");
            return false;
        }
        if (!FileUtil.createDictory(distDir)) {
            log.error("\u8f93\u51fa\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
            return false;
        }
        File sourceFile = new File(filePath);
        List<Object> sourceFileList = new ArrayList();
        sourceFileList = CompilerUtil.getSourceFiles(sourceFile);
        if (sourceFileList.size() == 0) {
            log.error(filePath + "\u76ee\u5f55\u4e0b\u67e5\u627e\u4e0d\u5230\u4efb\u4f55java\u6587\u4ef6");
            return false;
        }
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFileList);
        List<String> options = Arrays.asList("-encoding", encoding, "-classpath", jars, "-d", distDir);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        boolean res = compilationTask.call();
        try {
            fileManager.close();
        }
        catch (IOException e) {
            log.error("\u5173\u95ed\u6587\u4ef6\u7ba1\u7406\u5668\u5931\u8d25");
            log.error(e.getMessage());
        }
        return res;
    }

    private static List<File> getSourceFiles(File sourceFile) {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        if (sourceFile.exists() && sourceFileList != null) {
            if (sourceFile.isDirectory()) {
                List<String> sourceFileListTmp = FileUtil.getFilesFromFolder(sourceFile.getPath(), "java");
                for (String filePath : sourceFileListTmp) {
                    sourceFileList.add(new File(filePath));
                }
            } else {
                sourceFileList.add(sourceFile);
            }
        } else {
            log.error("\u76ee\u5f55\u6216\u6587\u4ef6\u4e0d\u5b58\u5728: " + sourceFile);
        }
        return sourceFileList;
    }

    private static String getJarFiles(String libPath, String jarFile) {
        String jarsPath = "";
        List<String> jarFilePath = FileUtil.getFilesFromFolder(libPath, "jar");
        for (String filePath : jarFilePath) {
            jarsPath = jarsPath + filePath + ";";
        }
        jarsPath = jarsPath + jarFile;
        return jarsPath;
    }

    private static String getClassPath(String libPath, String classPath, String jarFile) {
        if (FileUtil.isExist(classPath)) {
            return CompilerUtil.getJarFiles(libPath, jarFile) + classPath;
        }
        log.error("classPath\u4e0d\u5b58\u5728\uff1a" + classPath);
        return CompilerUtil.getJarFiles(libPath, jarFile);
    }
}

