/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static LogUtil log = LogUtil.getLogger(ExcelUtil.class);
    private Workbook wb;
    private Sheet sheet;
    private String pathName;

    public ExcelUtil() {
    }

    public ExcelUtil(String pathName) {
        this.pathName = pathName;
        this.setWb();
    }

    public ExcelUtil(String pathName, String sheetName) {
        this.pathName = pathName;
        this.setWb();
        this.setSheet(sheetName);
    }

    public ExcelUtil(String pathName, int sheetIndex) {
        this.pathName = pathName;
        this.setWb();
        this.setSheet(sheetIndex);
    }

    public void writeExcel2007(XSSFWorkbook wb, String pathName) {
        try {
            wb.write((OutputStream)FileUtil.getFileOutStream(pathName));
        }
        catch (IOException e) {
            log.error("\u5199\u5165Excel\u6587\u4ef6\u5931\u8d25\uff1a" + pathName);
            log.error(e.getMessage());
        }
    }

    public Workbook getWb() {
        return this.wb;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
        this.setWb();
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
        this.delBankRow();
    }

    public void setSheet(String sheetName) {
        if (null == this.wb) {
            return;
        }
        this.setSheet(this.getWb().getSheet(sheetName));
        if (null == this.getSheet()) {
            this.setSheet(this.getWb().getSheetAt(0));
            if (null == this.getSheet()) {
                log.error("Excel\uff1a" + this.pathName + "\u4e2d\uff0c\u4e0d\u5b58\u5728\u4efb\u4f55Sheet");
            }
        }
    }

    public void setSheet(int sheetIndex) {
        block3: {
            if (null == this.wb) {
                return;
            }
            try {
                this.setSheet(this.getWb().getSheetAt(sheetIndex));
            }
            catch (Exception e) {
                log.error("Excel\uff1a" + this.pathName + "\u4e2d\uff0c\u8981\u83b7\u53d6\u7684\u7b2c" + sheetIndex + "\u4e2asheet\u4e0d\u5b58\u5728," + "\u9ed8\u8ba4\u83b7\u53d6\u7b2c\u4e00\u4e2aSheet1");
                this.setSheet(this.getWb().getSheetAt(0));
                if (null != this.getSheet()) break block3;
                log.error("Excel\uff1a" + this.pathName + "\u4e2d\uff0c\u4e0d\u5b58\u5728\u4efb\u4f55Sheet");
            }
        }
    }

    public String getCellValue(int rowIndex, int colIndex) {
        if (colIndex < 0) {
            log.error("\u8bfb\u53d6Excel\u7684\u5217\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570");
            return null;
        }
        Row row = this.getRow(rowIndex);
        if (null == row) {
            return null;
        }
        return this.getStrFromCell(row.getCell(colIndex));
    }

    public List<String> getRowList(int rowIndex) {
        ArrayList<String> reslist = new ArrayList<String>();
        Row row = this.getRow(rowIndex);
        if (null != row) {
            for (int i = 0; i < this.getColNum(); ++i) {
                reslist.add(this.getCellValue(rowIndex, i));
            }
        }
        return reslist;
    }

    public int getRowNum() {
        if (null == this.getSheet()) {
            return 0;
        }
        return this.getSheet().getLastRowNum() + 1;
    }

    public int getColNum() {
        int max = 0;
        if (null == this.getSheet()) {
            return 0;
        }
        if (this.getSheet().getPhysicalNumberOfRows() < 1) {
            return 0;
        }
        for (int i = 0; i < this.getRowNum(); ++i) {
            int tmp = this.getRow(i).getPhysicalNumberOfCells();
            if (tmp < max) continue;
            max = tmp;
        }
        return max;
    }

    private Row getRow(int rowIndex) {
        if (rowIndex < 0) {
            log.error("\u8bfb\u53d6Excel\u7684\u884c\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570");
            return null;
        }
        if (null == this.getSheet()) {
            return null;
        }
        Row row = this.getSheet().getRow(rowIndex);
        if (null == row) {
            if (rowIndex < this.getRowNum()) {
                return null;
            }
            log.info("\u8bfb\u53d6Excel\uff1a" + this.pathName + " \u7684\u8868-" + this.getSheet().getSheetName() + " \u7684\u7b2c" + rowIndex + "\u884c\u5931\u8d25");
            return null;
        }
        return row;
    }

    public void createBlankExcel2007(String pathName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        this.writeExcel2007(wb, pathName);
    }

    private String getStrFromCell(Cell cell) {
        String res = "";
        if (null == cell) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    res = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cell.getDateCellValue());
                    break;
                }
                BigDecimal value = new BigDecimal(cell.getNumericCellValue());
                String str = value.toString();
                if (str.contains(".0")) {
                    str = str.replace(".0", "");
                }
                res = str;
                break;
            }
            case 1: {
                res = cell.getStringCellValue();
                break;
            }
            case 4: {
                Boolean booleanValue = cell.getBooleanCellValue();
                res = booleanValue.toString();
                break;
            }
            case 3: {
                res = "";
                break;
            }
            case 2: {
                res = cell.getCellFormula();
                break;
            }
            case 5: {
                res = "";
                break;
            }
            default: {
                System.out.println("\u672a\u77e5\u7c7b\u578b");
            }
        }
        return res;
    }

    private Sheet getSheet() {
        return this.sheet;
    }

    private void setWb() {
        try {
            if (null == this.pathName) {
                return;
            }
            String exname = FileUtil.getExtensionName(this.pathName);
            if (exname.indexOf("xls") > -1 && exname.indexOf("xlsx") < 0) {
                this.wb = new HSSFWorkbook((InputStream)FileUtil.readToFileInputStream(this.pathName));
            } else if (exname.indexOf("xlsx") > -1) {
                this.wb = new XSSFWorkbook((InputStream)FileUtil.readToFileInputStream(this.pathName));
            } else {
                log.info("\u65e0\u6cd5\u8bfb\u53d6\uff0cExcel\u6587\u4ef6\u5f02\u5e38\uff1a" + this.pathName);
            }
        }
        catch (IOException | NullPointerException e) {
            log.error("\u8bfb\u53d6Excel\u6587\u4ef6\u51fa\u9519\uff1a" + this.pathName);
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void delBankRow() {
        for (int i = 0; i <= this.getRowNum(); ++i) {
            Row r;
            try {
                r = this.sheet.getRow(i);
            }
            catch (Exception e) {
                r = null;
                continue;
            }
            if (r == null && i == this.sheet.getLastRowNum()) {
                this.sheet.removeRow(r);
                continue;
            }
            if (r != null || i >= this.sheet.getLastRowNum()) continue;
            this.sheet.shiftRows(i + 1, this.sheet.getLastRowNum(), -1);
        }
    }
}

