/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import cn.baiweigang.qtaf.toolkit.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    private static LogUtil log = LogUtil.getLogger(FileUtil.class);
    private static List<String> filelist = new ArrayList<String>();

    public static FileInputStream readToFileInputStream(String pathName) {
        try {
            return new FileInputStream(pathName);
        }
        catch (FileNotFoundException e) {
            log.error("\u5b57\u8282\u6d41\u65b9\u5f0f\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + pathName);
            log.error(e.getMessage());
            return null;
        }
    }

    public static InputStreamReader readToInputStreamReader(String patnName, String enCoding) {
        try {
            return new InputStreamReader((InputStream)FileUtil.readToFileInputStream(patnName), enCoding);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + patnName);
            log.error(e.getMessage());
            return null;
        }
    }

    public static BufferedReader readToBufferedReader(String pathName, String enCoding) {
        try {
            return new BufferedReader(FileUtil.readToInputStreamReader(pathName, enCoding));
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + pathName);
            log.error(e.getMessage());
            return null;
        }
    }

    public static String readToString(String pathName, String enCoding) {
        BufferedReader buff = FileUtil.readToBufferedReader(pathName, enCoding);
        String line = "";
        StringBuilder str = new StringBuilder();
        try {
            while ((line = buff.readLine()) != null) {
                str.append(line).append("\r\n");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            str.append("");
        }
        return String.valueOf(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStreamToString(InputStream input, String enCoding) {
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, enCoding));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return sb.toString();
    }

    public static List<String> readLineToList(String pathName, String enCoding) {
        BufferedReader br = null;
        String line = "";
        ArrayList<String> lines = new ArrayList<String>();
        br = FileUtil.readToBufferedReader(pathName, enCoding);
        if (null == br) {
            return null;
        }
        try {
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());
            }
            br.close();
        }
        catch (Exception e) {
            log.error("\u6309\u884c\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + pathName);
            log.error(e.getMessage());
        }
        return lines;
    }

    public static FileOutputStream getFileOutStream(String pathName) {
        try {
            FileUtil.createFile(pathName);
            return new FileOutputStream(pathName);
        }
        catch (FileNotFoundException e) {
            log.error("\u521b\u5efa\u8f93\u51fa\u5230\u6587\u4ef6\u5931\u8d25\uff1a" + pathName);
            log.error(e.getMessage());
            return null;
        }
    }

    public static boolean writeByteArray(byte[] byteStream, String pathName) {
        boolean flag = false;
        try {
            FileOutputStream outStream = FileUtil.getFileOutStream(pathName);
            outStream.write(byteStream);
            outStream.flush();
            outStream.close();
            flag = true;
        }
        catch (IOException e) {
            log.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25" + pathName);
            log.error(e.getMessage());
            flag = false;
        }
        return flag;
    }

    public static boolean writeStream(InputStream inStream, String pathName) {
        try {
            byte[] temp = new byte[inStream.available()];
            inStream.read(temp);
            return FileUtil.writeByteArray(temp, pathName);
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6587\u4ef6\u5931\u8d251" + pathName);
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeString(String str, String pathName, String enCoding) {
        byte[] b;
        try {
            b = str.getBytes(enCoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u5b57\u7b26\u4e32\u6309\u7f16\u7801 " + enCoding + "\u8f6c\u6362\u5b57\u8282\u9519\u8bef");
            log.error(e.getMessage());
            return false;
        }
        return FileUtil.writeByteArray(b, pathName);
    }

    public static boolean writeString(List<String> strList, String pathName, String enCoding) {
        if (null == strList) {
            log.error("\u5f85\u5199\u5165\u6587\u4ef6" + pathName + "\u7684\u5b57\u7b26\u5217\u8868\u4e3anull");
            return false;
        }
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            tmp.append(strList.get(i) + "\r\n");
        }
        return FileUtil.writeString(tmp.toString(), pathName, enCoding);
    }

    public static boolean delFile(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        log.error("\u6587\u4ef6\uff1a" + file + " \u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4e0d\u662f\u6587\u4ef6\u7c7b\u578b");
        return false;
    }

    public static boolean delFile(String pathName) {
        File path = new File(pathName);
        return FileUtil.delFile(path);
    }

    public static boolean delAllFile(String folderPath) {
        File path = new File(folderPath);
        if (!path.exists()) {
            return false;
        }
        if (!path.isDirectory()) {
            return false;
        }
        String[] tempList = path.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.toString().endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                FileUtil.delFile(temp);
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + File.separator + tempList[i]);
            FileUtil.delFolder(path + File.separator + tempList[i]);
        }
        return true;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5939\uff1a" + folderPath + "\u51fa\u9519");
            log.error(e.getMessage());
        }
    }

    public static boolean createDictory(String folderPath) {
        if (null == folderPath) {
            return false;
        }
        File path = new File(folderPath);
        if (path.exists()) {
            return true;
        }
        if (new File(folderPath).mkdirs()) {
            return true;
        }
        if (!path.exists()) {
            log.error("\u521b\u5efa\u6587\u4ef6\u5939\uff1a" + folderPath + "\u5931\u8d25");
            return false;
        }
        return true;
    }

    public static boolean createFile(String pathName) {
        File pathNameFile = new File(pathName);
        if (!pathNameFile.exists()) {
            StringBuilder dictoryPath = new StringBuilder(pathName);
            dictoryPath.delete(FileUtil.getFileNameIndexFromPath(pathName), pathName.length());
            if (!FileUtil.createDictory(dictoryPath.toString())) {
                return false;
            }
            try {
                pathNameFile.createNewFile();
                return true;
            }
            catch (IOException e) {
                log.error("\u521b\u5efa\u6587\u4ef6\uff1a" + pathName + "\u5931\u8d25");
                log.error(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean isExist(String path) {
        return new File(path).exists();
    }

    public static String getExtensionName(String fileName) {
        int dot;
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1).toLowerCase();
        }
        return "";
    }

    public static List<String> getFilesFromFolder(String folderPath) {
        FileUtil myfile = new FileUtil();
        return myfile.getFilesOfFolder(folderPath);
    }

    public static String getParentPath(String absolutePath) {
        if (!FileUtil.isExist(absolutePath)) {
            log.info("\u6587\u4ef6\u4e0d\u5b58\u5728:" + absolutePath);
            return null;
        }
        File file = new File(absolutePath);
        return file.getParent();
    }

    public static String getFileName(String absolutePath) {
        if (!FileUtil.isExist(absolutePath)) {
            log.info("\u6587\u4ef6\u4e0d\u5b58\u5728:" + absolutePath);
            return null;
        }
        File file = new File(absolutePath);
        return file.getName();
    }

    public static List<String> getFilesFromFolder(String folderPath, String extensionName) {
        List<String> files = FileUtil.getFilesFromFolder(folderPath);
        ArrayList<String> tmpList = new ArrayList<String>();
        if (null == files) {
            return tmpList;
        }
        if (null == extensionName || extensionName.length() < 1) {
            return tmpList;
        }
        for (String filename : files) {
            String exname = FileUtil.getExtensionName(filename);
            if (exname.indexOf(extensionName.toLowerCase()) <= -1) continue;
            tmpList.add(filename);
        }
        return tmpList;
    }

    public static void closeStreamIgnoreExpection(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean renameFile(String oldPathName, String newPathName) {
        if (StringUtil.IsNullOrEmpty(oldPathName) || StringUtil.IsNullOrEmpty(newPathName)) {
            return false;
        }
        if (oldPathName.equals(newPathName)) {
            return false;
        }
        File oldfile = new File(oldPathName);
        File newfile = new File(newPathName);
        if (newfile.exists()) {
            log.error(newPathName + "\u5df2\u7ecf\u5b58\u5728\uff01");
            return false;
        }
        oldfile.renameTo(newfile);
        return true;
    }

    public static boolean copyFile(String srcPathName, String distPathName) {
        if (StringUtil.IsNullOrEmpty(srcPathName) || StringUtil.IsNullOrEmpty(srcPathName)) {
            return false;
        }
        if (distPathName.equals(srcPathName)) {
            return false;
        }
        return FileUtil.writeStream(FileUtil.readToFileInputStream(srcPathName), distPathName);
    }

    public static boolean copyFolder(String srcFolderPath, String distFolderPath) {
        if (StringUtil.IsNullOrEmpty(srcFolderPath) || StringUtil.IsNullOrEmpty(distFolderPath)) {
            return false;
        }
        if (srcFolderPath.toLowerCase().equals(distFolderPath)) {
            return false;
        }
        FileUtil.createDictory(distFolderPath);
        File[] file = new File(srcFolderPath).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                String sourceFile = file[i].getAbsolutePath();
                String targetFile = new File(distFolderPath).getAbsolutePath() + "/" + file[i].getName();
                FileUtil.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = srcFolderPath + "/" + file[i].getName();
            String dir2 = distFolderPath + "/" + file[i].getName();
            FileUtil.copyFolder(dir1, dir2);
        }
        return true;
    }

    public static int getFileNameIndexFromPath(String filePathName) {
        if (filePathName.toLowerCase().lastIndexOf("/") > -1) {
            return filePathName.toLowerCase().lastIndexOf("/");
        }
        return filePathName.toLowerCase().lastIndexOf("\\");
    }

    private List<String> getFilesOfFolder(String folderPath) {
        File dir = new File(folderPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getFilesOfFolder(files[i].getAbsolutePath());
                continue;
            }
            filelist.add(files[i].getAbsolutePath());
        }
        return filelist;
    }
}

