/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class FreeMakerUtil {
    private static LogUtil log = LogUtil.getLogger(FreeMakerUtil.class);

    public boolean CreateJavaFile(String templateFilePath, Map<String, Object> data, String javaFilePath) {
        if (!FileUtil.isExist(templateFilePath)) {
            log.info("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + templateFilePath);
            return false;
        }
        if (null == data) {
            log.info("\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3anull");
            return false;
        }
        if (!FileUtil.createFile(javaFilePath)) {
            return false;
        }
        try {
            String tmpPath = FileUtil.getParentPath(templateFilePath);
            String tmpName = FileUtil.getFileName(templateFilePath);
            Configuration cfg = new Configuration();
            cfg.setDirectoryForTemplateLoading(new File(tmpPath));
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template template = cfg.getTemplate(tmpName);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFilePath), "UTF-8");
            template.process(data, (Writer)out);
            return true;
        }
        catch (TemplateException | IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }
}

