/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PropUtil {
    private static LogUtil log = LogUtil.getLogger(PropUtil.class);

    public static Properties getPropertyInfo(String fullFilePath) {
        Properties properties = new Properties();
        try {
            properties.load(FileUtil.readToFileInputStream(fullFilePath));
        }
        catch (IOException e) {
            properties = null;
            log.error(e.getMessage());
        }
        return properties;
    }

    public static String getValue(Properties properties, String propertiesName) {
        String value = properties.getProperty(propertiesName);
        if (value == null || "".equalsIgnoreCase(value)) {
            log.error("\u83b7\u53d6\u7684\u5c5e\u6027\u503c\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u7a7a\u4e32!");
        }
        return value;
    }

    public static String getValue(Properties properties, String propertiesName, String defaultValue) {
        String value = properties.getProperty(propertiesName);
        if (value == null || "".equalsIgnoreCase(value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> getValueList(Properties properties, String propertiesName) {
        String[] propertieValues;
        String values = PropUtil.getValue(properties, propertiesName);
        ArrayList<String> valuesList = new ArrayList<String>(values.length());
        for (String value : propertieValues = values.split(",")) {
            if (value.trim().equalsIgnoreCase("")) continue;
            valuesList.add(value.trim());
        }
        if (valuesList.isEmpty()) {
            log.error("\u83b7\u53d6\u7684\u5c5e\u6027\u5217\u8868\u6240\u6709\u7684\u5c5e\u6027\u90fd\u4e3a\u7a7a\u4e32!");
        }
        return valuesList;
    }

    public static Map<String, String> getAllInfoToMap(Properties properties) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                map.put(key, value);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return map;
    }
}

