/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class SftpExecUtil {
    private static Session session = null;
    private static Channel channel = null;
    private LogUtil log = LogUtil.getLogger(SftpExecUtil.class);
    public String SshHost = "";
    public String SshPort = "";
    public String SshUserName = "";
    public String SshPassword = "";

    private Session getSession() {
        if (null != session) {
            return session;
        }
        String ftpHost = this.SshHost;
        String port = this.SshPort;
        String ftpUserName = this.SshUserName;
        String ftpPassword = this.SshPassword;
        int ftpPort = 21;
        if (port != null && !port.equals("")) {
            ftpPort = Integer.valueOf(port);
        }
        JSch jsch = new JSch();
        try {
            session = jsch.getSession(ftpUserName, ftpHost, ftpPort);
            if (ftpPassword != null) {
                session.setPassword(ftpPassword);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.setTimeout(300000);
            session.connect();
            return session;
        }
        catch (JSchException e) {
            this.log.error("\u8fde\u63a5 " + ftpHost + ":" + ftpPort + "\u7684SFTP\u901a\u9053\u521b\u5efa\u5931\u8d25");
            this.log.error(e.getMessage());
            return null;
        }
    }

    private Channel getChannel() {
        if (null != channel) {
            this.closeChannelOnly();
        }
        session = this.getSession();
        try {
            channel = session.openChannel("exec");
            return channel;
        }
        catch (JSchException e) {
            this.log.error("\u8fde\u63a5 SFTP\u901a\u9053\u521b\u5efa\u5931\u8d25");
            this.log.error(e.getMessage());
            return null;
        }
    }

    public void closeChannelOnly() {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
    }

    public void closeChannel() {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    public String execStr(String command) {
        Channel channel = this.getChannel();
        String res = "";
        try {
            ((ChannelExec)channel).setCommand(command);
            InputStream in = channel.getInputStream();
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            channel.connect();
            res = FileUtil.readInputStreamToString(in, "UTF-8");
            in = null;
        }
        catch (IOException e) {
            this.log.error("\u547d\u4ee4\uff1a" + command + "\u6267\u884c\u5f02\u5e38");
            this.log.error(e.getMessage());
        }
        catch (JSchException e) {
            this.log.error("\u547d\u4ee4\uff1a" + command + "\u6267\u884c\u5f02\u5e38");
            this.log.error(e.getMessage());
        }
        return res;
    }
}

