/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.FileUtil;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.util.Properties;

public class SftpFileUtil {
    private static Session session = null;
    private static Channel channel = null;
    private LogUtil log = LogUtil.getLogger(SftpFileUtil.class);
    public String FTPHOST;
    public String PORT;
    public String FTPUSERNAME;
    public String FTPPASSWORD;

    private ChannelSftp getChannel() {
        if (null != channel) {
            this.closeChannelOnly();
        }
        try {
            channel = this.getSession().openChannel("sftp");
            channel.connect();
            return (ChannelSftp)channel;
        }
        catch (JSchException e) {
            this.log.error("\u8fde\u63a5SFTP\u901a\u9053\u521b\u5efa\u5931\u8d25");
            this.log.error(e.getMessage());
            return null;
        }
    }

    private Session getSession() {
        if (null != session) {
            return session;
        }
        int ftpPort = 21;
        if (this.PORT != null && !this.PORT.equals("")) {
            ftpPort = Integer.valueOf(this.PORT);
        }
        JSch jsch = new JSch();
        try {
            session = jsch.getSession(this.FTPUSERNAME, this.FTPHOST, ftpPort);
            if (this.FTPPASSWORD != null) {
                session.setPassword(this.FTPPASSWORD);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.setTimeout(300000);
            session.connect();
            return session;
        }
        catch (JSchException e) {
            this.log.error("\u8fde\u63a5 " + this.FTPHOST + ":" + ftpPort + "\u7684SFTP\u901a\u9053\u521b\u5efa\u5931\u8d25");
            this.log.error(e.getMessage());
            return null;
        }
    }

    public void closeChannelOnly() {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
    }

    public void closeChannel() {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delFile(String filepath) {
        boolean flag = false;
        ChannelSftp channel = this.getChannel();
        try {
            channel.rm(filepath);
            this.log.info("\u5220\u9664\u6587\u4ef6" + filepath + "\u6210\u529f");
            flag = true;
        }
        catch (SftpException e) {
            this.log.error("\u5220\u9664\u6587\u4ef6" + filepath + "\u5931\u8d25");
            this.log.error(e.getMessage());
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delDir(String directory) {
        boolean flag = false;
        ChannelSftp channel = this.getChannel();
        try {
            channel.rmdir(directory);
            this.log.info("\u5220\u9664\u76ee\u5f55\uff1a" + directory + "\u6210\u529f");
            flag = true;
        }
        catch (SftpException e) {
            this.log.error("\u5220\u9664\u76ee\u5f55\uff1a" + directory + "\u5931\u8d25");
            this.log.error(e.getMessage());
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String oldpath, String newpath) {
        boolean flag = false;
        ChannelSftp channel = this.getChannel();
        try {
            channel.rename(oldpath, newpath);
            this.log.info("\u91cd\u547d\u540d\u6587\u4ef6" + oldpath + "\u6210\u529f");
            this.log.info("\u66f4\u65b0\u540e\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + newpath);
            flag = true;
        }
        catch (SftpException e) {
            this.log.error("\u91cd\u547d\u540d\u6587\u4ef6" + oldpath + "\u5931\u8d25");
            this.log.error(e.getMessage());
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFile(String filepath, String savepath) {
        String strtmp = null;
        ChannelSftp channel = this.getChannel();
        try {
            InputStream input = channel.get(filepath);
            strtmp = FileUtil.readInputStreamToString(input, "UTF-8");
            if (null != savepath && savepath.length() > 0) {
                FileUtil.writeString(strtmp, savepath, "UTF-8");
            }
        }
        catch (SftpException e) {
            this.log.error("\u4ece\u6587\u4ef6" + filepath + "\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
            this.log.error(e.getMessage());
        }
        return strtmp;
    }

    public String getFile(String filepath) {
        return this.getFile(filepath, null);
    }
}

