/*
 * Decompiled with CFR 0.152.
 */
package cn.baiweigang.qtaf.toolkit.util;

import cn.baiweigang.qtaf.toolkit.util.CommUtils;
import cn.baiweigang.qtaf.toolkit.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class StringUtil {
    private static LogUtil log = LogUtil.getLogger(StringUtil.class);

    public static String filterSpecialChar(String str) {
        String regEx = "[`~!@#$%^&*()+-=|{}':;',//\\[//\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean IsNullOrEmpty(String str) {
        return null == str || str.length() < 1;
    }

    public static List<String> getListFromString(String s, String flag) {
        if (StringUtil.IsNullOrEmpty(s)) {
            return new ArrayList<String>();
        }
        if (StringUtil.IsNullOrEmpty(flag)) {
            return new ArrayList<String>();
        }
        String[] ns = s.split(flag);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ns.length; ++i) {
            list.add(ns[i]);
        }
        return list;
    }

    public static boolean check(String str, String sIllegal) {
        int len = sIllegal.length();
        if (null == str) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (str.indexOf(sIllegal.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static String htmlcodeToSpecialchars(String str) {
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&#039;", "'");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        return str;
    }

    public static byte[] hex2byte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static boolean isNumeric(String src) {
        Matcher m;
        Pattern numericPattern = Pattern.compile("^[0-9]+$");
        if (src == null || src.equals("")) {
            return false;
        }
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = numericPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static boolean isNumericAndCanNull(String src) {
        Matcher m;
        Pattern numericPattern = Pattern.compile("^[0-9]+$");
        if (src == null || src.equals("")) {
            return true;
        }
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = numericPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static String getStrFromJson(String jsonStr) {
        try {
            JSONObject tempJSON = JSONObject.fromObject((Object)jsonStr);
            return tempJSON.toString();
        }
        catch (Exception e) {
            return jsonStr;
        }
    }

    public static String getJsonStrFromMap(Map<String, String> map) {
        JSONObject oneResult = new JSONObject();
        try {
            oneResult = JSONObject.fromObject(map);
        }
        catch (JSONException e) {
            log.error("\u4ecemap\u8868\uff1a" + map.toString() + "\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32\u51fa\u9519");
            log.error(e.getMessage());
            return null;
        }
        return oneResult.toString();
    }

    public static String getValueFromMapByKey(Map<String, ?> map, String key) {
        try {
            return map.get(key).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Map<String, String> getMapFromMapByKeyList(Map<String, String> map, List<String> list) {
        TreeMap<String, String> mapTmp = new TreeMap<String, String>();
        if (null == list || list.size() < 1) {
            log.error("\u6307\u5b9a\u7684key\u5217\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return null;
        }
        for (int j = 0; j < list.size(); ++j) {
            String key = list.get(j);
            String value = StringUtil.getValueFromMapByKey(map, key);
            mapTmp.put(key, value);
        }
        return mapTmp;
    }

    public static List<String> getKeyListFromMap(Map<String, String> expMap) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (Map.Entry<String, String> entry : expMap.entrySet()) {
                list.add(entry.getKey().toString());
            }
        }
        catch (Exception e) {
            return null;
        }
        return list;
    }

    public static String getValueFromStr(String str, String start, String end) {
        try {
            return str.substring(str.indexOf(start), str.indexOf(end) + end.length());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String transForChinese(String value, String encoding) {
        if (value.matches("[0-9a-zA-Z.]*")) {
            return value;
        }
        return CommUtils.urlEncode(value, encoding);
    }

    public static Map<String, String> transForChinese(Map<String, String> map, String encoding) {
        Map<String, String> mapTmp = map;
        try {
            for (Map.Entry<String, String> entry : mapTmp.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                value = StringUtil.transForChinese(value, encoding);
                mapTmp.put(key, value);
            }
            return mapTmp;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362map\u8868\u4e2d\u7684\u4e2d\u6587\u5931\u8d25");
            log.error(e.getMessage());
            return map;
        }
    }

    public static Map<String, String> getMapFromString(String str) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            String[] res = str.split("&");
            for (int i = 0; i < res.length; ++i) {
                String[] tmp = res[i].split("=");
                String key = tmp[0];
                String value = tmp[1];
                map.put(key, value);
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\uff1a" + str + "\u65e0\u6cd5\u8f6c\u6362\u4e3amap\u8868");
            log.error(e.getMessage());
            map = null;
        }
        return map;
    }

    public static String getStrFromMap(Map<String, String> map) {
        String str = "";
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                str = str + key + "=" + value + "&";
            }
            str = str.substring(0, str.length() - 1);
        }
        catch (Exception e) {
            log.error("\u4ecemap\u4e2d\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u5931\u8d25");
            log.error(e.getMessage());
        }
        return str;
    }

    public static Map<String, String> cloneMap(Map<String, String> map) {
        TreeMap<String, String> clonemap = new TreeMap<String, String>();
        if (null == map) {
            return null;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            clonemap.put(key, value);
        }
        return clonemap;
    }

    public static String getXmlFromMap(Map<String, String> map) {
        String xmlbody = "";
        if (null == map || map.size() < 1) {
            return "";
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlbody = xmlbody + "<" + entry.getKey() + ">" + entry.getValue() + "</" + entry.getKey() + ">";
        }
        return xmlbody;
    }

    public static String getXmlFromMap(Map<String, String> map, String encoding) {
        String xmlbody = "";
        if (null == map || map.size() < 1) {
            return "";
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!value.matches("[0-9a-zA-Z.]*")) {
                value = CommUtils.urlEncode(value, encoding);
            }
            xmlbody = xmlbody + "<" + key + ">" + value + "</" + key + ">";
        }
        return xmlbody;
    }

    public static String changeCharset(String str, String newCharset) {
        if (!StringUtil.IsNullOrEmpty(str)) {
            byte[] bs = str.getBytes();
            try {
                return new String(bs, newCharset);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static String changeCharset(String str, String oldCharset, String newCharset) {
        if (!StringUtil.IsNullOrEmpty(str)) {
            try {
                byte[] bs = str.getBytes(oldCharset);
                return new String(bs, newCharset);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!StringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }
}

