/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhipu.oapi.core.ConfigV4;
import com.zhipu.oapi.core.cache.ICache;
import com.zhipu.oapi.core.cache.LocalCache;
import com.zhipu.oapi.core.response.HttpxBinaryResponseContent;
import com.zhipu.oapi.core.response.RawResponse;
import com.zhipu.oapi.core.token.GlobalTokenManager;
import com.zhipu.oapi.core.token.TokenManagerV4;
import com.zhipu.oapi.service.v4.api.ChatApiService;
import com.zhipu.oapi.service.v4.batchs.Batch;
import com.zhipu.oapi.service.v4.batchs.BatchCreateParams;
import com.zhipu.oapi.service.v4.batchs.BatchPage;
import com.zhipu.oapi.service.v4.batchs.BatchResponse;
import com.zhipu.oapi.service.v4.batchs.QueryBatchResponse;
import com.zhipu.oapi.service.v4.embedding.EmbeddingApiResponse;
import com.zhipu.oapi.service.v4.embedding.EmbeddingRequest;
import com.zhipu.oapi.service.v4.embedding.EmbeddingResult;
import com.zhipu.oapi.service.v4.file.File;
import com.zhipu.oapi.service.v4.file.FileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryBatchRequest;
import com.zhipu.oapi.service.v4.file.QueryFileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryFileResult;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.file.UploadFileRequest;
import com.zhipu.oapi.service.v4.fine_turning.CreateFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatus;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatusResponse;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningEvent;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobIdRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobModelRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.PersonalFineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningEventApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobRequest;
import com.zhipu.oapi.service.v4.image.CreateImageRequest;
import com.zhipu.oapi.service.v4.image.ImageApiResponse;
import com.zhipu.oapi.service.v4.image.ImageResult;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequest;
import com.zhipu.oapi.service.v4.model.ChatError;
import com.zhipu.oapi.service.v4.model.ModelApiResponse;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.model.QueryModelResultRequest;
import com.zhipu.oapi.service.v4.model.QueryModelResultResponse;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import com.zhipu.oapi.utils.OkHttps;
import com.zhipu.oapi.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientV4 {
    private static final Logger logger = LoggerFactory.getLogger(ClientV4.class);
    private static final ObjectMapper mapper = ChatApiService.defaultObjectMapper();
    private ConfigV4 config;
    private ChatApiService chatApiService;

    public ModelApiResponse invokeModelApi(ChatCompletionRequest request) {
        String paramMsg = this.validateParams(request);
        if (StringUtils.isNotEmpty(paramMsg)) {
            return new ModelApiResponse(-100, String.format("invalid param: %s", paramMsg));
        }
        if (request.getStream().booleanValue()) {
            return this.sseInvoke(request);
        }
        if ("invoke".equals(request.getInvokeMethod())) {
            return this.invoke(request);
        }
        if ("async-invoke".equals(request.getInvokeMethod())) {
            return this.asyncInvoke(request);
        }
        return null;
    }

    private ModelApiResponse sseInvoke(ChatCompletionRequest request) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("request_id", request.getRequestId());
        paramsMap.put("user_id", request.getUserId());
        paramsMap.put("messages", request.getMessages());
        paramsMap.put("model", request.getModel());
        paramsMap.put("stream", true);
        paramsMap.put("tools", request.getTools());
        paramsMap.put("tool_choice", request.getToolChoice());
        paramsMap.put("temperature", request.getTemperature());
        paramsMap.put("top_p", request.getTopP());
        paramsMap.put("sensitive_word_check", request.getSensitiveWordCheck());
        paramsMap.put("do_sample", request.getDoSample());
        paramsMap.put("max_tokens", request.getMaxTokens());
        paramsMap.put("stop", request.getStop());
        paramsMap.put("meta", request.getMeta());
        if (request.getExtraJson() != null) {
            paramsMap.putAll(request.getExtraJson());
        }
        ModelApiResponse resp = new ModelApiResponse();
        try {
            RawResponse rawResp = this.chatApiService.sseExecute(paramsMap);
            resp.setCode(rawResp.getStatusCode());
            resp.setMsg(rawResp.getMsg());
            resp.setSuccess(rawResp.isSuccess());
            if (resp.isSuccess()) {
                resp.setFlowable(rawResp.getFlowable());
            }
            return resp;
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            resp.setCode(e.statusCode);
            resp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            resp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            ModelData modelData = new ModelData();
            modelData.setError(chatError);
            resp.setData(modelData);
            return resp;
        }
    }

    private ModelApiResponse invoke(ChatCompletionRequest request) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("request_id", request.getRequestId());
        paramsMap.put("user_id", request.getUserId());
        paramsMap.put("messages", request.getMessages());
        paramsMap.put("model", request.getModel());
        paramsMap.put("stream", false);
        paramsMap.put("tools", request.getTools());
        paramsMap.put("tool_choice", request.getToolChoice());
        paramsMap.put("temperature", request.getTemperature());
        paramsMap.put("top_p", request.getTopP());
        paramsMap.put("sensitive_word_check", request.getSensitiveWordCheck());
        paramsMap.put("do_sample", request.getDoSample());
        paramsMap.put("max_tokens", request.getMaxTokens());
        paramsMap.put("stop", request.getStop());
        paramsMap.put("meta", request.getMeta());
        if (request.getExtraJson() != null) {
            paramsMap.putAll(request.getExtraJson());
        }
        ModelApiResponse resp = new ModelApiResponse();
        try {
            ModelData modelData = this.chatApiService.createChatCompletion(paramsMap);
            if (modelData != null) {
                resp.setCode(200);
                resp.setMsg("\u8c03\u7528\u6210\u529f");
                resp.setData(modelData);
            }
            return resp;
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            resp.setCode(e.statusCode);
            resp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            resp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            ModelData modelData = new ModelData();
            modelData.setError(chatError);
            resp.setData(modelData);
            return resp;
        }
    }

    private ModelApiResponse asyncInvoke(ChatCompletionRequest request) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("request_id", request.getRequestId());
        paramsMap.put("user_id", request.getUserId());
        paramsMap.put("messages", request.getMessages());
        paramsMap.put("model", request.getModel());
        paramsMap.put("stream", false);
        paramsMap.put("tools", request.getTools());
        paramsMap.put("tool_choice", request.getToolChoice());
        paramsMap.put("temperature", request.getTemperature());
        paramsMap.put("top_p", request.getTopP());
        paramsMap.put("sensitive_word_check", request.getSensitiveWordCheck());
        paramsMap.put("do_sample", request.getDoSample());
        paramsMap.put("max_tokens", request.getMaxTokens());
        paramsMap.put("stop", request.getStop());
        if (request.getExtraJson() != null) {
            paramsMap.putAll(request.getExtraJson());
        }
        ModelApiResponse resp = new ModelApiResponse();
        try {
            ModelData modelData = this.chatApiService.createChatCompletionAsync(paramsMap);
            if (modelData != null) {
                resp.setCode(200);
                resp.setMsg("\u8c03\u7528\u6210\u529f");
                resp.setData(modelData);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            resp.setCode(e.statusCode);
            resp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            resp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            ModelData modelData = new ModelData();
            modelData.setError(chatError);
            resp.setData(modelData);
        }
        return resp;
    }

    public QueryModelResultResponse queryModelResult(QueryModelResultRequest request) {
        QueryModelResultResponse resp = new QueryModelResultResponse();
        try {
            ModelData modelData = this.chatApiService.queryAsyncResult(request.getTaskId());
            if (modelData != null) {
                resp.setCode(200);
                resp.setMsg("\u8c03\u7528\u6210\u529f");
                resp.setSuccess(true);
                modelData.setCreated(null);
                modelData.setModel(modelData.getModel());
                modelData.setRequestId(modelData.getRequestId());
                modelData.setTaskStatus(modelData.getTaskStatus());
                resp.setData(modelData);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            resp.setCode(e.statusCode);
            resp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            resp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            ModelData modelData = new ModelData();
            modelData.setError(chatError);
            resp.setData(modelData);
        }
        return resp;
    }

    public ImageApiResponse createImage(CreateImageRequest createImageRequest) {
        ImageApiResponse imageApiResponse = new ImageApiResponse();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("request_id", createImageRequest.getRequestId());
        request.put("user_id", createImageRequest.getUserId());
        request.put("prompt", createImageRequest.getPrompt());
        request.put("model", createImageRequest.getModel());
        try {
            ImageResult image;
            if (createImageRequest.getExtraJson() != null) {
                request.replaceAll((s, v) -> createImageRequest.getExtraJson().get(s));
            }
            if ((image = this.chatApiService.createImage(request)) != null) {
                imageApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                imageApiResponse.setCode(200);
                imageApiResponse.setSuccess(true);
                imageApiResponse.setData(image);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            imageApiResponse.setCode(e.statusCode);
            imageApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            imageApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            ImageResult imageResult = new ImageResult();
            imageResult.setError(chatError);
            imageApiResponse.setData(imageResult);
        }
        return imageApiResponse;
    }

    private String validateParams(ChatCompletionRequest request) {
        if (request == null) {
            return "request can not be null";
        }
        if (StringUtils.isEmpty(this.config.getApiKey())) {
            return "apikey can not be empty";
        }
        if (StringUtils.isEmpty(this.config.getApiSecret())) {
            return "apiSecret can not be empty";
        }
        if (!request.getStream().booleanValue() && StringUtils.isEmpty(request.getInvokeMethod())) {
            return "invoke method can not be empty";
        }
        if (request.getMessages() == null || request.getMessages().isEmpty()) {
            return "message can not be empty";
        }
        if (request.getModel() == null) {
            return "model can not be empty";
        }
        return null;
    }

    public EmbeddingApiResponse invokeEmbeddingsApi(EmbeddingRequest request) {
        EmbeddingApiResponse embeddingApiResponse = new EmbeddingApiResponse();
        try {
            EmbeddingResult embeddingResult;
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("request_id", request.getRequestId());
            paramsMap.put("user_id", request.getUserId());
            paramsMap.put("input", request.getInput());
            paramsMap.put("model", request.getModel());
            if (request.getExtraJson() != null) {
                paramsMap.putAll(request.getExtraJson());
            }
            if ((embeddingResult = this.chatApiService.createEmbeddings(paramsMap)) != null) {
                embeddingApiResponse.setCode(200);
                embeddingApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                embeddingApiResponse.setSuccess(true);
                embeddingApiResponse.setData(embeddingResult);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            embeddingApiResponse.setCode(e.statusCode);
            embeddingApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            embeddingApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            EmbeddingResult embeddingResult = new EmbeddingResult();
            embeddingResult.setError(chatError);
            embeddingApiResponse.setData(embeddingResult);
        }
        return embeddingApiResponse;
    }

    public FileApiResponse invokeUploadFileApi(UploadFileRequest request) {
        FileApiResponse fileApiResponse = new FileApiResponse();
        try {
            File file = this.chatApiService.uploadFile(request);
            if (file != null) {
                fileApiResponse.setCode(200);
                fileApiResponse.setSuccess(true);
                fileApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                fileApiResponse.setData(file);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            fileApiResponse.setCode(e.statusCode);
            fileApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            fileApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            File file = new File();
            file.setError(chatError);
            fileApiResponse.setData(file);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return fileApiResponse;
    }

    public QueryFileApiResponse queryFilesApi(QueryFilesRequest queryFilesRequest) {
        QueryFileApiResponse queryFileApiResponse = new QueryFileApiResponse();
        try {
            QueryFileResult queryFileResult = this.chatApiService.queryFileList(queryFilesRequest);
            if (queryFileResult != null) {
                queryFileApiResponse.setCode(200);
                queryFileApiResponse.setSuccess(true);
                queryFileApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                queryFileApiResponse.setData(queryFileResult);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryFileApiResponse.setCode(e.statusCode);
            queryFileApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryFileApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            QueryFileResult queryFileResult = new QueryFileResult();
            queryFileResult.setError(chatError);
            queryFileApiResponse.setData(queryFileResult);
        }
        return queryFileApiResponse;
    }

    public HttpxBinaryResponseContent fileContent(String fileId) throws IOException {
        return this.chatApiService.fileContent(fileId);
    }

    public CreateFineTuningJobApiResponse createFineTuningJob(FineTuningJobRequest request) {
        CreateFineTuningJobApiResponse createFineTuningJobApiResponse = new CreateFineTuningJobApiResponse();
        FineTuningJob fineTuningJob = null;
        try {
            fineTuningJob = this.chatApiService.createFineTuningJob(request);
            if (fineTuningJob != null) {
                createFineTuningJobApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                createFineTuningJobApiResponse.setData(fineTuningJob);
                createFineTuningJobApiResponse.setSuccess(true);
                createFineTuningJobApiResponse.setCode(200);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            createFineTuningJobApiResponse.setCode(e.statusCode);
            createFineTuningJobApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            createFineTuningJobApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            fineTuningJob = new FineTuningJob();
            fineTuningJob.setError(chatError);
            createFineTuningJobApiResponse.setData(fineTuningJob);
        }
        return createFineTuningJobApiResponse;
    }

    public QueryFineTuningEventApiResponse queryFineTuningJobsEvents(QueryFineTuningJobRequest queryFineTuningJobRequest) {
        QueryFineTuningEventApiResponse queryFineTuningEventApiResponse = new QueryFineTuningEventApiResponse();
        try {
            FineTuningEvent fineTuningEvent = this.chatApiService.listFineTuningJobEvents(queryFineTuningJobRequest.getJobId(), queryFineTuningJobRequest.getLimit(), queryFineTuningJobRequest.getAfter());
            if (fineTuningEvent != null) {
                queryFineTuningEventApiResponse.setSuccess(true);
                queryFineTuningEventApiResponse.setData(fineTuningEvent);
                queryFineTuningEventApiResponse.setCode(200);
                queryFineTuningEventApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryFineTuningEventApiResponse.setCode(e.statusCode);
            queryFineTuningEventApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryFineTuningEventApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            FineTuningEvent fineTuningEvent = new FineTuningEvent();
            fineTuningEvent.setError(chatError);
            queryFineTuningEventApiResponse.setData(fineTuningEvent);
        }
        return queryFineTuningEventApiResponse;
    }

    public QueryFineTuningJobApiResponse retrieveFineTuningJobs(QueryFineTuningJobRequest queryFineTuningJobRequest) {
        QueryFineTuningJobApiResponse queryFineTuningJobApiResponse = new QueryFineTuningJobApiResponse();
        try {
            FineTuningJob fineTuningJob = this.chatApiService.retrieveFineTuningJob(queryFineTuningJobRequest.getJobId(), queryFineTuningJobRequest.getLimit(), queryFineTuningJobRequest.getAfter());
            if (fineTuningJob != null) {
                queryFineTuningJobApiResponse.setSuccess(true);
                queryFineTuningJobApiResponse.setData(fineTuningJob);
                queryFineTuningJobApiResponse.setCode(200);
                queryFineTuningJobApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryFineTuningJobApiResponse.setCode(e.statusCode);
            queryFineTuningJobApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryFineTuningJobApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            FineTuningJob fineTuningJob = new FineTuningJob();
            fineTuningJob.setError(chatError);
            queryFineTuningJobApiResponse.setData(fineTuningJob);
        }
        return queryFineTuningJobApiResponse;
    }

    public QueryPersonalFineTuningJobApiResponse queryPersonalFineTuningJobs(QueryPersonalFineTuningJobRequest queryPersonalFineTuningJobRequest) {
        QueryPersonalFineTuningJobApiResponse queryPersonalFineTuningJobApiResponse = new QueryPersonalFineTuningJobApiResponse();
        try {
            PersonalFineTuningJob personalFineTuningJob = this.chatApiService.queryPersonalFineTuningJobs(queryPersonalFineTuningJobRequest.getLimit(), queryPersonalFineTuningJobRequest.getAfter());
            if (personalFineTuningJob != null) {
                queryPersonalFineTuningJobApiResponse.setSuccess(true);
                queryPersonalFineTuningJobApiResponse.setData(personalFineTuningJob);
                queryPersonalFineTuningJobApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
                queryPersonalFineTuningJobApiResponse.setCode(200);
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryPersonalFineTuningJobApiResponse.setCode(e.statusCode);
            queryPersonalFineTuningJobApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryPersonalFineTuningJobApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            PersonalFineTuningJob personalFineTuningJob = new PersonalFineTuningJob();
            personalFineTuningJob.setError(chatError);
            queryPersonalFineTuningJobApiResponse.setData(personalFineTuningJob);
        }
        return queryPersonalFineTuningJobApiResponse;
    }

    public QueryFineTuningJobApiResponse cancelFineTuningJob(FineTuningJobIdRequest fineTuningJobIdRequest) {
        QueryFineTuningJobApiResponse queryFineTuningJobApiResponse = new QueryFineTuningJobApiResponse();
        try {
            FineTuningJob fineTuningJob = this.chatApiService.cancelFineTuningJob(fineTuningJobIdRequest.getJobId());
            if (fineTuningJob != null) {
                queryFineTuningJobApiResponse.setSuccess(true);
                queryFineTuningJobApiResponse.setData(fineTuningJob);
                queryFineTuningJobApiResponse.setCode(200);
                queryFineTuningJobApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryFineTuningJobApiResponse.setCode(e.statusCode);
            queryFineTuningJobApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryFineTuningJobApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            FineTuningJob fineTuningJob = new FineTuningJob();
            fineTuningJob.setError(chatError);
            queryFineTuningJobApiResponse.setData(fineTuningJob);
        }
        return queryFineTuningJobApiResponse;
    }

    public QueryFineTuningJobApiResponse deleteFineTuningJob(FineTuningJobIdRequest fineTuningJobIdRequest) {
        QueryFineTuningJobApiResponse queryFineTuningJobApiResponse = new QueryFineTuningJobApiResponse();
        try {
            FineTuningJob fineTuningJob = this.chatApiService.deleteFineTuningJob(fineTuningJobIdRequest.getJobId());
            if (fineTuningJob != null) {
                queryFineTuningJobApiResponse.setSuccess(true);
                queryFineTuningJobApiResponse.setData(fineTuningJob);
                queryFineTuningJobApiResponse.setCode(200);
                queryFineTuningJobApiResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            queryFineTuningJobApiResponse.setCode(e.statusCode);
            queryFineTuningJobApiResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            queryFineTuningJobApiResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            FineTuningJob fineTuningJob = new FineTuningJob();
            fineTuningJob.setError(chatError);
            queryFineTuningJobApiResponse.setData(fineTuningJob);
        }
        return queryFineTuningJobApiResponse;
    }

    public FineTunedModelsStatusResponse deleteFineTuningModel(FineTuningJobModelRequest fineTuningJobModelRequest) {
        FineTunedModelsStatusResponse fineTunedModelsStatusResponse = new FineTunedModelsStatusResponse();
        try {
            FineTunedModelsStatus fineTunedModelsStatus = this.chatApiService.deleteFineTuningModel(fineTuningJobModelRequest.getFineTunedModel());
            if (fineTunedModelsStatus != null) {
                fineTunedModelsStatusResponse.setSuccess(true);
                fineTunedModelsStatusResponse.setData(fineTunedModelsStatus);
                fineTunedModelsStatusResponse.setCode(200);
                fineTunedModelsStatusResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            fineTunedModelsStatusResponse.setCode(e.statusCode);
            fineTunedModelsStatusResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            fineTunedModelsStatusResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
        }
        return fineTunedModelsStatusResponse;
    }

    public BatchResponse batchesCreate(BatchCreateParams batchCreateParams) {
        BatchResponse batchResponse = new BatchResponse();
        try {
            Batch batch = this.chatApiService.batchesCreate(batchCreateParams);
            if (batch != null) {
                batchResponse.setSuccess(true);
                batchResponse.setData(batch);
                batchResponse.setCode(200);
                batchResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            batchResponse.setCode(e.statusCode);
            batchResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            batchResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            Batch batch = new Batch();
            batch.setError(chatError);
            batchResponse.setData(batch);
        }
        return batchResponse;
    }

    public BatchResponse batchesRetrieve(String batchId) {
        BatchResponse batchResponse = new BatchResponse();
        try {
            Batch batch = this.chatApiService.batchesRetrieve(batchId);
            if (batch != null) {
                batchResponse.setSuccess(true);
                batchResponse.setData(batch);
                batchResponse.setCode(200);
                batchResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            batchResponse.setCode(e.statusCode);
            batchResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            batchResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            Batch batch = new Batch();
            batch.setError(chatError);
            batchResponse.setData(batch);
        }
        return batchResponse;
    }

    public QueryBatchResponse batchesList(QueryBatchRequest queryBatchRequest) {
        QueryBatchResponse batchResponse = new QueryBatchResponse();
        try {
            BatchPage batchPage = this.chatApiService.batchesList(queryBatchRequest.getLimit(), queryBatchRequest.getAfter());
            if (batchPage != null) {
                batchResponse.setSuccess(true);
                batchResponse.setData(batchPage);
                batchResponse.setCode(200);
                batchResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            batchResponse.setCode(e.statusCode);
            batchResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            batchResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            BatchPage batch = new BatchPage();
            batch.setError(chatError);
            batchResponse.setData(batch);
        }
        return batchResponse;
    }

    public BatchResponse batchesCancel(String batchId) {
        BatchResponse batchResponse = new BatchResponse();
        try {
            Batch batch = this.chatApiService.batchesCancel(batchId);
            if (batch != null) {
                batchResponse.setSuccess(true);
                batchResponse.setData(batch);
                batchResponse.setCode(200);
                batchResponse.setMsg("\u8c03\u7528\u6210\u529f");
            }
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            batchResponse.setCode(e.statusCode);
            batchResponse.setMsg("\u4e1a\u52a1\u51fa\u9519");
            batchResponse.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            Batch batch = new Batch();
            batch.setError(chatError);
            batchResponse.setData(batch);
        }
        return batchResponse;
    }

    public void setConfig(ConfigV4 config) {
        this.config = config;
    }

    public ConfigV4 getConfig() {
        return this.config;
    }

    public void setChatApiService(ChatApiService chatApiService) {
        this.chatApiService = chatApiService;
    }

    public ChatApiService getChatApiService() {
        return this.chatApiService;
    }

    public static final class Builder {
        private final ConfigV4 config = new ConfigV4();

        public Builder(String apiSecretKey) {
            this.config.setApiSecretKey(apiSecretKey);
        }

        public Builder(String baseUrl, String apiSecretKey) {
            this.config.setBaseUrl(baseUrl);
            this.config.setApiSecretKey(apiSecretKey);
        }

        public Builder setTokenKey(String apiKey, String apiSecret) {
            this.config.setApiKey(apiKey);
            this.config.setApiSecret(apiSecret);
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder enableTokenCache() {
            this.config.setDisableTokenCache(false);
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder tokenExpire(int expireMillis) {
            this.config.setExpireMillis(expireMillis);
            return this;
        }

        public Builder networkConfig(int requestTimeOut, int connectTimeout, int readTimeout, int writeTimeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(requestTimeOut);
            this.config.setConnectTimeout(connectTimeout);
            this.config.setReadTimeout(readTimeout);
            this.config.setWriteTimeout(writeTimeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            this.config.setConnectionPool(connectionPool);
            return this;
        }

        public Builder devMode(boolean devMode) {
            this.config.setDevMode(devMode);
            return this;
        }

        private void initCache(ConfigV4 config) {
            if (config.getCache() != null) {
                GlobalTokenManager.setTokenManager(new TokenManagerV4(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalTokenManager.setTokenManager(new TokenManagerV4(cache));
            }
        }

        private void initHttpTransport(ConfigV4 config) {
            if (config.getHttpClient() == null) {
                if (StringUtils.isEmpty(config.getApiSecretKey())) {
                    throw new RuntimeException("apiSecretKey can not be empty");
                }
                OkHttpClient okHttpClient = OkHttps.create(config);
                config.setHttpClient(okHttpClient);
            }
        }

        public ClientV4 build() {
            ClientV4 client = new ClientV4();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            String baseUrl = null;
            baseUrl = StringUtils.isEmpty(this.config.getBaseUrl()) ? (this.config.isDevMode() ? "https://test.bigmodel.cn/stage-api/paas/v4/" : "https://open.bigmodel.cn/api/paas/v4/") : this.config.getBaseUrl();
            client.setChatApiService(new ChatApiService(this.config.getHttpClient(), baseUrl));
            return client;
        }
    }
}

