/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.core;

import com.zhipu.oapi.core.cache.ICache;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;

public class ConfigV4 {
    private String baseUrl;
    private String apiSecretKey = "";
    private String apiKey = "";
    private String apiSecret = "";
    private int expireMillis = 1800000;
    private String alg = "HS256";
    private boolean disableTokenCache;
    private ICache cache;
    private OkHttpClient httpClient;
    private ConnectionPool connectionPool;
    private int requestTimeOut;
    private int connectTimeout;
    private int readTimeout;
    private int writeTimeout;
    private TimeUnit timeOutTimeUnit;
    private boolean devMode;

    public ConfigV4() {
    }

    public ConfigV4(String apiSecretKey) {
        this.apiSecretKey = apiSecretKey;
        String[] arrStr = apiSecretKey.split("\\.");
        if (arrStr.length != 2) {
            throw new RuntimeException("invalid apiSecretKey");
        }
        this.apiKey = arrStr[0];
        this.apiSecret = arrStr[1];
    }

    public ConfigV4(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.apiSecretKey = String.format("%s.%s", apiKey, apiSecret);
    }

    public void setApiSecretKey(String apiSecretKey) {
        this.apiSecretKey = apiSecretKey;
        String[] arrStr = apiSecretKey.split("\\.");
        if (arrStr.length != 2) {
            throw new RuntimeException("invalid apiSecretKey");
        }
        this.apiKey = arrStr[0];
        this.apiSecret = arrStr[1];
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiSecretKey() {
        return this.apiSecretKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setExpireMillis(int expireMillis) {
        this.expireMillis = expireMillis;
    }

    public int getExpireMillis() {
        return this.expireMillis;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public String getAlg() {
        return this.alg;
    }

    public void setDisableTokenCache(boolean disableTokenCache) {
        this.disableTokenCache = disableTokenCache;
    }

    public boolean isDisableTokenCache() {
        return this.disableTokenCache;
    }

    public void setCache(ICache cache) {
        this.cache = cache;
    }

    public ICache getCache() {
        return this.cache;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setRequestTimeOut(int requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public int getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setTimeOutTimeUnit(TimeUnit timeOutTimeUnit) {
        this.timeOutTimeUnit = timeOutTimeUnit;
    }

    public TimeUnit getTimeOutTimeUnit() {
        return this.timeOutTimeUnit;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public boolean isDevMode() {
        return this.devMode;
    }
}

