/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.zhipu.oapi.service.v4.batchs.Batch;
import com.zhipu.oapi.service.v4.batchs.BatchCreateParams;
import com.zhipu.oapi.service.v4.batchs.BatchPage;
import com.zhipu.oapi.service.v4.embedding.EmbeddingResult;
import com.zhipu.oapi.service.v4.file.File;
import com.zhipu.oapi.service.v4.file.FileDeleted;
import com.zhipu.oapi.service.v4.file.QueryFileResult;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatus;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningEvent;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.PersonalFineTuningJob;
import com.zhipu.oapi.service.v4.image.ImageResult;
import com.zhipu.oapi.service.v4.model.ModelData;
import io.reactivex.Single;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;

public interface ChatApi {
    @Streaming
    @POST(value="chat/completions")
    public Call<ResponseBody> createChatCompletionStream(@Body Map<String, Object> var1);

    @POST(value="async/chat/completions")
    public Single<ModelData> createChatCompletionAsync(@Body Map<String, Object> var1);

    @POST(value="chat/completions")
    public Single<ModelData> createChatCompletion(@Body Map<String, Object> var1);

    @GET(value="async-result/{id}")
    public Single<ModelData> queryAsyncResult(@Path(value="id") String var1);

    @POST(value="images/generations")
    public Single<ImageResult> createImage(@Body Map<String, Object> var1);

    @POST(value="embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body Map<String, Object> var1);

    @POST(value="files")
    public Single<File> uploadFile(@Body MultipartBody var1);

    @GET(value="files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @DELETE(value="files/{file_id}")
    public Single<FileDeleted> deletedFile(@Path(value="file_id") String var1);

    @GET(value="files")
    public Single<QueryFileResult> queryFileList(@Query(value="after") String var1, @Query(value="purpose") String var2, @Query(value="order") String var3, @Query(value="limit") Integer var4);

    @Streaming
    @GET(value="files/{file_id}/content")
    public Call<ResponseBody> fileContent(@Path(value="file_id") String var1);

    @POST(value="fine_tuning/jobs")
    public Single<FineTuningJob> createFineTuningJob(@Body FineTuningJobRequest var1);

    @GET(value="fine_tuning/jobs/{fine_tuning_job_id}/events")
    public Single<FineTuningEvent> listFineTuningJobEvents(@Path(value="fine_tuning_job_id") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

    @GET(value="fine_tuning/jobs/{fine_tuning_job_id}")
    public Single<FineTuningJob> retrieveFineTuningJob(@Path(value="fine_tuning_job_id") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

    @GET(value="fine_tuning/jobs")
    public Single<PersonalFineTuningJob> queryPersonalFineTuningJobs(@Query(value="limit") Integer var1, @Query(value="after") String var2);

    @POST(value="fine_tuning/jobs/{fine_tuning_job_id}/cancel")
    public Single<FineTuningJob> cancelFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @DELETE(value="fine_tuning/jobs/{fine_tuning_job_id}")
    public Single<FineTuningJob> deleteFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @DELETE(value="fine_tuning/fine_tuned_models/{fine_tuned_model}")
    public Single<FineTunedModelsStatus> deleteFineTuningModel(@Path(value="fine_tuned_model") String var1);

    @POST(value="batches")
    public Single<Batch> batchesCreate(@Body BatchCreateParams var1);

    @GET(value="batches/{batch_id}")
    public Single<Batch> batchesRetrieve(@Path(value="batch_id") String var1);

    @GET(value="batches")
    public Single<BatchPage> batchesList(@Query(value="after") String var1, @Query(value="limit") Integer var2);

    @POST(value="batches/{batch_id}/cancel")
    public Single<Batch> batchesCancel(@Path(value="batch_id") String var1);
}

