/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.zhipu.oapi.core.response.HttpxBinaryResponseContent;
import com.zhipu.oapi.core.response.RawResponse;
import com.zhipu.oapi.service.v4.api.ChatApi;
import com.zhipu.oapi.service.v4.batchs.Batch;
import com.zhipu.oapi.service.v4.batchs.BatchCreateParams;
import com.zhipu.oapi.service.v4.batchs.BatchPage;
import com.zhipu.oapi.service.v4.deserialize.ModelDataDeserializer;
import com.zhipu.oapi.service.v4.embedding.EmbeddingResult;
import com.zhipu.oapi.service.v4.file.FileDeleted;
import com.zhipu.oapi.service.v4.file.QueryFileResult;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.file.UploadFileRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatus;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningEvent;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.PersonalFineTuningJob;
import com.zhipu.oapi.service.v4.image.ImageResult;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.model.ResponseBodyCallback;
import com.zhipu.oapi.service.v4.model.SSE;
import com.zhipu.oapi.service.v4.model.ZhiPuAiError;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import com.zhipu.oapi.utils.StringUtils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.HttpException;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ChatApiService {
    private static final ObjectMapper mapper = ChatApiService.defaultObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(ChatApiService.class);
    private final ChatApi api;
    private final ExecutorService executorService;

    public ChatApiService(OkHttpClient client) {
        Retrofit retrofit = ChatApiService.defaultRetrofit("https://open.bigmodel.cn/api/paas/v4/", client, mapper);
        this.api = (ChatApi)retrofit.create(ChatApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public ChatApiService(OkHttpClient client, String baseUrl) {
        Retrofit retrofit = ChatApiService.defaultRetrofit(baseUrl, client, mapper);
        this.api = (ChatApi)retrofit.create(ChatApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            logger.error("HTTP exception: {}", (Object)e.getMessage());
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                ZhiPuAiError error = (ZhiPuAiError)mapper.readValue(errorBody, ZhiPuAiError.class);
                throw new ZhiPuAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public RawResponse sseExecute(Map<String, Object> request) {
        Flowable<ModelData> flowable;
        RawResponse resp = new RawResponse();
        try {
            flowable = this.streamChatCompletion(request);
        }
        catch (Exception e) {
            logger.error("streamChatCompletion error:{}", (Object)e.getMessage());
            resp.setStatusCode(500);
            resp.setSuccess(false);
            return resp;
        }
        resp.setSuccess(true);
        resp.setStatusCode(200);
        resp.setFlowable(flowable);
        return resp;
    }

    public Flowable<ModelData> streamChatCompletion(Map<String, Object> request) {
        return this.stream(this.api.createChatCompletionStream(request), ModelData.class);
    }

    public ModelData createChatCompletionAsync(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createChatCompletionAsync(request));
    }

    public ModelData createChatCompletion(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createChatCompletion(request));
    }

    public EmbeddingResult createEmbeddings(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createEmbeddings(request));
    }

    public QueryFileResult queryFileList(QueryFilesRequest queryFilesRequest) {
        return ChatApiService.execute(this.api.queryFileList(queryFilesRequest.getAfter(), queryFilesRequest.getPurpose(), queryFilesRequest.getOrder(), queryFilesRequest.getLimit()));
    }

    public HttpxBinaryResponseContent fileContent(String fileId) throws IOException {
        return this.fileWrapper(this.api.fileContent(fileId));
    }

    public com.zhipu.oapi.service.v4.file.File retrieveFile(String fileId) {
        return ChatApiService.execute(this.api.retrieveFile(fileId));
    }

    public FileDeleted deletedFile(String fileId) {
        return ChatApiService.execute(this.api.deletedFile(fileId));
    }

    public FineTuningEvent listFineTuningJobEvents(String fineTuningJobId, Integer limit, String after) {
        return ChatApiService.execute(this.api.listFineTuningJobEvents(fineTuningJobId, limit, after));
    }

    public FineTuningJob retrieveFineTuningJob(String fineTuningJobId, Integer limit, String after) {
        return ChatApiService.execute(this.api.retrieveFineTuningJob(fineTuningJobId, limit, after));
    }

    public PersonalFineTuningJob queryPersonalFineTuningJobs(Integer limit, String after) {
        return ChatApiService.execute(this.api.queryPersonalFineTuningJobs(limit, after));
    }

    public ModelData queryAsyncResult(String id) {
        return ChatApiService.execute(this.api.queryAsyncResult(id));
    }

    public FineTuningJob cancelFineTuningJob(String fineTuningJobId) {
        return ChatApiService.execute(this.api.cancelFineTuningJob(fineTuningJobId));
    }

    public FineTuningJob deleteFineTuningJob(String fineTuningJobId) {
        return ChatApiService.execute(this.api.deleteFineTuningJob(fineTuningJobId));
    }

    public FineTunedModelsStatus deleteFineTuningModel(String fineTunedModel) {
        return ChatApiService.execute(this.api.deleteFineTuningModel(fineTunedModel));
    }

    public com.zhipu.oapi.service.v4.file.File uploadFile(UploadFileRequest request) throws JsonProcessingException {
        File file = new File(request.getFilePath());
        if (!file.exists()) {
            throw new RuntimeException("file not found");
        }
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        MultipartBody.Builder formBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        formBodyBuilder.addPart(filePart);
        formBodyBuilder.addFormDataPart("purpose", request.getPurpose());
        if (request.getExtraJson() != null) {
            for (String s : request.getExtraJson().keySet()) {
                if (request.getExtraJson().get(s) instanceof String || request.getExtraJson().get(s) instanceof Number || request.getExtraJson().get(s) instanceof Boolean || request.getExtraJson().get(s) instanceof Character) {
                    formBodyBuilder.addFormDataPart(s, request.getExtraJson().get(s).toString());
                    continue;
                }
                if (request.getExtraJson().get(s) instanceof Date) {
                    Date date = (Date)request.getExtraJson().get(s);
                    formBodyBuilder.addFormDataPart(s, String.valueOf(date.getTime()));
                    continue;
                }
                formBodyBuilder.addFormDataPart(s, null, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)mapper.writeValueAsString(request.getExtraJson().get(s))));
            }
        }
        MultipartBody multipartBody = formBodyBuilder.build();
        return ChatApiService.execute(this.api.uploadFile(multipartBody));
    }

    public ImageResult createImage(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createImage(request));
    }

    public FineTuningJob createFineTuningJob(FineTuningJobRequest request) {
        return ChatApiService.execute(this.api.createFineTuningJob(request));
    }

    public Batch batchesCreate(BatchCreateParams batchCreateParams) {
        return ChatApiService.execute(this.api.batchesCreate(batchCreateParams));
    }

    public Batch batchesRetrieve(String batchId) {
        return ChatApiService.execute(this.api.batchesRetrieve(batchId));
    }

    public BatchPage batchesList(Integer limit, String after) {
        return ChatApiService.execute(this.api.batchesList(after, limit));
    }

    public Batch batchesCancel(String batchId) {
        return ChatApiService.execute(this.api.batchesCancel(batchId));
    }

    private HttpxBinaryResponseContent fileWrapper(Call<ResponseBody> response) throws IOException {
        Response execute = response.execute();
        if (!execute.isSuccessful() || execute.body() == null) {
            throw new IOException("Failed to get the file content");
        }
        return new HttpxBinaryResponseContent((Response<ResponseBody>)execute);
    }

    private Flowable<ModelData> stream(Call<ResponseBody> apiCall, Class<ModelData> cl) {
        return ChatApiService.stream(apiCall).map(sse -> (ModelData)((Object)((Object)mapper.readValue(sse.getData(), cl))));
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return ChatApiService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public ChatApiService(ChatApi api) {
        this.api = api;
        this.executorService = null;
    }

    public ChatApiService(ChatApi api, ExecutorService executorService) {
        this.api = api;
        this.executorService = executorService;
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ModelData.class, (JsonDeserializer)new ModelDataDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static Retrofit defaultRetrofit(String baseUrl, OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(StringUtils.isEmpty(baseUrl) ? "https://open.bigmodel.cn/api/paas/v4/" : baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }
}

