/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhipu.oapi.core.model.ClientRequest;
import com.zhipu.oapi.core.model.ClientResponse;
import com.zhipu.oapi.core.model.FlowableClientResponse;
import com.zhipu.oapi.service.v4.deserialize.MessageDeserializeFactory;
import com.zhipu.oapi.service.v4.model.ResponseBodyCallback;
import com.zhipu.oapi.service.v4.model.SSE;
import com.zhipu.oapi.service.v4.model.ZhiPuAiError;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import com.zhipu.oapi.utils.FlowableRequestSupplier;
import com.zhipu.oapi.utils.RequestSupplier;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.adapter.rxjava2.HttpException;

abstract class AbstractClientBaseService {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractClientBaseService.class);
    protected static final ObjectMapper mapper = MessageDeserializeFactory.defaultObjectMapper();

    AbstractClientBaseService() {
    }

    public abstract <Data, Param, TReq extends ClientRequest<Param>, TResp extends ClientResponse<Data>> TResp executeRequest(TReq var1, RequestSupplier<Param, Data> var2, Class<TResp> var3);

    public abstract <Data, Param, TReq extends ClientRequest<Param>, TResp extends FlowableClientResponse<Data>> TResp streamRequest(TReq var1, FlowableRequestSupplier<Param, Call<ResponseBody>> var2, Class<TResp> var3, Class<Data> var4);

    public static <T> T execute(Single<T> apiCall) {
        try {
            Object response = apiCall.blockingGet();
            if (response instanceof Response) {
                AbstractClientBaseService.handleResponse((Response)response);
            }
            return (T)response;
        }
        catch (HttpException e) {
            logger.error("HTTP exception: {}", (Object)e.getMessage());
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                ZhiPuAiError error = (ZhiPuAiError)mapper.readValue(errorBody, ZhiPuAiError.class);
                throw new ZhiPuAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    private static void handleResponse(Response<?> response) {
        if (!response.isSuccessful()) {
            throw new HttpException(response);
        }
    }

    public <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return AbstractClientBaseService.stream(apiCall).map(sse -> mapper.readValue(sse.getData(), cl));
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return AbstractClientBaseService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

