/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.zhipu.oapi.AbstractClientBaseService;
import com.zhipu.oapi.core.ConfigV4;
import com.zhipu.oapi.core.cache.ICache;
import com.zhipu.oapi.core.cache.LocalCache;
import com.zhipu.oapi.core.model.ClientRequest;
import com.zhipu.oapi.core.model.ClientResponse;
import com.zhipu.oapi.core.model.FlowableClientResponse;
import com.zhipu.oapi.core.response.HttpxBinaryResponseContent;
import com.zhipu.oapi.core.token.GlobalTokenManager;
import com.zhipu.oapi.core.token.TokenManagerV4;
import com.zhipu.oapi.service.v4.api.ClientApiService;
import com.zhipu.oapi.service.v4.batchs.BatchCreateParams;
import com.zhipu.oapi.service.v4.batchs.BatchRequest;
import com.zhipu.oapi.service.v4.batchs.BatchResponse;
import com.zhipu.oapi.service.v4.batchs.QueryBatchResponse;
import com.zhipu.oapi.service.v4.embedding.EmbeddingApiResponse;
import com.zhipu.oapi.service.v4.embedding.EmbeddingRequest;
import com.zhipu.oapi.service.v4.file.FileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryBatchRequest;
import com.zhipu.oapi.service.v4.file.QueryFileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.file.UploadFileRequest;
import com.zhipu.oapi.service.v4.fine_turning.CreateFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatusResponse;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobIdRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobModelRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningEventApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobRequest;
import com.zhipu.oapi.service.v4.image.CreateImageRequest;
import com.zhipu.oapi.service.v4.image.ImageApiResponse;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequest;
import com.zhipu.oapi.service.v4.model.ChatError;
import com.zhipu.oapi.service.v4.model.ModelApiResponse;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.model.QueryModelResultRequest;
import com.zhipu.oapi.service.v4.model.QueryModelResultResponse;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import com.zhipu.oapi.service.v4.tools.WebSearchApiResponse;
import com.zhipu.oapi.service.v4.tools.WebSearchParamsRequest;
import com.zhipu.oapi.service.v4.tools.WebSearchPro;
import com.zhipu.oapi.service.v4.web_search.WebSearchRequest;
import com.zhipu.oapi.service.v4.web_search.WebSearchResponse;
import com.zhipu.oapi.utils.FlowableRequestSupplier;
import com.zhipu.oapi.utils.OkHttps;
import com.zhipu.oapi.utils.RequestSupplier;
import com.zhipu.oapi.utils.StringUtils;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class ClientV4
extends AbstractClientBaseService {
    private static final Logger logger = LoggerFactory.getLogger(ClientV4.class);
    private ConfigV4 config;
    private ClientApiService chatApiService;

    public ModelApiResponse invokeModelApi(ChatCompletionRequest request) {
        String paramMsg = this.validateParams(request);
        if (StringUtils.isNotEmpty(paramMsg)) {
            return new ModelApiResponse(-100, String.format("invalid param: %s", paramMsg));
        }
        if (request.getStream().booleanValue()) {
            return this.sseInvoke(request);
        }
        if ("invoke".equals(request.getInvokeMethod())) {
            return this.invoke(request);
        }
        if ("async-invoke".equals(request.getInvokeMethod())) {
            return this.asyncInvoke(request);
        }
        return null;
    }

    private ModelApiResponse sseInvoke(ChatCompletionRequest request) {
        FlowableRequestSupplier<Map, Call> supplier = params -> this.chatApiService.streamChatCompletion((Map<String, Object>)params);
        return this.streamRequest(request, supplier, ModelApiResponse.class, ModelData.class);
    }

    private ModelApiResponse invoke(ChatCompletionRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.createChatCompletion((Map<String, Object>)params);
        return this.executeRequest(request, supplier, ModelApiResponse.class);
    }

    private ModelApiResponse asyncInvoke(ChatCompletionRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.createChatCompletionAsync((Map<String, Object>)params);
        return this.executeRequest(request, supplier, ModelApiResponse.class);
    }

    public QueryModelResultResponse queryModelResult(QueryModelResultRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.queryAsyncResult((String)params);
        return this.executeRequest(request, supplier, QueryModelResultResponse.class);
    }

    public ImageApiResponse createImage(CreateImageRequest createImageRequest) {
        RequestSupplier supplier = params -> this.chatApiService.createImage((Map<String, Object>)params);
        return this.executeRequest(createImageRequest, supplier, ImageApiResponse.class);
    }

    private String validateParams(ChatCompletionRequest request) {
        if (request == null) {
            return "request can not be null";
        }
        if (StringUtils.isEmpty(this.config.getApiKey())) {
            return "apikey can not be empty";
        }
        if (StringUtils.isEmpty(this.config.getApiSecret())) {
            return "apiSecret can not be empty";
        }
        if (!request.getStream().booleanValue() && StringUtils.isEmpty(request.getInvokeMethod())) {
            return "invoke method can not be empty";
        }
        if (request.getMessages() == null || request.getMessages().isEmpty()) {
            return "message can not be empty";
        }
        if (request.getModel() == null) {
            return "model can not be empty";
        }
        return null;
    }

    public EmbeddingApiResponse invokeEmbeddingsApi(EmbeddingRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.createEmbeddings((Map<String, Object>)params);
        return this.executeRequest(request, supplier, EmbeddingApiResponse.class);
    }

    public FileApiResponse invokeUploadFileApi(UploadFileRequest request) {
        RequestSupplier supplier = params -> {
            try {
                return this.chatApiService.uploadFile((UploadFileRequest)params);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return this.executeRequest(request, supplier, FileApiResponse.class);
    }

    public QueryFileApiResponse queryFilesApi(QueryFilesRequest queryFilesRequest) {
        RequestSupplier supplier = params -> this.chatApiService.queryFileList((QueryFilesRequest)params);
        return this.executeRequest(queryFilesRequest, supplier, QueryFileApiResponse.class);
    }

    public HttpxBinaryResponseContent fileContent(String fileId) throws IOException {
        return this.chatApiService.fileContent(fileId);
    }

    public CreateFineTuningJobApiResponse createFineTuningJob(FineTuningJobRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.createFineTuningJob((FineTuningJobRequest)params);
        return this.executeRequest(request, supplier, CreateFineTuningJobApiResponse.class);
    }

    public QueryFineTuningEventApiResponse queryFineTuningJobsEvents(QueryFineTuningJobRequest queryFineTuningJobRequest) {
        RequestSupplier supplier = params -> this.chatApiService.listFineTuningJobEvents((String)params.get("job_id"), (Integer)params.get("limit"), (String)params.get("after"));
        return this.executeRequest(queryFineTuningJobRequest, supplier, QueryFineTuningEventApiResponse.class);
    }

    public QueryFineTuningJobApiResponse retrieveFineTuningJobs(QueryFineTuningJobRequest queryFineTuningJobRequest) {
        RequestSupplier supplier = params -> this.chatApiService.retrieveFineTuningJob((String)params.get("job_id"), (Integer)params.get("limit"), (String)params.get("after"));
        return this.executeRequest(queryFineTuningJobRequest, supplier, QueryFineTuningJobApiResponse.class);
    }

    public QueryPersonalFineTuningJobApiResponse queryPersonalFineTuningJobs(QueryPersonalFineTuningJobRequest queryPersonalFineTuningJobRequest) {
        RequestSupplier supplier = params -> this.chatApiService.queryPersonalFineTuningJobs((Integer)params.get("limit"), (String)params.get("after"));
        return this.executeRequest(queryPersonalFineTuningJobRequest, supplier, QueryPersonalFineTuningJobApiResponse.class);
    }

    public QueryFineTuningJobApiResponse cancelFineTuningJob(FineTuningJobIdRequest fineTuningJobIdRequest) {
        RequestSupplier supplier = params -> this.chatApiService.cancelFineTuningJob((String)params.get("job_id"));
        return this.executeRequest(fineTuningJobIdRequest, supplier, QueryFineTuningJobApiResponse.class);
    }

    public QueryFineTuningJobApiResponse deleteFineTuningJob(FineTuningJobIdRequest fineTuningJobIdRequest) {
        RequestSupplier supplier = params -> this.chatApiService.deleteFineTuningJob((String)params.get("job_id"));
        return this.executeRequest(fineTuningJobIdRequest, supplier, QueryFineTuningJobApiResponse.class);
    }

    public FineTunedModelsStatusResponse deleteFineTuningModel(FineTuningJobModelRequest fineTuningJobModelRequest) {
        RequestSupplier supplier = params -> this.chatApiService.deleteFineTuningModel((String)params.get("fine_tuned_model"));
        return this.executeRequest(fineTuningJobModelRequest, supplier, FineTunedModelsStatusResponse.class);
    }

    public BatchResponse batchesCreate(BatchCreateParams batchCreateParams) {
        RequestSupplier supplier = params -> this.chatApiService.batchesCreate((BatchCreateParams)params);
        return this.executeRequest(batchCreateParams, supplier, BatchResponse.class);
    }

    public BatchResponse batchesRetrieve(String batchId) {
        Object request = ((BatchRequest.BatchRequestBuilder)BatchRequest.builder().batchId(batchId)).build();
        RequestSupplier supplier = params -> this.chatApiService.batchesRetrieve((String)params.get("batchId"));
        return this.executeRequest((ClientRequest)request, supplier, (Class)BatchResponse.class);
    }

    public QueryBatchResponse batchesList(QueryBatchRequest queryBatchRequest) {
        RequestSupplier supplier = params -> this.chatApiService.batchesList((Integer)params.get("limit"), (String)params.get("after"));
        return this.executeRequest(queryBatchRequest, supplier, QueryBatchResponse.class);
    }

    public BatchResponse batchesCancel(String batchId) {
        Object request = ((BatchRequest.BatchRequestBuilder)BatchRequest.builder().batchId(batchId)).build();
        RequestSupplier supplier = params -> this.chatApiService.batchesCancel((String)params.get("batchId"));
        return this.executeRequest((ClientRequest)request, supplier, (Class)BatchResponse.class);
    }

    public WebSearchApiResponse webSearchProStreamingInvoke(WebSearchParamsRequest request) {
        FlowableRequestSupplier<Map, Call> supplier = params -> this.chatApiService.webSearchProStreaming((Map<String, Object>)params);
        return this.streamRequest(request, supplier, WebSearchApiResponse.class, WebSearchPro.class);
    }

    public WebSearchApiResponse invokeWebSearchPro(WebSearchParamsRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.webSearchPro((Map<String, Object>)params);
        return this.executeRequest(request, supplier, WebSearchApiResponse.class);
    }

    public WebSearchResponse invokeWebSearch(WebSearchRequest request) {
        RequestSupplier supplier = params -> this.chatApiService.webSearch(request);
        return this.executeRequest(request, supplier, WebSearchResponse.class);
    }

    @Override
    public <Data, Param, TReq extends ClientRequest<Param>, TResp extends ClientResponse<Data>> TResp executeRequest(TReq request, RequestSupplier<Param, Data> requestSupplier, Class<TResp> tRespClass) {
        Single<Data> apiCall = requestSupplier.get(request.getOptions());
        TResp tResp = this.convertToClientResponse(tRespClass);
        try {
            Data response = ClientV4.execute(apiCall);
            tResp.setCode(200);
            tResp.setMsg("\u8c03\u7528\u6210\u529f");
            tResp.setData(response);
            tResp.setSuccess(true);
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            tResp.setCode(e.statusCode);
            tResp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            tResp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            tResp.setError(chatError);
        }
        return tResp;
    }

    @Override
    public <Data, Param, TReq extends ClientRequest<Param>, TResp extends FlowableClientResponse<Data>> TResp streamRequest(TReq request, FlowableRequestSupplier<Param, Call<ResponseBody>> requestSupplier, Class<TResp> tRespClass, Class<Data> tDataClass) {
        Call<ResponseBody> apiCall = requestSupplier.get(request.getOptions());
        FlowableClientResponse tResp = (FlowableClientResponse)this.convertToClientResponse(tRespClass);
        try {
            Flowable stream = this.stream((Call)apiCall, (Class)tDataClass);
            tResp.setCode(200);
            tResp.setMsg("\u8c03\u7528\u6210\u529f");
            tResp.setCode(200);
            tResp.setMsg("\u6210\u529f");
            tResp.setSuccess(true);
            tResp.setFlowable(stream);
        }
        catch (ZhiPuAiHttpException e) {
            logger.error("\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            tResp.setCode(e.statusCode);
            tResp.setMsg("\u4e1a\u52a1\u51fa\u9519");
            tResp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            tResp.setError(chatError);
        }
        return (TResp)tResp;
    }

    private <Data, TResp extends ClientResponse<Data>> TResp convertToClientResponse(Class<TResp> tRespClass) {
        try {
            return (TResp)((ClientResponse)tRespClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create response object", e);
        }
    }

    public void setConfig(ConfigV4 config) {
        this.config = config;
    }

    public ConfigV4 getConfig() {
        return this.config;
    }

    public void setChatApiService(ClientApiService chatApiService) {
        this.chatApiService = chatApiService;
    }

    public ClientApiService getChatApiService() {
        return this.chatApiService;
    }

    public static final class Builder {
        private final ConfigV4 config = new ConfigV4();

        public Builder(String apiSecretKey) {
            this.config.setApiSecretKey(apiSecretKey);
        }

        public Builder(String baseUrl, String apiSecretKey) {
            this.config.setBaseUrl(baseUrl);
            this.config.setApiSecretKey(apiSecretKey);
        }

        public Builder setTokenKey(String apiKey, String apiSecret) {
            this.config.setApiKey(apiKey);
            this.config.setApiSecret(apiSecret);
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder enableTokenCache() {
            this.config.setDisableTokenCache(false);
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder tokenExpire(int expireMillis) {
            this.config.setExpireMillis(expireMillis);
            return this;
        }

        public Builder networkConfig(int requestTimeOut, int connectTimeout, int readTimeout, int writeTimeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(requestTimeOut);
            this.config.setConnectTimeout(connectTimeout);
            this.config.setReadTimeout(readTimeout);
            this.config.setWriteTimeout(writeTimeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            this.config.setConnectionPool(connectionPool);
            return this;
        }

        private void initCache(ConfigV4 config) {
            if (config.getCache() != null) {
                GlobalTokenManager.setTokenManager(new TokenManagerV4(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalTokenManager.setTokenManager(new TokenManagerV4(cache));
            }
        }

        private void initHttpTransport(ConfigV4 config) {
            if (config.getHttpClient() == null) {
                if (StringUtils.isEmpty(config.getApiSecretKey())) {
                    throw new RuntimeException("apiSecretKey can not be empty");
                }
                OkHttpClient okHttpClient = OkHttps.create(config);
                config.setHttpClient(okHttpClient);
            }
        }

        public ClientV4 build() {
            ClientV4 client = new ClientV4();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            String baseUrl = null;
            baseUrl = StringUtils.isEmpty(this.config.getBaseUrl()) ? "https://open.bigmodel.cn/api/paas/v4/" : this.config.getBaseUrl();
            client.setChatApiService(new ClientApiService(this.config.getHttpClient(), baseUrl));
            return client;
        }
    }
}

