/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.zhipu.oapi.ClientV4;
import com.zhipu.oapi.service.v4.api.ClientBaseService;
import com.zhipu.oapi.service.v4.api.GenerationChain;
import com.zhipu.oapi.service.v4.api.knowledge.document.DocumentApi;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentCreateParams;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentData;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentDataResponse;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentEditParams;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentEditResponse;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentObject;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentObjectResponse;
import com.zhipu.oapi.service.v4.knowledge.document.DocumentPage;
import com.zhipu.oapi.service.v4.knowledge.document.QueryDocumentApiResponse;
import com.zhipu.oapi.service.v4.knowledge.document.QueryDocumentRequest;
import com.zhipu.oapi.utils.RequestSupplier;
import io.reactivex.Single;
import java.io.File;
import java.util.Date;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Response;

public class DocumentClientApiService
extends ClientBaseService {
    private final DocumentApi documentApi;

    public DocumentClientApiService(OkHttpClient client, String baseUrl) {
        super(client, baseUrl);
        this.documentApi = (DocumentApi)this.retrofit.create(DocumentApi.class);
    }

    public DocumentCreateGenerationChain createDocument(DocumentCreateParams params) throws JsonProcessingException {
        if (params.getUploadDetail() != null && params.getFilePath() != null) {
            throw new RuntimeException("upload detail \u548c file path \u53ea\u80fd\u5b58\u5728\u4e00\u4e2a");
        }
        MultipartBody.Builder formBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (params.getFilePath() != null) {
            File file = new File(params.getFilePath());
            if (!file.exists()) {
                throw new RuntimeException("file not found");
            }
            MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
            formBodyBuilder.addPart(filePart);
        }
        if (params.getUploadDetail() != null) {
            formBodyBuilder.addFormDataPart("upload_detail", null, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)mapper.writeValueAsString(params.getUploadDetail())));
        }
        formBodyBuilder.addFormDataPart("knowledge_id", params.getKnowledgeId());
        if (params.getSentenceSize() != null) {
            formBodyBuilder.addFormDataPart("sentence_size", String.valueOf(params.getSentenceSize()));
        }
        formBodyBuilder.addFormDataPart("purpose", params.getPurpose());
        if (params.getCustomSeparator() != null) {
            formBodyBuilder.addFormDataPart("custom_separator", null, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)mapper.writeValueAsString(params.getCustomSeparator())));
        }
        if (params.getExtraJson() != null) {
            for (String s : params.getExtraJson().keySet()) {
                if (params.getExtraJson().get(s) instanceof String || params.getExtraJson().get(s) instanceof Number || params.getExtraJson().get(s) instanceof Boolean || params.getExtraJson().get(s) instanceof Character) {
                    formBodyBuilder.addFormDataPart(s, params.getExtraJson().get(s).toString());
                    continue;
                }
                if (params.getExtraJson().get(s) instanceof Date) {
                    Date date = (Date)params.getExtraJson().get(s);
                    formBodyBuilder.addFormDataPart(s, String.valueOf(date.getTime()));
                    continue;
                }
                formBodyBuilder.addFormDataPart(s, null, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)mapper.writeValueAsString(params.getExtraJson().get(s))));
            }
        }
        MultipartBody multipartBody = formBodyBuilder.build();
        Single<DocumentObject> documentObjectSingle = this.documentApi.createDocument(multipartBody);
        return new DocumentCreateGenerationChain(params, documentObjectSingle);
    }

    public DocumentEditGenerationChain modifyDocument(DocumentEditParams params) {
        Single<Response<Void>> single = this.documentApi.modifyDocument(params.getId(), params);
        return new DocumentEditGenerationChain(params, single);
    }

    public DocumentEditGenerationChain deleteDocument(DocumentEditParams params) {
        Single<Response<Void>> single = this.documentApi.deleteDocument(params.getId());
        return new DocumentEditGenerationChain(params, single);
    }

    public DocumentPageGenerationChain queryDocumentList(QueryDocumentRequest params) {
        Single<DocumentPage> single = this.documentApi.queryDocumentList((Map<String, Object>)params.getOptions());
        return new DocumentPageGenerationChain(params, single);
    }

    public DocumentDataGenerationChain retrieveDocument(DocumentEditParams params) {
        Single<DocumentData> single = this.documentApi.retrieveDocument(params.getId());
        return new DocumentDataGenerationChain(params, single);
    }

    public static class DocumentCreateGenerationChain
    extends GenerationChain<DocumentObject, DocumentObjectResponse> {
        private final DocumentCreateParams params;
        private final Single<DocumentObject> objectSingle;

        public DocumentCreateGenerationChain(DocumentCreateParams params, Single<DocumentObject> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public DocumentObjectResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, DocumentObjectResponse.class);
        }
    }

    public static class DocumentEditGenerationChain
    extends GenerationChain<Response<Void>, DocumentEditResponse> {
        private final DocumentEditParams params;
        private final Single<Response<Void>> objectSingle;

        public DocumentEditGenerationChain(DocumentEditParams params, Single<Response<Void>> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public DocumentEditResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, DocumentEditResponse.class);
        }
    }

    public static class DocumentPageGenerationChain
    extends GenerationChain<DocumentPage, QueryDocumentApiResponse> {
        private final QueryDocumentRequest params;
        private final Single<DocumentPage> objectSingle;

        public DocumentPageGenerationChain(QueryDocumentRequest params, Single<DocumentPage> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public QueryDocumentApiResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, QueryDocumentApiResponse.class);
        }
    }

    public static class DocumentDataGenerationChain
    extends GenerationChain<DocumentData, DocumentDataResponse> {
        private final DocumentEditParams params;
        private final Single<DocumentData> objectSingle;

        public DocumentDataGenerationChain(DocumentEditParams params, Single<DocumentData> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public DocumentDataResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, DocumentDataResponse.class);
        }
    }
}

