/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.zhipu.oapi.ClientV4;
import com.zhipu.oapi.service.v4.api.ClientBaseService;
import com.zhipu.oapi.service.v4.api.GenerationChain;
import com.zhipu.oapi.service.v4.api.videos.VideosApi;
import com.zhipu.oapi.service.v4.videos.VideoCreateParams;
import com.zhipu.oapi.service.v4.videos.VideoObject;
import com.zhipu.oapi.service.v4.videos.VideosResponse;
import com.zhipu.oapi.utils.RequestSupplier;
import io.reactivex.Single;
import okhttp3.OkHttpClient;

public class VideosClientApiService
extends ClientBaseService {
    private final VideosApi videosApi;

    public VideosClientApiService(OkHttpClient client, String baseUrl) {
        super(client, baseUrl);
        this.videosApi = (VideosApi)this.retrofit.create(VideosApi.class);
    }

    public VideoGenerationChain videoGenerations(VideoCreateParams params) {
        Single<VideoObject> videoObjectSingle = this.videosApi.videoGenerations(params);
        return new VideoGenerationChain(params, videoObjectSingle);
    }

    public VideoGenerationChain videoGenerationsResult(VideoCreateParams params) {
        Single<VideoObject> videoObjectSingle = this.videosApi.videoGenerationsResult(params.getId());
        return new VideoGenerationChain(params, videoObjectSingle);
    }

    public static class VideoGenerationChain
    extends GenerationChain<VideoObject, VideosResponse> {
        private final VideoCreateParams params;
        private final Single<VideoObject> videoObjectSingle;

        public VideoGenerationChain(VideoCreateParams params, Single<VideoObject> videoObjectSingle) {
            this.params = params;
            this.videoObjectSingle = videoObjectSingle;
        }

        @Override
        public VideosResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.videoObjectSingle;
            return clientV4.executeRequest(this.params, supplier, VideosResponse.class);
        }
    }
}

