/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.assistant;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zhipu.oapi.service.v4.assistant.AssistantChoice;
import com.zhipu.oapi.service.v4.assistant.CompletionUsage;
import com.zhipu.oapi.service.v4.assistant.ErrorInfo;
import com.zhipu.oapi.service.v4.deserialize.MessageDeserializeFactory;
import com.zhipu.oapi.service.v4.deserialize.assistant.AssistantCompletionDeserializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=AssistantCompletionDeserializer.class)
public class AssistantCompletion
extends ObjectNode {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="conversation_id")
    private String conversationId;
    @JsonProperty(value="assistant_id")
    private String assistantId;
    @JsonProperty(value="created")
    private int created;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="last_error")
    private ErrorInfo lastError;
    @JsonProperty(value="choices")
    private List<AssistantChoice> choices;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;
    @JsonProperty(value="usage")
    private CompletionUsage usage;

    public AssistantCompletion() {
        super(JsonNodeFactory.instance);
    }

    public AssistantCompletion(ObjectNode objectNode) {
        super(JsonNodeFactory.instance);
        ObjectMapper objectMapper = MessageDeserializeFactory.defaultObjectMapper();
        if (objectNode.has("id")) {
            this.setId(objectNode.get("id").asText());
        } else {
            this.setId(null);
        }
        if (objectNode.has("conversation_id")) {
            this.setConversationId(objectNode.get("conversation_id").asText());
        } else {
            this.setConversationId(null);
        }
        if (objectNode.has("assistant_id")) {
            this.setAssistantId(objectNode.get("assistant_id").asText());
        } else {
            this.setAssistantId(null);
        }
        if (objectNode.has("created")) {
            this.setCreated(objectNode.get("created").asInt());
        } else {
            this.setCreated(0);
        }
        if (objectNode.has("status")) {
            this.setStatus(objectNode.get("status").asText());
        } else {
            this.setStatus(null);
        }
        if (objectNode.has("last_error")) {
            this.setLastError((ErrorInfo)((Object)objectMapper.convertValue((Object)objectNode.get("last_error"), ErrorInfo.class)));
        } else {
            this.setLastError(null);
        }
        if (objectNode.has("choices")) {
            List choices1 = (List)objectMapper.convertValue((Object)objectNode.get("choices"), (TypeReference)new TypeReference<List<AssistantChoice>>(){});
            this.setChoices(choices1);
        } else {
            this.setChoices(null);
        }
        if (objectNode.has("metadata")) {
            this.setMetadata((Map)objectMapper.convertValue((Object)objectNode.get("metadata"), Map.class));
        } else {
            this.setMetadata(null);
        }
        if (objectNode.has("usage")) {
            this.setUsage((CompletionUsage)((Object)objectMapper.convertValue((Object)objectNode.get("usage"), CompletionUsage.class)));
        } else {
            this.setUsage(null);
        }
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode field = objectNode.get(fieldName);
            this.set(fieldName, field);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.put("id", id);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
        this.put("conversation_id", conversationId);
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
        this.put("assistant_id", assistantId);
    }

    public int getCreated() {
        return this.created;
    }

    public void setCreated(int created) {
        this.created = created;
        this.put("created", created);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.put("status", status);
    }

    public ErrorInfo getLastError() {
        return this.lastError;
    }

    public void setLastError(ErrorInfo lastError) {
        this.lastError = lastError;
        this.putPOJO("last_error", (Object)lastError);
    }

    public List<AssistantChoice> getChoices() {
        return this.choices;
    }

    public void setChoices(List<AssistantChoice> choices) {
        this.choices = choices;
        ArrayNode jsonNodes = this.putArray("choices");
        if (choices == null) {
            jsonNodes.removeAll();
        } else {
            for (AssistantChoice choice : choices) {
                jsonNodes.add((JsonNode)choice);
            }
        }
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        this.putPOJO("metadata", metadata);
    }

    public CompletionUsage getUsage() {
        return this.usage;
    }

    public void setUsage(CompletionUsage usage) {
        this.usage = usage;
        this.putPOJO("usage", (Object)usage);
    }
}

