/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.embedding;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zhipu.oapi.service.v4.deserialize.MessageDeserializeFactory;
import com.zhipu.oapi.service.v4.deserialize.embedding.EmbeddingDeserializer;
import java.util.Iterator;
import java.util.List;

@JsonDeserialize(using=EmbeddingDeserializer.class)
public class Embedding
extends ObjectNode {
    String object;
    List<Double> embedding;
    Integer index;

    public Embedding() {
        super(JsonNodeFactory.instance);
    }

    public Embedding(ObjectNode objectNode) {
        super(JsonNodeFactory.instance);
        ObjectMapper objectMapper = MessageDeserializeFactory.defaultObjectMapper();
        if (objectNode.get("object") != null) {
            this.setObject(objectNode.get("object").asText());
        } else {
            this.setObject(null);
        }
        if (objectNode.get("index") != null) {
            this.setIndex(objectNode.get("index").asInt());
        } else {
            this.setIndex(null);
        }
        if (objectNode.get("embedding") != null) {
            List embedding = (List)objectMapper.convertValue((Object)objectNode.get("embedding"), (TypeReference)new TypeReference<List<Double>>(){});
            this.setEmbedding(embedding);
        } else {
            this.setEmbedding(null);
        }
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode field = objectNode.get(fieldName);
            this.set(fieldName, field);
        }
    }

    public void setIndex(Integer index) {
        this.index = index;
        this.put("index", index);
    }

    public void setObject(String object) {
        this.object = object;
        this.put("object", object);
    }

    public void setEmbedding(List<Double> embedding) throws IllegalArgumentException {
        if (embedding == null || embedding.isEmpty()) {
            throw new IllegalArgumentException("Embedding cannot be null or empty");
        }
        this.embedding = embedding;
        this.putPOJO("embedding", embedding);
    }

    public String getObject() {
        return this.object;
    }

    public List<Double> getEmbedding() {
        return this.embedding;
    }

    public Integer getIndex() {
        return this.index;
    }
}

