/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.realtime;

import com.zhipu.oapi.service.v4.realtime.JasonUtil;
import com.zhipu.oapi.service.v4.realtime.RealtimeClientEvent;
import com.zhipu.oapi.service.v4.realtime.RealtimeServerEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpRealtimeClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpRealtimeClient.class);
    private final OkHttpClient client;
    private final CommunicationProvider communicationProvider;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final Consumer<RealtimeServerEvent> serverEventHandler;
    private final ConnectivityMonitor connectivityMonitor = new ConnectivityMonitor();
    private final boolean closeClientOnClose;

    public OkHttpRealtimeClient(CommunicationProvider communicationProvider, Consumer<RealtimeServerEvent> serverEventHandler, OkHttpClient client) {
        this.client = client;
        this.communicationProvider = communicationProvider;
        this.serverEventHandler = serverEventHandler;
        this.closeClientOnClose = false;
    }

    public OkHttpRealtimeClient(CommunicationProvider communicationProvider, Consumer<RealtimeServerEvent> serverEventHandler, OkHttpClient client, boolean closeClientOnClose) {
        this.client = client;
        this.communicationProvider = communicationProvider;
        this.serverEventHandler = serverEventHandler;
        this.closeClientOnClose = false;
    }

    public OkHttpRealtimeClient(CommunicationProvider communicationProvider, Consumer<RealtimeServerEvent> serverEventHandler) {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        Dispatcher dispatcher = new Dispatcher(executorService);
        dispatcher.setMaxRequests(4);
        dispatcher.setMaxRequestsPerHost(2);
        this.client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).callTimeout(40L, TimeUnit.SECONDS).pingInterval(10L, TimeUnit.SECONDS).dispatcher(dispatcher).build();
        this.communicationProvider = communicationProvider;
        this.serverEventHandler = serverEventHandler;
        this.closeClientOnClose = true;
    }

    public void start() {
        if (this.isDisposed.get()) {
            throw new IllegalStateException("\u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
        }
        EnumSet<ConnectivityState> allowedStates = EnumSet.of(ConnectivityState.STOPPED, ConnectivityState.DISCONNECTED);
        if (!this.connectivityMonitor.changeStateOnAnyOf(allowedStates, ConnectivityState.CONNECTING)) {
            throw new IllegalStateException("\u65e0\u6cd5\u5728\u72b6\u6001 " + (Object)((Object)this.connectivityMonitor.get()) + " \u4e0b\u542f\u52a8\u8fde\u63a5");
        }
        WebSocketListener listener = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                logger.info("WebSocket\u8fde\u63a5\u5df2\u5efa\u7acb");
                OkHttpRealtimeClient.this.webSocketRef.set(webSocket);
                OkHttpRealtimeClient.this.connectivityMonitor.changeState(ConnectivityState.CONNECTED);
            }

            public void onMessage(WebSocket webSocket, String text) {
                logger.debug("\u6536\u5230\u6d88\u606f: {}", (Object)text);
                RealtimeServerEvent serverEvent = JasonUtil.fromJsonToServerEvent(text);
                if (serverEvent == null) {
                    logger.error("\u65e0\u6cd5\u89e3\u6790\u670d\u52a1\u5668\u4e8b\u4ef6: {}", (Object)text);
                    return;
                }
                OkHttpRealtimeClient.this.serverEventHandler.accept(serverEvent);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                logger.info("\u8fde\u63a5\u6b63\u5e38\u5173\u95ed\uff0c\u539f\u56e0\uff1a{}", (Object)reason);
                OkHttpRealtimeClient.this.webSocketRef.set(null);
                if (!this.isStoppingState()) {
                    OkHttpRealtimeClient.this.connectivityMonitor.changeState(ConnectivityState.DISCONNECTED);
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                logger.error("\u8fde\u63a5\u5f02\u5e38", t);
                if (response != null) {
                    logger.error("\u5f02\u5e38\u54cd\u5e94\u7801\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)response.code(), (Object)(response.body() != null ? response.body().toString() : "\u7a7a\u5185\u5bb9"));
                }
                OkHttpRealtimeClient.this.webSocketRef.set(null);
                if (!this.isStoppingState()) {
                    OkHttpRealtimeClient.this.connectivityMonitor.changeState(ConnectivityState.DISCONNECTED);
                }
            }

            private boolean isStoppingState() {
                ConnectivityState state = OkHttpRealtimeClient.this.connectivityMonitor.get();
                return state == ConnectivityState.STOPPING || state == ConnectivityState.CLOSED;
            }
        };
        Request request = new Request.Builder().url(this.communicationProvider.getWebSocketUrl()).addHeader("Authorization", "Bearer " + this.communicationProvider.getAuthToken()).build();
        request.url().redact();
        this.client.newWebSocket(request, listener);
        this.client.dispatcher().executorService().submit(() -> logger.info("WebSocket\u8fde\u63a5\u7ebf\u7a0b\u5df2\u542f\u52a8"));
    }

    public void stop() {
        ConnectivityState currentState = this.connectivityMonitor.get();
        if (currentState == ConnectivityState.CLOSED) {
            throw new IllegalStateException("\u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
        }
        if (this.connectivityMonitor.changeStateOn(ConnectivityState.CONNECTED, ConnectivityState.STOPPING)) {
            WebSocket webSocket = this.webSocketRef.get();
            if (webSocket != null) {
                webSocket.close(1000, "\u6b63\u5e38\u5173\u95ed");
            }
        } else {
            logger.warn("\u505c\u6b62\u5931\u8d25\uff0c\u5f53\u524d\u72b6\u6001\uff1a{}", (Object)this.connectivityMonitor.get());
        }
    }

    public void waitForConnection() throws InterruptedException {
        while (this.connectivityMonitor.get() != ConnectivityState.CONNECTED) {
            Thread.sleep(100L);
        }
    }

    public void sendMessage(RealtimeClientEvent clientEvent) {
        ConnectivityState state = this.connectivityMonitor.get();
        if (state != ConnectivityState.CONNECTED) {
            throw new IllegalStateException("\u8fde\u63a5\u672a\u5c31\u7eea\uff0c\u5f53\u524d\u72b6\u6001\uff1a" + (Object)((Object)state));
        }
        WebSocket webSocket = this.webSocketRef.get();
        if (webSocket == null) {
            throw new IllegalStateException("WebSocket\u8fde\u63a5\u672a\u5efa\u7acb");
        }
        String jsonMessage = JasonUtil.toJsonFromClientEvent(clientEvent);
        if (jsonMessage == null) {
            logger.error("\u65e0\u6cd5\u5e8f\u5217\u5316\u5ba2\u6237\u7aef\u4e8b\u4ef6: type={}, event_id={}", (Object)clientEvent.getType(), (Object)clientEvent.getEventId());
            return;
        }
        webSocket.send(jsonMessage);
    }

    @Override
    public void close() throws IOException {
        if (this.isDisposed.compareAndSet(false, true)) {
            this.connectivityMonitor.changeState(ConnectivityState.CLOSED);
            WebSocket webSocket = this.webSocketRef.get();
            if (webSocket != null) {
                webSocket.close(1000, "\u5ba2\u6237\u7aef\u5173\u95ed");
                this.webSocketRef.set(null);
            }
            if (this.closeClientOnClose) {
                this.client.dispatcher().executorService().shutdown();
            }
        }
    }

    public static final class ConnectivityMonitor {
        private final AtomicReference<ConnectivityState> clientState = new AtomicReference<ConnectivityState>(ConnectivityState.STOPPED);

        public ConnectivityState get() {
            return this.clientState.get();
        }

        public boolean changeStateOn(ConnectivityState expected, ConnectivityState newState) {
            boolean updated = this.clientState.compareAndSet(expected, newState);
            if (updated) {
                logger.info("\u72b6\u6001\u53d8\u66f4\uff1a{} -> {}", (Object)expected, (Object)newState);
            }
            return updated;
        }

        public boolean changeStateOnAnyOf(EnumSet<ConnectivityState> expecteds, ConnectivityState newState) {
            ConnectivityState current;
            do {
                if (expecteds.contains((Object)(current = this.clientState.get()))) continue;
                return false;
            } while (!this.clientState.compareAndSet(current, newState));
            logger.info("\u72b6\u6001\u53d8\u66f4\uff1a{} -> {}", (Object)current, (Object)newState);
            return true;
        }

        public void changeState(ConnectivityState newState) {
            ConnectivityState prev = this.clientState.getAndSet(newState);
            logger.info("\u72b6\u6001\u53d8\u66f4\uff1a{} -> {}", (Object)prev, (Object)newState);
        }
    }

    public static interface CommunicationProvider {
        public String getWebSocketUrl();

        public String getAuthToken();
    }

    public static enum ConnectivityState {
        STOPPED,
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        STOPPING,
        CLOSED;

    }
}

