/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.realtime.object;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=ConfigIntOrInfSerializer.class)
@JsonDeserialize(using=ConfigIntOrInfDeserializer.class)
public class IntOrInfObj {
    private final Integer value;
    private final Boolean isInf;

    private IntOrInfObj(Integer value, Boolean isInf) {
        this.value = value;
        this.isInf = isInf;
    }

    public static IntOrInfObj inf() {
        return new IntOrInfObj(null, true);
    }

    public static IntOrInfObj of(int value) throws IllegalArgumentException {
        if (value < 1 || value > 262144) {
            return new IntOrInfObj(null, true);
        }
        return new IntOrInfObj(value, false);
    }

    public String toString() {
        return this.isInf != false ? "inf" : this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntOrInfObj that = (IntOrInfObj)o;
        return this.isInf == that.isInf && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.isInf);
    }

    public Integer getValue() {
        return this.value;
    }

    public Boolean getIsInf() {
        return this.isInf;
    }

    public static class ConfigIntOrInfDeserializer
    extends JsonDeserializer<IntOrInfObj> {
        public IntOrInfObj deserialize(JsonParser p, DeserializationContext context) throws IOException {
            String text = p.getText();
            if (text == null) {
                return null;
            }
            if ("inf".equalsIgnoreCase(text)) {
                return IntOrInfObj.inf();
            }
            try {
                int intValue = Integer.parseInt(text);
                return IntOrInfObj.of(intValue);
            }
            catch (NumberFormatException e) {
                return IntOrInfObj.inf();
            }
        }
    }

    public static class ConfigIntOrInfSerializer
    extends JsonSerializer<IntOrInfObj> {
        public void serialize(IntOrInfObj value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.isInf != null && value.getIsInf().booleanValue()) {
                gen.writeString("inf");
            } else {
                gen.writeNumber(value.getValue().intValue());
            }
        }
    }
}

