/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.videos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zhipu.oapi.service.v4.deserialize.MessageDeserializeFactory;
import com.zhipu.oapi.service.v4.deserialize.videos.VideoObjectDeserializer;
import com.zhipu.oapi.service.v4.videos.VideoResult;
import java.util.Iterator;
import java.util.List;

@JsonDeserialize(using=VideoObjectDeserializer.class)
public class VideoObject
extends ObjectNode {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="video_result")
    private List<VideoResult> videoResult;
    @JsonProperty(value="task_status")
    private String taskStatus;
    @JsonProperty(value="optimized_prompt")
    private String optimizedPrompt;
    @JsonProperty(value="request_id")
    private String requestId;

    public VideoObject() {
        super(JsonNodeFactory.instance);
    }

    public VideoObject(ObjectNode objectNode) {
        super(JsonNodeFactory.instance);
        ObjectMapper objectMapper = MessageDeserializeFactory.defaultObjectMapper();
        if (objectNode.get("video_result") != null) {
            List videoResults = (List)objectMapper.convertValue((Object)objectNode.get("video_result"), (TypeReference)new TypeReference<List<VideoResult>>(){});
            this.setVideoResult(videoResults);
        } else {
            this.setVideoResult(null);
        }
        if (objectNode.get("id") != null) {
            this.setId(objectNode.get("id").asText());
        } else {
            this.setId(null);
        }
        if (objectNode.get("model") != null) {
            this.setModel(objectNode.get("model").asText());
        } else {
            this.setModel(null);
        }
        if (objectNode.get("task_status") != null) {
            this.setTaskStatus(objectNode.get("task_status").asText());
        } else {
            this.setTaskStatus(null);
        }
        if (objectNode.get("optimized_prompt") != null) {
            this.setOptimizedPrompt(objectNode.get("optimized_prompt").asText());
        } else {
            this.setOptimizedPrompt(null);
        }
        if (objectNode.get("request_id") != null) {
            this.setRequestId(objectNode.get("request_id").asText());
        } else {
            this.setRequestId(null);
        }
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode field = objectNode.get(fieldName);
            this.set(fieldName, field);
        }
    }

    public void setId(String id) {
        this.id = id;
        this.put("id", id);
    }

    public void setModel(String model) {
        this.model = model;
        this.put("model", model);
    }

    public void setVideoResult(List<VideoResult> videoResult) {
        this.videoResult = videoResult;
        ArrayNode jsonNodes = this.putArray("video_result");
        if (videoResult == null) {
            jsonNodes.removeAll();
        } else {
            for (VideoResult video : videoResult) {
                jsonNodes.add((JsonNode)video);
            }
        }
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
        this.put("task_status", taskStatus);
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
        this.put("request_id", requestId);
    }

    public void setOptimizedPrompt(String optimizedPrompt) {
        this.optimizedPrompt = optimizedPrompt;
        this.put("optimized_prompt", optimizedPrompt);
    }

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public List<VideoResult> getVideoResult() {
        return this.videoResult;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public String getOptimizedPrompt() {
        return this.optimizedPrompt;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

