/*
 * Decompiled with CFR 0.152.
 */
package cn.bluemobi.dylan.smartwebview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.webkit.GeolocationPermissions;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import cn.bluemobi.dylan.smartwebview.R;
import cn.bluemobi.dylan.smartwebview.WebLoadCallBack;
import cn.bluemobi.dylan.smartwebview.ssl.SslWebViewClient;

public class SmartWebView
extends RelativeLayout {
    private Context context;
    private WebView mWebView = null;
    private ProgressBar progressBar = null;
    private RelativeLayout progressBar_circle = null;
    private int mProgressStyle = ProgressStyle.Horizontal.ordinal();
    public static int DEFAULT_BAR_HEIGHT = 8;
    private int mBarHeight = DEFAULT_BAR_HEIGHT;
    private WebLoadCallBack loadCallBack;

    public void setLoadCallBack(WebLoadCallBack loadCallBack) {
        this.loadCallBack = loadCallBack;
    }

    public SmartWebView(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    public SmartWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.WebViewWithProgress);
        this.mProgressStyle = attributes.getInt(R.styleable.WebViewWithProgress_progressStyle, ProgressStyle.Horizontal.ordinal());
        this.mBarHeight = attributes.getDimensionPixelSize(R.styleable.WebViewWithProgress_barHeight, DEFAULT_BAR_HEIGHT);
        attributes.recycle();
        this.init();
    }

    private void init() {
        this.mWebView = new WebView(this.context);
        this.addView((View)this.mWebView, -1, -1);
        if (this.mProgressStyle == ProgressStyle.Horizontal.ordinal()) {
            this.progressBar = (ProgressBar)LayoutInflater.from((Context)this.context).inflate(R.layout.ac_progress_horizontal, null);
            this.progressBar.setMax(100);
            this.progressBar.setProgress(0);
            this.addView((View)this.progressBar, -1, this.mBarHeight);
        } else {
            this.progressBar_circle = (RelativeLayout)LayoutInflater.from((Context)this.context).inflate(R.layout.ac_progress_circle, null);
            this.addView((View)this.progressBar_circle, -1, -1);
        }
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(SmartWebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                super.onGeolocationPermissionsShowPrompt(origin, callback);
                callback.invoke(origin, true, false);
            }

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress == 100) {
                    if (SmartWebView.this.progressBar != null) {
                        SmartWebView.this.progressBar.setVisibility(8);
                    }
                    if (SmartWebView.this.progressBar_circle != null) {
                        SmartWebView.this.progressBar_circle.setVisibility(8);
                    }
                    if (SmartWebView.this.loadCallBack != null) {
                        SmartWebView.this.loadCallBack.onLoaded(view.getUrl());
                    }
                } else if (SmartWebView.this.mProgressStyle == ProgressStyle.Horizontal.ordinal()) {
                    SmartWebView.this.progressBar.setVisibility(0);
                    SmartWebView.this.progressBar.setProgress(newProgress);
                } else {
                    SmartWebView.this.progressBar_circle.setVisibility(0);
                }
            }
        });
    }

    private void setWebChromeClient(WebViewClient webViewClient) {
    }

    public void loadUrl(String url) {
        this.loadUrl(this.mWebView, url, null);
    }

    public void loadData(String data) {
        this.loadUrl(this.mWebView, null, data);
    }

    private void setWebChromeClient(WebChromeClient webChromeClient) {
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected void loadUrl(WebView wv, String url, String data) {
        if (Build.VERSION.SDK_INT >= 19) {
            wv.getSettings().setLoadsImagesAutomatically(true);
        } else {
            wv.getSettings().setLoadsImagesAutomatically(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            wv.getSettings().setMixedContentMode(2);
        }
        wv.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        wv.getSettings().setUseWideViewPort(true);
        wv.setVerticalScrollBarEnabled(false);
        wv.setVerticalScrollbarOverlay(false);
        wv.setHorizontalScrollBarEnabled(false);
        wv.setHorizontalScrollbarOverlay(false);
        WebSettings webSettings = wv.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setDomStorageEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setBlockNetworkImage(false);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setAllowFileAccess(true);
        webSettings.setCacheMode(2);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        wv.getSettings().setDatabaseEnabled(true);
        String dir = this.getContext().getDir("database", 0).getPath();
        wv.getSettings().setGeolocationEnabled(true);
        wv.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        wv.getSettings().setGeolocationDatabasePath(dir);
        this.setScale(wv);
        wv.setInitialScale(3);
        webSettings.setBuiltInZoomControls(false);
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings.setAllowUniversalAccessFromFileURLs(true);
            webSettings.setAllowFileAccessFromFileURLs(true);
        }
        webSettings.setSupportZoom(false);
        wv.setWebViewClient((WebViewClient)new SslWebViewClient());
        if (!TextUtils.isEmpty((CharSequence)url)) {
            wv.loadUrl(url);
        } else if (!TextUtils.isEmpty((CharSequence)data)) {
            wv.loadData(data, "text/html; charset=UTF-8", null);
        }
    }

    private void setScale(WebView wv) {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        int width = wm.getDefaultDisplay().getWidth();
        if (width > 650) {
            wv.setInitialScale(190);
        } else if (width > 520) {
            wv.setInitialScale(160);
        } else if (width > 450) {
            wv.setInitialScale(140);
        } else if (width > 300) {
            wv.setInitialScale(120);
        } else {
            wv.setInitialScale(100);
        }
    }

    protected void onDetachedFromWindow() {
        this.removeView((View)this.mWebView);
        this.mWebView.stopLoading();
        this.mWebView.getSettings().setJavaScriptEnabled(false);
        this.mWebView.clearHistory();
        this.mWebView.removeAllViews();
        this.mWebView.destroy();
        Log.d((String)"WebView", (String)"onDetachedFromWindow");
        super.onDetachedFromWindow();
    }

    public static enum ProgressStyle {
        Horizontal,
        Circle;

    }
}

