/*
 * Decompiled with CFR 0.152.
 */
package cn.bluemobi.dylan.sqlitelibrary;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import cn.bluemobi.dylan.sqlitelibrary.JavaReflectUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLiteDbUtil {
    String[] types = new String[]{"java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Boolean", "java.lang.Character", "java.lang.String", "java.util.Date", "int", "double", "long", "short", "byte", "boolean", "char", "float"};
    private static volatile SQLiteDbUtil sqLiteDbUtil;
    private final String TAG = "SQLiteDbUtil";
    private SQLiteDatabase sqLiteDatabase;
    private Context context;
    private String path;
    private String databaseName;

    private SQLiteDbUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLiteDbUtil getSQLiteDbUtil() {
        if (sqLiteDbUtil != null) return sqLiteDbUtil;
        Class<SQLiteDbUtil> clazz = SQLiteDbUtil.class;
        synchronized (SQLiteDbUtil.class) {
            if (sqLiteDbUtil != null) return sqLiteDbUtil;
            sqLiteDbUtil = new SQLiteDbUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sqLiteDbUtil;
        }
    }

    public void openOrCreateDataBase(Context context) {
        this.openOrCreateDataBase(context, null, null);
    }

    public void openOrCreateDataBase(Context context, String databaseName) {
        this.openOrCreateDataBase(context, null, databaseName);
    }

    public void openOrCreateDataBase(Context context, String path, String databaseName) {
        this.context = context;
        this.path = path;
        this.databaseName = databaseName;
        if (TextUtils.isEmpty((CharSequence)databaseName)) {
            databaseName = "mydb.db";
        }
        if (TextUtils.isEmpty((CharSequence)path)) {
            this.sqLiteDatabase = context.openOrCreateDatabase(databaseName, 0, null);
        } else {
            File dataBaseFile = new File(path, databaseName);
            if (!dataBaseFile.getParentFile().exists()) {
                dataBaseFile.mkdirs();
            }
            this.sqLiteDatabase = SQLiteDatabase.openOrCreateDatabase((File)dataBaseFile, null);
        }
    }

    public SQLiteDatabase getSqLiteDatabase() {
        return this.sqLiteDatabase;
    }

    private void open() throws Exception {
        if (this.sqLiteDatabase == null) {
            throw new Exception("\u672a\u521d\u59cb\u5316\u6570\u636e\u5e93");
        }
        this.openOrCreateDataBase(this.context, this.path, this.databaseName);
    }

    public void close() {
        if (this.sqLiteDatabase != null && this.sqLiteDatabase.isOpen()) {
            this.sqLiteDatabase.close();
        }
    }

    public <T> void createTable(Class<T> c) {
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        String[] column = JavaReflectUtil.getAttributeNames(c);
        Class[] type = JavaReflectUtil.getAttributeType(c);
        String sql = "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + "(";
        sql = sql + "id  Integer PRIMARY KEY AUTOINCREMENT,";
        for (int i = 0; i < column.length; ++i) {
            if ("id".equals(column[i])) continue;
            sql = i != column.length - 1 ? sql + column[i] + " " + type.getClass().getSimpleName() + "," : sql + column[i] + " " + type.getClass().getSimpleName();
        }
        sql = sql + ")";
        this.execSQL(sql);
    }

    public <T> void drop(Class<T> c) {
        if (c == null) {
            return;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        String sql = "DROP TABLE IF EXISTS " + TABLE_NAME;
        this.execSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> long insert(T t) {
        if (t == null) {
            return -1L;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(t.getClass());
        ContentValues contentValues = this.getContentValues(t);
        long num = 0L;
        try {
            this.open();
            num = this.sqLiteDatabase.insert(TABLE_NAME, null, contentValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void insert(List<T> lists) {
        if (lists == null) {
            return;
        }
        try {
            this.open();
            this.sqLiteDatabase.beginTransaction();
            for (T t : lists) {
                String TABLE_NAME = JavaReflectUtil.getClassName(t.getClass());
                ContentValues contentValues = this.getContentValues(t);
                this.sqLiteDatabase.insert(TABLE_NAME, null, contentValues);
            }
            this.sqLiteDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sqLiteDatabase.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int delete(Class<T> c, int id) {
        if (c == null) {
            return 0;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        int num = 0;
        try {
            this.open();
            num = this.sqLiteDatabase.delete(TABLE_NAME, "id=?", new String[]{String.valueOf(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int delete(Class<T> c, String where) {
        if (c == null) {
            return 0;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        int num = 0;
        try {
            this.open();
            num = this.sqLiteDatabase.delete(TABLE_NAME, where, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int deleteAll(Class<T> c) {
        if (c == null) {
            return 0;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        int num = 0;
        try {
            this.open();
            num = this.sqLiteDatabase.delete(TABLE_NAME, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T t, int id) {
        if (t == null) {
            return 0;
        }
        int num = 0;
        try {
            String TABLE_NAME = JavaReflectUtil.getClassName(t.getClass());
            ContentValues contentValues = this.getContentValues(t);
            this.open();
            num = this.sqLiteDatabase.update(TABLE_NAME, contentValues, "id=?", new String[]{String.valueOf(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T t, String where) {
        if (t == null) {
            return -1;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(t.getClass());
        ContentValues contentValues = this.getContentValues(t);
        int num = 0;
        try {
            this.open();
            num = this.sqLiteDatabase.update(TABLE_NAME, contentValues, where, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(Class<T> c, int id) {
        if (c == null) {
            return null;
        }
        String TABLE_NAME = JavaReflectUtil.getClassName(c);
        Cursor cursor = null;
        try {
            this.open();
            cursor = this.sqLiteDatabase.query(TABLE_NAME, null, "id=?", new String[]{String.valueOf(id)}, null, null, null);
            if (cursor == null) {
                T t = null;
                return t;
            }
            if (cursor.moveToNext()) {
                T t = this.newInstance(c, cursor);
                return t;
            }
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(Class<T> c) {
        ArrayList<T> lists = null;
        Cursor cursor = null;
        try {
            if (c == null) {
                List<T> list = null;
                return list;
            }
            this.open();
            String TABLE_NAME = JavaReflectUtil.getClassName(c);
            cursor = this.sqLiteDatabase.query(TABLE_NAME, null, null, null, null, null, null);
            if (cursor == null) {
                List<T> list = null;
                return list;
            }
            lists = new ArrayList<T>();
            while (cursor.moveToNext()) {
                lists.add(this.newInstance(c, cursor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return lists;
    }

    public void execSQL(String sql) {
        try {
            this.open();
            this.sqLiteDatabase.execSQL(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public List<Map<String, Object>> rawQuery(String sql) {
        ArrayList lists = null;
        Cursor cursor = null;
        try {
            this.open();
            cursor = this.sqLiteDatabase.rawQuery(sql, null, null);
            if (cursor == null) {
                List<Map<String, Object>> list = null;
                return list;
            }
            lists = new ArrayList();
            while (cursor.moveToNext()) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String column : cursor.getColumnNames()) {
                    map.put(column, cursor.getString(cursor.getColumnIndex(column)));
                }
                lists.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return lists;
    }

    private <T> T newInstance(Class<T> c, Cursor cursor) {
        try {
            Constructor<T> con = c.getConstructor(new Class[0]);
            con.setAccessible(true);
            T t = con.newInstance(new Object[0]);
            Class[] types = JavaReflectUtil.getAttributeType(c);
            String[] columns = JavaReflectUtil.getAttributeNames(c);
            for (int i = 0; i < types.length; ++i) {
                String column = columns[i];
                Class type = types[i];
                Method method = c.getMethod("set" + column.substring(0, 1).toUpperCase() + column.substring(1), type);
                Object value = null;
                if (type.equals(String.class)) {
                    value = cursor.getString(cursor.getColumnIndex(column));
                } else if (type.equals(Integer.class) || type.getName().equals("int")) {
                    value = cursor.getInt(cursor.getColumnIndex(column));
                } else if (type.equals(Character.class) || type.getName().equals("char")) {
                    value = Character.valueOf(cursor.getString(cursor.getColumnIndex(column)).charAt(0));
                } else if (type.equals(Boolean.class) || type.getName().equals("boolean")) {
                    value = "true".equalsIgnoreCase(cursor.getString(cursor.getColumnIndex(column)));
                } else if (type.equals(Float.class) || type.getName().equals("float")) {
                    value = Float.valueOf(cursor.getFloat(cursor.getColumnIndex(column)));
                } else if (type.equals(Double.class) || type.getName().equals("double")) {
                    value = cursor.getDouble(cursor.getColumnIndex(column));
                } else if (type.equals(Byte.class) || type.getName().equals("byte")) {
                    value = Byte.valueOf(cursor.getString(cursor.getColumnIndex(column)));
                } else if (type.equals(Short.class) || type.getName().equals("short")) {
                    value = cursor.getShort(cursor.getColumnIndex(column));
                } else if (type.equals(Long.class) || type.getName().equals("long")) {
                    value = cursor.getLong(cursor.getColumnIndex(column));
                } else if (type.equals(java.util.Date.class)) {
                    value = new java.util.Date(cursor.getString(cursor.getColumnIndex(column)));
                } else if (type.equals(Date.class)) {
                    value = Date.valueOf(cursor.getString(cursor.getColumnIndex(column)));
                }
                method.invoke(t, value);
            }
            return t;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private <T> ContentValues getContentValues(T t) {
        List<Map<String, Object>> allInfo = JavaReflectUtil.getAllFiledInfo(t);
        ContentValues contentValues = new ContentValues();
        for (int i = 0; i < allInfo.size(); ++i) {
            Map<String, Object> info = allInfo.get(i);
            String column = (String)info.get("name");
            Object value = info.get("value");
            if (value == null) {
                contentValues.putNull(column);
                continue;
            }
            contentValues.put(column, String.valueOf(value));
        }
        contentValues.remove("id");
        return contentValues;
    }
}

