/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Parser;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public final class CommandCompleteParser {
    private long _oid;
    private long _rows;
    private String compatibleLevel = "oracle";

    public CommandCompleteParser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public long getOid() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._oid;
    }

    public long getRows() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._rows;
    }

    void set(long _oid, long _rows) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._oid = _oid;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._rows = _rows;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void parse(String status) throws KSQLException {
        boolean isSpecialOperation;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean bl = isSpecialOperation = status.contains("CALL") || status.contains("ANONYMOUS BLOCK") || status.contains("EXECUTE");
        if (!Parser.isDigitAt(status, status.length() - 1)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.sqlserver(this.compatibleLevel) && isSpecialOperation) {
                this.set(0L, -1L);
            } else {
                this.set(0L, 0L);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _oid = 0L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _rows = 0L;
        if (CompatibleDB.sqlserver(this.compatibleLevel) && isSpecialOperation) {
            _rows = -1L;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int lastSpace = status.lastIndexOf(32);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (Parser.isDigitAt(status, lastSpace + 1)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _rows = Parser.parseLong(status, lastSpace + 1, status.length());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (Parser.isDigitAt(status, lastSpace - 1)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int penultimateSpace = status.lastIndexOf(32, lastSpace - 1);
                    if (Parser.isDigitAt(status, penultimateSpace + 1)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _oid = Parser.parseLong(status, penultimateSpace + 1, lastSpace);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unable to parse the _count in command completion tag: {0}.", status), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.set(_oid, _rows);
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "CommandStatus{oid=" + this._oid + ", rows=" + this._rows + '}';
    }

    public boolean equals(Object o) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this == o) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            v = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == o || this.getClass() != o.getClass()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            v = false;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CommandCompleteParser other = (CommandCompleteParser)o;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._oid != other._oid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._rows == other._rows;
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _result = (int)(this._oid ^ this._oid >>> 32);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _result = 31 * _result + (int)(this._rows ^ this._rows >>> 32);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public String getCompatibleLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.compatibleLevel;
    }

    public void setCompatibleLevel(String compatibleLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.compatibleLevel = compatibleLevel;
    }
}

