/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBProperty;
import com.kingbase8.ssl.LibKCIFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import com.kingbase8.util.TraceLogger;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String socketFactoryClassName = KBProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return SocketFactory.getDefault();
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, KBProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String classname = KBProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.kingbase8.ssl.jdbc4.LibKCIFactory".equals(classname) || "com.kingbase8.ssl.LibKCIFactory".equals(classname)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new LibKCIFactory(info);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, KBProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

