/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.fmkey;

import com.kingbase8.core.KBStream;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class FmKeyAuthenticator {
    private KBStream kbStream;

    public static native int getFmKeyCertAndSignedData(byte[] var0, byte[] var1, int[] var2, byte[] var3, int[] var4, String var5);

    public FmKeyAuthenticator(KBStream kbStream) {
        this.kbStream = kbStream;
    }

    public void signAndSendCert(int len, String pin) throws IOException, KSQLException {
        byte[] randomNumber = this.kbStream.receive(len - 1);
        int certType = this.kbStream.receiveChar();
        byte[] certData = new byte[1024];
        int[] certLength = new int[1];
        byte[] signedData = new byte[1024];
        int[] signedLength = new int[1];
        int ret = FmKeyAuthenticator.getFmKeyCertAndSignedData(randomNumber, certData, certLength, signedData, signedLength, pin == null ? "" : pin);
        switch (ret) {
            case 1: {
                throw new KSQLException(GT.tr("loading lib failed.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 2: {
                throw new KSQLException(GT.tr("could not connect the device.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 3: {
                throw new KSQLException(GT.tr("could not open the device's application.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 4: {
                throw new KSQLException(GT.tr("could not open the application's container.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 6: {
                throw new KSQLException(GT.tr("PIN verification error.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 7: {
                throw new KSQLException(GT.tr("signature failed.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            case 8: {
                throw new KSQLException(GT.tr("could not erport the cert.", new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
        }
        Random random = new Random();
        char[] clientRand = new char[]{(char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1)};
        byte[] clientRandom = new String(clientRand).getBytes();
        signedData = Arrays.copyOfRange(signedData, 0, signedLength[0]);
        certData = Arrays.copyOfRange(certData, 0, certLength[0]);
        this.kbStream.sendChar(99);
        this.kbStream.sendInteger4(16 + signedData.length + certData.length);
        this.kbStream.send(clientRandom);
        this.kbStream.sendInteger42(signedData.length);
        this.kbStream.sendInteger42(certData.length);
        this.kbStream.send(signedData);
        this.kbStream.send(certData);
        this.kbStream.flush();
    }

    static {
        System.loadLibrary("FmKey");
    }
}

