/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.Field;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbRowId;
import com.kingbase8.jdbc.KbStruct;
import com.kingbase8.jdbc.PrimitiveArraySupport;
import com.kingbase8.jdbc.UUIDArrayAssistant;
import com.kingbase8.jdbc2.ArrayAssistant;
import com.kingbase8.jdbc2.ArrayAssistantRegistry;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class KbArray
implements java.sql.Array {
    private static final int INT0 = 0;
    protected BaseConnection _connection = null;
    protected String _fieldString = null;
    private int oid;
    private final boolean useObjectT;
    private static final int INT1 = 1;
    protected KbArrayList arrayListT;
    protected byte[] _fieldBytes;

    private KbArray(BaseConnection _connection, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = _connection;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.oid = oid;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.useObjectT = true;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KbArray(BaseConnection _connection, int oid, String _fieldString) throws SQLException {
        this(_connection, oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fieldString = _fieldString;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KbArray(BaseConnection _connection, int oid, byte[] _fieldBytes) throws SQLException {
        this(_connection, oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fieldBytes = _fieldBytes;
    }

    @Override
    public Object getArray() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Class<?>> map = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arrayImpl = this.getArrayImpl(1L, 0, map);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return arrayImpl;
    }

    @Override
    public Object getArray(long _index, int _count) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Class<?>> map = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arrayImpl = this.getArrayImpl(_index, _count, map);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return arrayImpl;
    }

    public Object getArrayImpl(Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arrayImpl = this.getArrayImpl(1L, 0, map);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return arrayImpl;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arrayImpl = this.getArrayImpl(map);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return arrayImpl;
    }

    @Override
    public Object getArray(long _index, int _count, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arrayImpl = this.getArrayImpl(_index, _count, map);
        return arrayImpl;
    }

    public Object getArrayImpl(long _index, int _count, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (map != null && !map.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index < 1L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The array _index is out of range: {0}", _index), KSQLState.DATA_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._fieldBytes != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.readBinaryArray((int)_index, _count);
        }
        if (this._fieldString == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.buildArrayList();
        if (_count == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _count = this.arrayListT.size();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (--_index + (long)_count > (long)this.arrayListT.size()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The array _index is out of range: {0}, number of elements: {1}.", _index + (long)_count, this.arrayListT.size()), KSQLState.DATA_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object o = this.buildArray(this.arrayListT, (int)_index, _count);
        return o;
    }

    private Object readBinaryArray(int _index, int _count) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dimensions = ByteConverter.int4(this._fieldBytes, 0);
        int elementOid = ByteConverter.int4(this._fieldBytes, 8);
        int position = 12;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] dimsions = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dimsions[d] = ByteConverter.int4(this._fieldBytes, position);
            position += 4;
            position += 4;
        }
        if (dimensions == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Array.newInstance(this.elementOidToCls(elementOid), 0);
        }
        if (_count > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dimsions[0] = Math.min(_count, dimsions[0]);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object arra = Array.newInstance(this.elementOidToCls(elementOid), dimsions);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.storeValues((Object[])arra, elementOid, dimsions, position, 0, _index);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)ioe);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return arra;
    }

    private int storeValues(Object[] arra, int elementOid, int[] dimsions, int position, int thisDimension, int _index) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (thisDimension == dimsions.length - 1) {
            int leng;
            int i;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (i = 1; i < _index; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += leng;
            }
            for (i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue;
                }
                switch (elementOid) {
                    case 7014: 
                    case 8100: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.int1(this._fieldBytes, position);
                        break;
                    }
                    case 21: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.int2(this._fieldBytes, position);
                        break;
                    }
                    case 23: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.int4(this._fieldBytes, position);
                        break;
                    }
                    case 20: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.int8(this._fieldBytes, position);
                        break;
                    }
                    case 700: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = Float.valueOf(ByteConverter.float4(this._fieldBytes, position));
                        break;
                    }
                    case 701: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.float8(this._fieldBytes, position);
                        break;
                    }
                    case 1700: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.numeric(this._fieldBytes, position, leng);
                        break;
                    }
                    case 25: 
                    case 1043: 
                    case 8018: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        Encoding _encoding = this._connection.getEncoding();
                        arra[i] = _encoding.decode(this._fieldBytes, position, leng);
                        break;
                    }
                    case 16: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        arra[i] = ByteConverter.bool(this._fieldBytes, position);
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ArrayAssistant arraAssistant = ArrayAssistantRegistry.getAssistant(elementOid);
                        if (arraAssistant == null) break;
                        arra[i] = arraAssistant.buildElement(this._fieldBytes, position, leng);
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += leng;
            }
        } else {
            int i;
            for (i = 1; i < _index; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position = this.calcRemainingDataLength(dimsions, position, elementOid, thisDimension + 1);
            }
            for (i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position = this.storeValues((Object[])arra[i], elementOid, dimsions, position, thisDimension + 1, 0);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return position;
    }

    private ResultSet readBinaryResultSet(int _index, int _count) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dimensions = ByteConverter.int4(this._fieldBytes, 0);
        int elementOid = ByteConverter.int4(this._fieldBytes, 8);
        int position = 12;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] dimsions = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dimsions[d] = ByteConverter.int4(this._fieldBytes, position);
            position += 4;
            position += 4;
        }
        if (_count > 0 && dimensions > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dimsions[0] = Math.min(_count, dimsions[0]);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] _fields = new Field[2];
        this.storeValues(rows, _fields, elementOid, dimsions, position, 0, _index);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement stat = (BaseStatement)this._connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(_fields, rows);
    }

    private int storeValues(List<byte[][]> rows, Field[] _fields, int elementOid, int[] dimsions, int position, int thisDimension, int _index) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (dimsions.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0] = new Field("INDEX", 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0].setFormat(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1] = new Field("VALUE", elementOid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1].setFormat(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 1; i < _index; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += leng;
            }
        } else if (thisDimension == dimsions.length - 1) {
            int i;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0] = new Field("INDEX", 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0].setFormat(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1] = new Field("VALUE", elementOid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1].setFormat(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (i = 1; i < _index; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += leng;
            }
            for (i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.int4(rowData[0], 0, i + _index);
                rows.add(rowData);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                rowData[1] = new byte[leng];
                System.arraycopy(this._fieldBytes, position, rowData[1], 0, rowData[1].length);
                position += leng;
            }
        } else {
            int i;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0] = new Field("INDEX", 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0].setFormat(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1] = new Field("VALUE", this.oid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1].setFormat(1);
            int nextDimension = thisDimension + 1;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int dimensionsLeft = dimsions.length - nextDimension;
            for (i = 1; i < _index; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position = this.calcRemainingDataLength(dimsions, position, elementOid, nextDimension);
            }
            for (i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i + _index);
                rows.add(rowData);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int dataEndPos = this.calcRemainingDataLength(dimsions, position, elementOid, nextDimension);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int dataLength = dataEndPos - position;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                rowData[1] = new byte[12 + 8 * dimensionsLeft + dataLength];
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.int4(rowData[1], 0, dimensionsLeft);
                System.arraycopy(this._fieldBytes, 4, rowData[1], 4, 8);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                System.arraycopy(this._fieldBytes, 12 + nextDimension * 8, rowData[1], 12, dimensionsLeft * 8);
                System.arraycopy(this._fieldBytes, position, rowData[1], 12 + dimensionsLeft * 8, dataLength);
                position = dataEndPos;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return position;
    }

    private int calcRemainingDataLength(int[] dimsions, int position, int elementOid, int thisDimension) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (thisDimension == dimsions.length - 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int leng = ByteConverter.int4(this._fieldBytes, position);
                position += 4;
                if (leng == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += leng;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < dimsions[thisDimension]; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position = this.calcRemainingDataLength(dimsions, position, elementOid, thisDimension + 1);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return position;
    }

    private Class<?> elementOidToCls(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 23) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Integer.class;
        }
        if (oid == 8100 || oid == 7014) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Byte.class;
        }
        if (oid == 21) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Short.class;
        }
        if (oid == 20) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Long.class;
        }
        if (oid == 25 || oid == 8018 || oid == 1043) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return String.class;
        }
        if (oid == 1700) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return BigDecimal.class;
        }
        if (oid == 700) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Float.class;
        }
        if (oid == 701) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Double.class;
        }
        if (oid == 16) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Boolean.class;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayAssistant arraElemBuilderList = ArrayAssistantRegistry.getAssistant(oid);
        if (arraElemBuilderList != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return arraElemBuilderList.baseType();
        }
        throw Driver.notImplemented(this.getClass(), "readBinaryArray(data,oid)");
    }

    private synchronized void buildArrayList() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.arrayListT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        this.arrayListT = new KbArrayList();
        char delimiter = this._connection.getTypeInfo().getArrayDelimiter(this.oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._fieldString != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char[] characters = this._fieldString.toCharArray();
            StringBuilder _buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ArrayList<KbArrayList> dimsions = new ArrayList<KbArrayList>();
            KbArrayList curArray = this.arrayListT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int startOffsetT = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (characters[0] == '[') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (characters[startOffsetT] != '=') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    ++startOffsetT;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++startOffsetT;
            }
            for (int k = startOffsetT; k < characters.length; ++k) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (characters[k] == '\\') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    ++k;
                } else {
                    if (!insideString && characters[k] == '{') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (dimsions.isEmpty()) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            dimsions.add(this.arrayListT);
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            KbArrayList a = new KbArrayList();
                            KbArrayList p = (KbArrayList)dimsions.get(dimsions.size() - 1);
                            p.add(a);
                            dimsions.add(a);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curArray = (KbArrayList)dimsions.get(dimsions.size() - 1);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        for (int t = k + 1; t < characters.length; ++t) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (Character.isWhitespace(characters[t])) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                continue;
                            }
                            if (characters[t] == '{') {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                ++curArray.dimensionsCountT;
                                continue;
                            }
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            break;
                        }
                        _buffer = new StringBuilder();
                        continue;
                    }
                    if (characters[k] == '\"') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(characters[k])) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                    if (!insideString && (characters[k] == delimiter || characters[k] == '}') || k == characters.length - 1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (characters[k] != '\"' && characters[k] != '}' && characters[k] != delimiter && _buffer != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _buffer.append(characters[k]);
                        }
                        String sb = _buffer == null ? null : _buffer.toString();
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (sb != null && (!sb.isEmpty() || wasInsideString)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            curArray.add(!wasInsideString && sb.equals("NULL") ? null : sb);
                        }
                        wasInsideString = false;
                        _buffer = new StringBuilder();
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (characters[k] != '}') continue;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        dimsions.remove(dimsions.size() - 1);
                        if (!dimsions.isEmpty()) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            curArray = (KbArrayList)dimsions.get(dimsions.size() - 1);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _buffer = null;
                        continue;
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_buffer == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _buffer.append(characters[k]);
            }
        }
    }

    private Object buildArray(KbArrayList input, int _index, int _count) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_count < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _count = input.size();
        }
        Object[] ret = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dimsions = input.dimensionsCountT;
        int[] dimsionsLength = dimsions > 1 ? new int[dimsions] : null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (dimsions > 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < dimsions; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                dimsionsLength[i] = i == 0 ? _count : 0;
            }
        }
        int len = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sqlType = this._connection.getTypeInfo().getSQLType(this._connection.getTypeInfo().getKBArrayElement(this.oid));
        if (sqlType == -7) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Boolean[] oa = null;
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Boolean.class : Boolean.TYPE, dimsionsLength) : new Boolean[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ret = pa = new boolean[_count];
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Boolean.valueOf(BooleanTypeUtil.castToBoolean((String)o, this._connection.getCompatibleLevel())));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (pa != null) {
                        pa[len++] = o == null ? false : BooleanTypeUtil.castToBoolean((String)o, this._connection.getCompatibleLevel());
                    }
                }
                --_count;
            }
        } else if (sqlType == -6) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Byte[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Byte.class : Byte.TYPE, dimsionsLength) : new Byte[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new byte[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Byte.valueOf(KbResultSet.toByte((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? (byte)0 : KbResultSet.toByte((String)o);
                }
                --_count;
            }
        } else if (sqlType == 5) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            short[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Short[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Short.class : Short.TYPE, dimsionsLength) : new Short[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new short[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Short.valueOf(KbResultSet.toShort((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? (short)0 : KbResultSet.toShort((String)o);
                }
                --_count;
            }
        } else if (sqlType == 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Integer[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Integer.class : Integer.TYPE, dimsionsLength) : new Integer[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new int[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Integer.valueOf(KbResultSet.toInt((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? 0 : KbResultSet.toInt((String)o);
                }
                --_count;
            }
        } else if (sqlType == -5) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Long[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Long.class : Long.TYPE, dimsionsLength) : new Long[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new long[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Long.valueOf(KbResultSet.toLong((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? 0L : KbResultSet.toLong((String)o);
                }
                --_count;
            }
        } else if (sqlType == 2 || sqlType == 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            BigDecimal[] oa = null;
            oa = dimsions > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsionsLength) : new BigDecimal[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : KbResultSet.toBigDecimal((String)v));
                --_count;
            }
        } else if (sqlType == 7) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            float[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Float[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Float.class : Float.TYPE, dimsionsLength) : new Float[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new float[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Float.valueOf(KbResultSet.toFloat((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? 0.0f : KbResultSet.toFloat((String)o);
                }
                --_count;
            }
        } else if (sqlType == 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double[] pa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Double[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (dimsions > 1 || this.useObjectT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oa = dimsions > 1 ? (Object[])Array.newInstance(this.useObjectT ? Double.class : Double.TYPE, dimsionsLength) : new Double[_count];
                ret = oa;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pa = new double[_count];
                ret = pa;
            }
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object o = input.get(_index++);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (dimsions > 1 || this.useObjectT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = o == null ? null : (dimsions > 1 ? this.buildArray((KbArrayList)o, 0, -1) : Double.valueOf(KbResultSet.toDouble((String)o)));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pa[len++] = o == null ? 0.0 : KbResultSet.toDouble((String)o);
                }
                --_count;
            }
        } else if (sqlType == 1 || sqlType == 12 || this.oid == 3807 || sqlType == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(String.class, dimsionsLength) : new String[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : v;
                --_count;
            }
        } else if (sqlType == 91) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Date[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(Date.class, dimsionsLength) : new Date[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : this._connection.getTimestampUtils().toDate(null, (String)v));
                --_count;
            }
        } else if (sqlType == 92) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Time[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(Time.class, dimsionsLength) : new Time[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : this._connection.getTimestampUtils().toTime(null, (String)v));
                --_count;
            }
        } else if (sqlType == 93) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Timestamp[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsionsLength) : new Timestamp[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : this._connection.getTimestampUtils().toTimestamp(null, (String)v));
                --_count;
            }
        } else if (sqlType == -8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            RowId[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(RowId.class, dimsionsLength) : new RowId[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : new KbRowId((String)v));
                --_count;
            }
        } else if (ArrayAssistantRegistry.getAssistant(this.oid) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ArrayAssistant arraAssistant = ArrayAssistantRegistry.getAssistant(this.oid);
            Object[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(arraAssistant.baseType(), dimsionsLength) : (Object[])Array.newInstance(arraAssistant.baseType(), _count);
            ret = oa;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : arraAssistant.buildElement((String)v));
                --_count;
            }
        } else if (sqlType == 2002 && "struct".equalsIgnoreCase(((KbConnection)this._connection).getStructType())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Struct[] oa = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oa = dimsions > 1 ? (Object[])Array.newInstance(Struct.class, dimsionsLength) : new Struct[_count];
            ret = oa;
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                oa[len++] = dimsions > 1 && v != null ? this.buildArray((KbArrayList)v, 0, -1) : (v == null ? null : new KbStruct(this._connection, this._connection.getTypeInfo().getKBType(this._connection.getTypeInfo().getKBArrayElement(this.oid)), this._connection.getTypeInfo().getKBArrayElement(this.oid), (String)v));
                --_count;
            }
        } else if (dimsions == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Object[] oa = new Object[_count];
            String typeName = this.getBaseTypeName();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (_count > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = input.get(_index++);
                if (v instanceof String) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = this._connection.getObject(typeName, (String)v, null);
                } else if (v instanceof byte[]) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = this._connection.getObject(typeName, null, (byte[])v);
                } else if (v == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    oa[len++] = null;
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
                }
                --_count;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ret = oa;
        } else {
            KBLOGGER.log(Level.FINEST, "getArrayImpl(long,int,Map) with {0}", this.getBaseTypeName());
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ret;
    }

    @Override
    public int getBaseType() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sqlType = this._connection.getTypeInfo().getSQLType(this.getBaseTypeName());
        return sqlType;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.buildArrayList();
        int elementOID = this._connection.getTypeInfo().getKBArrayElement(this.oid);
        String kbType = this._connection.getTypeInfo().getKBType(elementOID);
        return kbType;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Class<?>> map = null;
        ResultSet resultSetImpl = this.getResultSetImpl(1L, 0, map);
        return resultSetImpl;
    }

    @Override
    public ResultSet getResultSet(long _index, int _count) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Class<?>> map = null;
        ResultSet resultSetImpl = this.getResultSetImpl(_index, _count, map);
        return resultSetImpl;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSetImpl = this.getResultSetImpl(map);
        return resultSetImpl;
    }

    @Override
    public ResultSet getResultSet(long _index, int _count, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSetImpl = this.getResultSetImpl(_index, _count, map);
        return resultSetImpl;
    }

    public ResultSet getResultSetImpl(Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSetImpl = this.getResultSetImpl(1L, 0, map);
        return resultSetImpl;
    }

    public ResultSet getResultSetImpl(long _index, int _count, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (map != null && !map.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index < 1L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The array _index is out of range: {0}", _index), KSQLState.DATA_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._fieldBytes != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.readBinaryResultSet((int)_index, _count);
        }
        this.buildArrayList();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_count == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _count = this.arrayListT.size();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (--_index + (long)_count > (long)this.arrayListT.size()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The array _index is out of range: {0}, number of elements: {1}.", _index + (long)_count, this.arrayListT.size()), KSQLState.DATA_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] _fields = new Field[2];
        if (this.arrayListT.dimensionsCountT <= 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int baseOid = this._connection.getTypeInfo().getKBArrayElement(this.oid);
            _fields[0] = new Field("INDEX", 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1] = new Field("VALUE", baseOid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < _count; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _offset = (int)_index + i;
                byte[][] t = new byte[2][0];
                String v = (String)this.arrayListT.get(_offset);
                t[0] = this._connection._encodeString(Integer.toString(_offset + 1));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                t[1] = v == null ? null : this._connection._encodeString(v);
                rows.add(t);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[0] = new Field("INDEX", 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[1] = new Field("VALUE", this.oid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < _count; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _offset = (int)_index + i;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] t = new byte[2][0];
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object v = this.arrayListT.get(_offset);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                t[0] = this._connection._encodeString(Integer.toString(_offset + 1));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                t[1] = v == null ? null : this._connection._encodeString(this.toString((KbArrayList)v));
                rows.add(t);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement stat = (BaseStatement)this._connection.createStatement(1004, 1007);
        ResultSet driverResultSet = stat.createDriverResultSet(_fields, rows);
        return driverResultSet;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._fieldString == null && this._fieldBytes != null) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object array = this.readBinaryArray(1, 0);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(array);
                if (arraySupport != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._fieldString = arraySupport.toArrayString(this._connection.getTypeInfo().getArrayDelimiter(this.oid), array);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    java.sql.Array tmpArray = this._connection.createArrayOf(this.getBaseTypeName(), (Object[])array);
                    this._fieldString = tmpArray.toString();
                }
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._fieldString = "NULL";
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fieldString;
    }

    private String toString(KbArrayList list) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (list == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder().append('{');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char delimiter = this._connection.getTypeInfo().getArrayDelimiter(this.oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int k = 0; k < list.size(); ++k) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Object vT = list.get(k);
            if (k > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(delimiter);
            }
            if (vT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append("NULL");
                continue;
            }
            if (vT instanceof KbArrayList) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(this.toString((KbArrayList)vT));
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbArray.escapeArrayElement(stringBuilder, (String)vT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append('}');
        String toString = stringBuilder.toString();
        return toString;
    }

    public static void escapeArrayElement(StringBuilder sb, String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sb.append('\"');
        for (int j = 0; j < s.length(); ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sb.append('\\');
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sb.append(c);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sb.append('\"');
    }

    public boolean isBinary() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = this._fieldBytes != null;
        return b;
    }

    public byte[] toBytes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fieldBytes;
    }

    @Override
    public void free() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fieldString = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fieldBytes = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.arrayListT = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayAssistantRegistry.register(2951, new UUIDArrayAssistant());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayAssistantRegistry.register(2950, new UUIDArrayAssistant());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static class KbArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1994539007225602676L;
        int dimensionsCountT = 1;

        private KbArrayList() {
        }
    }
}

