/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;

public class ClobOutputStream
extends OutputStream {
    private Clob largeObj;
    private byte[] _buf;
    private int bsize;
    private int bposition;
    private int clobposition;
    private String _encoding;

    public ClobOutputStream(Clob largeObj, int position, String _encoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.largeObj = largeObj;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.clobposition = position;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bsize = 1024;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._buf = new byte[this.bsize];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bposition = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoding = _encoding;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void write(int b) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition >= this.bsize) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setString(this.clobposition, new String(this._buf, this._encoding));
                this.clobposition += this._buf.length;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.bposition = 0;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._buf[this.bposition++] = (byte)b;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition > 0) {
                this.flush();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str = new String(_buf, this._encoding);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.largeObj.setString(this.clobposition, str.trim());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.clobposition += _buf.length;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void write(byte[] _buf, int off, int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.flush();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            if (off == 0 && leng == _buf.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setString(this.clobposition, new String(_buf, this._encoding));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.clobposition += _buf.length;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setString(this.clobposition, new String(_buf, this._encoding), off, leng);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.clobposition += leng;
            }
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setString(this.clobposition, new String(this._buf, this._encoding), 0, this.bposition);
                this.clobposition += this.bposition;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.bposition = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObj != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.flush();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.largeObj = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    private void checkIsClosed() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObj == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("ClobOutputStream is closed");
        }
    }
}

