/*
 * Decompiled with CFR 0.152.
 */
package cn.com.xuxiaowei.utils.unit;

import cn.com.xuxiaowei.utils.unit.Assert;
import cn.com.xuxiaowei.utils.unit.DataUnit;
import cn.com.xuxiaowei.utils.unit.StringUtils;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataSize
implements Comparable<DataSize>,
Serializable {
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private final long bytes;

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public static DataSize ofBytes(long bytes) {
        return new DataSize(bytes);
    }

    public static DataSize ofKilobytes(long kilobytes) {
        return new DataSize(Math.multiplyExact(kilobytes, 1024L));
    }

    public static DataSize ofMegabytes(long megabytes) {
        return new DataSize(Math.multiplyExact(megabytes, 0x100000L));
    }

    public static DataSize ofGigabytes(long gigabytes) {
        return new DataSize(Math.multiplyExact(gigabytes, 0x40000000L));
    }

    public static DataSize ofTerabytes(long terabytes) {
        return new DataSize(Math.multiplyExact(terabytes, 0x10000000000L));
    }

    public static DataSize of(long amount, DataUnit unit) {
        Assert.notNull((Object)unit, "Unit must not be null");
        return new DataSize(Math.multiplyExact(amount, unit.size().toBytes()));
    }

    public static DataSize parse(CharSequence text) {
        return DataSize.parse(text, null);
    }

    public static DataSize parse(CharSequence text, DataUnit defaultUnit) {
        Assert.notNull(text, "Text must not be null");
        try {
            Matcher matcher = DataSizeUtils.PATTERN.matcher(StringUtils.trimAllWhitespace(text));
            Assert.state(matcher.matches(), "Does not match data size pattern");
            DataUnit unit = DataSizeUtils.determineDataUnit(matcher.group(2), defaultUnit);
            long amount = Long.parseLong(matcher.group(1));
            return DataSize.of(amount, unit);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("'" + text + "' is not a valid data size", ex);
        }
    }

    public boolean isNegative() {
        return this.bytes < 0L;
    }

    public long toBytes() {
        return this.bytes;
    }

    public long toKilobytes() {
        return this.bytes / 1024L;
    }

    public long toMegabytes() {
        return this.bytes / 0x100000L;
    }

    public long toGigabytes() {
        return this.bytes / 0x40000000L;
    }

    public long toTerabytes() {
        return this.bytes / 0x10000000000L;
    }

    @Override
    public int compareTo(DataSize other) {
        return Long.compare(this.bytes, other.bytes);
    }

    public String toString() {
        return String.format("%dB", this.bytes);
    }

    public String toStringUnit() {
        if (this.bytes < 1024L) {
            return String.format("%dB", this.bytes);
        }
        if (this.bytes < 0x100000L) {
            return String.format("%dK", this.bytes / 1024L);
        }
        if (this.bytes < 0x40000000L) {
            return String.format("%dM", this.bytes / 0x100000L);
        }
        if (this.bytes < 0x10000000000L) {
            return String.format("%dG", this.bytes / 0x40000000L);
        }
        return String.format("%dT", this.bytes / 0x10000000000L);
    }

    public String toStringLongUnit() {
        long t;
        if (this.bytes == 0L) {
            return "0B";
        }
        long positive = this.bytes;
        if (this.isNegative()) {
            positive = -this.bytes;
        }
        String tb = (t = positive / 0x10000000000L) > 0L ? t + "T" : "";
        long b = positive % 0x10000000000L;
        long g = b / 0x40000000L;
        String gb = g > 0L ? g + "G" : "";
        long m = (b %= 0x40000000L) / 0x100000L;
        String mb = m > 0L ? m + "M" : "";
        long k = (b %= 0x100000L) / 1024L;
        String kb = k > 0L ? k + "K" : "";
        String bb = (b %= 1024L) > 0L ? b + "B" : "";
        String result = tb + gb + mb + kb + bb;
        return this.isNegative() ? "-" + result : result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataSize otherSize = (DataSize)other;
        return this.bytes == otherSize.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    private static class DataSizeUtils {
        private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");

        private DataSizeUtils() {
        }

        private static DataUnit determineDataUnit(String suffix, DataUnit defaultUnit) {
            DataUnit defaultUnitToUse = defaultUnit != null ? defaultUnit : DataUnit.BYTES;
            return StringUtils.hasLength(suffix) ? DataUnit.fromSuffix(suffix) : defaultUnitToUse;
        }
    }
}

