/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.annotation;

public enum DuplicateStrategy {
    ALERT(new Selector(){

        @Override
        public <K, V> V choose(K key, V oldVal, V newVal) {
            throw new IllegalArgumentException("Duplicate key [" + key + "] has been associated with value [" + oldVal + "], can no longer be associated with [" + newVal + "]");
        }
    }),
    DISCARD_NEW(new Selector(){

        @Override
        public <K, V> V choose(K key, V oldVal, V newVal) {
            return oldVal;
        }
    }),
    DISCARD_OLD(new Selector(){

        @Override
        public <K, V> V choose(K key, V oldVal, V newVal) {
            return newVal;
        }
    }),
    DISCARD(new Selector(){

        @Override
        public <K, V> V choose(K key, V oldVal, V newVal) {
            return null;
        }
    });

    private final Selector selector;

    public <K, V> V choose(K key, V oldVal, V newVal) {
        return this.selector.choose(key, oldVal, newVal);
    }

    private DuplicateStrategy(Selector selector) {
        this.selector = selector;
    }

    @FunctionalInterface
    private static interface Selector {
        public <K, V> V choose(K var1, V var2, V var3);
    }
}

