/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.annotation.condition.ConditionOnContainer;
import cn.crane4j.core.condition.AbstractConditionParser;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import java.lang.reflect.AnnotatedElement;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionOnContainerParser
extends AbstractConditionParser<ConditionOnContainer> {
    private final ContainerManager containerManager;

    public ConditionOnContainerParser(AnnotationFinder annotationFinder, ContainerManager containerManager) {
        super(annotationFinder, ConditionOnContainer.class);
        this.containerManager = containerManager;
    }

    @Override
    protected @NonNull AbstractConditionParser.ConditionDescriptor getConditionDescriptor(ConditionOnContainer annotation) {
        return ((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)AbstractConditionParser.ConditionDescriptor.builder().boundOperationIds(annotation.id())).type(annotation.type())).sort(annotation.sort())).negate(annotation.negate())).build();
    }

    @Override
    protected @Nullable AbstractConditionParser.AbstractCondition createCondition(AnnotatedElement element, ConditionOnContainer annotation) {
        return new ContainerCondition(this.containerManager, annotation.value());
    }

    private static class ContainerCondition
    extends AbstractConditionParser.AbstractCondition {
        private final ContainerManager containerManager;
        private final String[] namespaces;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            return Stream.of(this.namespaces).allMatch(this.containerManager::containsContainer);
        }

        public ContainerCondition(ContainerManager containerManager, String[] namespaces) {
            this.containerManager = containerManager;
            this.namespaces = namespaces;
        }
    }
}

