/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.annotation.condition.ConditionOnProperty;
import cn.crane4j.core.condition.AbstractConditionParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionOnPropertyParser
extends AbstractConditionParser<ConditionOnProperty> {
    private final PropertyOperator propertyOperator;
    private final ConverterManager converterManager;

    public ConditionOnPropertyParser(AnnotationFinder annotationFinder, PropertyOperator propertyOperator, ConverterManager converterManager) {
        super(annotationFinder, ConditionOnProperty.class);
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
    }

    @Override
    protected @Nullable AbstractConditionParser.AbstractCondition createCondition(AnnotatedElement element, ConditionOnProperty annotation) {
        String property = this.getPropertyName(element, annotation);
        boolean convertTypeWhenTest = ClassUtils.isObjectOrVoid(annotation.valueType());
        String expectedValue = convertTypeWhenTest ? annotation.value() : this.converterManager.convert(annotation.value(), annotation.valueType());
        return new PropertyEqualsCondition(property, expectedValue, convertTypeWhenTest, annotation.enableNull());
    }

    @Override
    protected @NonNull AbstractConditionParser.ConditionDescriptor getConditionDescriptor(ConditionOnProperty annotation) {
        return ((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)AbstractConditionParser.ConditionDescriptor.builder().boundOperationIds(annotation.id())).type(annotation.type())).sort(annotation.sort())).negate(annotation.negate())).build();
    }

    private String getPropertyName(AnnotatedElement element, ConditionOnProperty annotation) {
        String property = annotation.property();
        property = ConfigurationUtil.getElementIdentifier(element, property);
        Asserts.isNotEmpty(property, "The property to be checked is not specified in the @{} on {}", this.annotationType.getSimpleName(), element);
        return property;
    }

    protected boolean check(Object expected, Object actual) {
        return Objects.equals(expected, actual);
    }

    private class PropertyEqualsCondition
    extends AbstractConditionParser.AbstractCondition {
        private final String property;
        private final Object expectedValue;
        private final boolean convertTypeWhenTest;
        private final boolean enableNull;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            Object actual = ConditionOnPropertyParser.this.propertyOperator.readProperty(target.getClass(), target, this.property);
            if (Objects.isNull(actual)) {
                return this.enableNull || Objects.isNull(this.expectedValue);
            }
            return this.convertTypeWhenTest ? ConditionOnPropertyParser.this.check(ConditionOnPropertyParser.this.converterManager.convert(this.expectedValue, actual.getClass()), actual) : ConditionOnPropertyParser.this.check(this.expectedValue, actual);
        }

        public PropertyEqualsCondition(String property, Object expectedValue, boolean convertTypeWhenTest, boolean enableNull) {
            this.property = property;
            this.expectedValue = expectedValue;
            this.convertTypeWhenTest = convertTypeWhenTest;
            this.enableNull = enableNull;
        }
    }
}

