/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.annotation.condition.ConditionOnTargetType;
import cn.crane4j.core.condition.AbstractConditionParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.util.Asserts;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionOnTargetTypeParser
extends AbstractConditionParser<ConditionOnTargetType> {
    public ConditionOnTargetTypeParser(AnnotationFinder annotationFinder) {
        super(annotationFinder, ConditionOnTargetType.class);
    }

    @Override
    protected @NonNull AbstractConditionParser.ConditionDescriptor getConditionDescriptor(ConditionOnTargetType annotation) {
        return ((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)AbstractConditionParser.ConditionDescriptor.builder().boundOperationIds(annotation.id())).type(annotation.type())).sort(annotation.sort())).negate(annotation.negate())).build();
    }

    @Override
    protected @Nullable AbstractConditionParser.AbstractCondition createCondition(AnnotatedElement element, ConditionOnTargetType annotation) {
        Asserts.isNotEmpty(annotation.value(), "The expected value is not specified in the @{} on {}", this.annotationType.getSimpleName(), element);
        return annotation.strict() ? new StrictlyTargetTypeCondition(annotation.value()) : new TargetTypeCondition(annotation.value());
    }

    private static class StrictlyTargetTypeCondition
    extends AbstractConditionParser.AbstractCondition {
        private final Class<?>[] types;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            Class<?> targetType = target.getClass();
            return Stream.of(this.types).allMatch(type -> Objects.equals(type, targetType));
        }

        public StrictlyTargetTypeCondition(Class<?>[] types) {
            this.types = types;
        }
    }

    private static class TargetTypeCondition
    extends AbstractConditionParser.AbstractCondition {
        private final Class<?>[] types;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            return Stream.of(this.types).allMatch(type -> type.isInstance(target));
        }

        public TargetTypeCondition(Class<?>[] types) {
            this.types = types;
        }
    }
}

